package com.biz.crm.dms.business.psi.product.sdk.service.productstock;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockDetailPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockDetailVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 商品库存明细vo服务
 * Created by Bao Hongbin on 2022-01-11 14:41.
 */
public interface ProductStockDetailVoService {

  /**
   * 占用库存明细多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<ProductStockDetailVo> findFreezeStockDetailByConditions(Pageable pageable, ProductStockDetailPaginationDto paginationDto);

  /**
   * 库存明细多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<ProductStockDetailVo> findStockOperationDetailByConditions(Pageable pageable, ProductStockDetailPaginationDto paginationDto);

  /**
   * 根据订单编码和行编码查询冻结信息
   * @param orderCode
   * @param orderItemCode
   * @return
   */
  List<ProductStockDetailVo> findFreezeStockDetailByOrderCodeAndOrderItemCode(String orderCode, String orderItemCode);
}
