package com.biz.crm.dms.business.psi.product.sdk.service.productstock;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * Created by Bao Hongbin on 2022-01-12 15:55.
 */
public interface ProductStockVoService {

  /**
   * 多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<ProductStockVo> findByConditions(Pageable pageable, ProductStockPaginationDto paginationDto);

  /**
   * 订单下单冻结库存
   *
   * @param productStockOperationDto 库存操作dto
   * @return 商品库存数据
   */
  ProductStockVo orderFrozen(ProductStockOperationDto productStockOperationDto);

  /**
   * 冻结库存(批量)
   *
   * @param productStockOperationDtos 库存操作dto
   * @return 商品库存数据
   */
  List<ProductStockVo> frozenBatch(List<ProductStockOperationDto> productStockOperationDtos);

  /**
   * 订单关闭解冻库存
   *
   * @param productStockOperationDto 库存操作dto
   * @return 商品库存数据
   */
  ProductStockVo orderCloseThaw(ProductStockOperationDto productStockOperationDto);

  /**
   * 解冻库存（批量）
   * @param productStockOperationDtos
   * @return 商品库存数据
   */
  List<ProductStockVo> thawBatch(List<ProductStockOperationDto> productStockOperationDtos);

  /**
   * 通过商品编码集合和库存类型查询
   * @param productCodes
   * @return
   */
  List<ProductStockVo> findByTypeAndProductCodeIn(List<String> productCodes, String type);

  /**
   * 根据仓库编码和商品编码集合查询库存
   * @param warehouseCode
   * @param productCodes
   * @return
   */
  List<ProductStockVo> findByWarehouseAndProducts(String warehouseCode, Set<String> productCodes);

  /**
   * 根据商品编码查询
   * @param productCodes
   * @return
   */
  List<ProductStockVo> findByProductCodes(List<String> productCodes);
}
