package com.biz.crm.dms.business.psi.product.sdk.vo.productstock;
/**
 * Created by Bao Hongbin on 2022-01-12 15:03.
 */

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @program: crm-dms
 * @description: 发货单库存vo
 * @author: Bao Hongbin
 * @create: 2022-01-12 15:03
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DeliveryStockVo", description = "发货单库存vo")
public class DeliveryStockVo extends TenantFlagOpVo {

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderItemCode;

  /**
   * 库存编码
   */
  @ApiModelProperty("库存编码")
  private String stockCode;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;

  /**
   * 商品层级名称
   */
  @ApiModelProperty("商品层级名称")
  private String productLevelName;

  /**
   * 商品单位
   */
  @ApiModelProperty("商品单位")
  private String productUnit;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 可用库存
   */
  @ApiModelProperty("可用库存")
  private BigDecimal availableStock;

  /**
   * 冻结库存
   */
  @ApiModelProperty("冻结库存")
  private BigDecimal frozenStock;

  /**
   * 全部库存
   */
  @ApiModelProperty("全部库存")
  private BigDecimal totalStock;

  /**
   * 安全库存
   */
  @ApiModelProperty("安全库存")
  private BigDecimal securityStock;

  /**
   * 默认仓库(true:是,false:否)
   */
  @ApiModelProperty("默认仓库(true:是,false:否)")
  private Boolean warehouseDefault;

  /**
   * 冻结库存明细
   */
  @ApiModelProperty("冻结库存明细")
  private BigDecimal frozenQuantity;
}
