package com.biz.crm.dms.business.psi.product.sdk.vo.productstock;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商品安全库存数量适用仓库vo
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductSecurityStockQuantityWarehouseVo", description = "商品安全库存数量适用仓库vo")
public class ProductSecurityStockQuantityWarehouseVo extends TenantOpVo {


  /**
   * 安全库存数量id
   */
  @ApiModelProperty("安全库存数量id")
  private String securityStockQuantityId;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;


}
