package com.biz.crm.dms.business.psi.product.sdk.vo.productstock;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * <p>
 * 商品安全库存vo
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductSecurityStockVo", description = "商品安全库存vo")
public class ProductSecurityStockVo extends TenantFlagOpVo {


  /**
   * id
   */
  @ApiModelProperty("id")
  private String id;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;

  /**
   * 商品层级名称
   */
  @ApiModelProperty("商品层级名称")
  private String productLevelName;

  /**
   * 商品规格
   */
  @ApiModelProperty("商品规格")
  private String productSpec;

  /**
   * 商品单位
   */
  @ApiModelProperty("商品单位")
  private String productUnit;

  /**
   * 商品安全库存数量vos
   */
  @ApiModelProperty("商品安全库存数量vos")
  private List<ProductSecurityStockQuantityVo> quantityVos;
}
