package com.biz.crm.dms.business.psi.product.sdk.vo.productstock;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * <p>
 * 商品库存明细vo
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductSecurityStockVo", description = "商品库存明细vo")
public class ProductStockDetailVo extends TenantOpVo {


  /**
   * 库存id
   */
  @ApiModelProperty("库存id")
  private String stockId;

  /**
   * 库存编码
   */
  @ApiModelProperty("库存编码")
  private String stockCode;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

/**
 * 商品单位
 */
  @ApiModelProperty("商品单位")
  private String productUnit;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 商品库存操作
   */
  @ApiModelProperty("商品库存操作")
  private ProductStockOperation productStockOperation;

  /**
   * 商品库存操作类型
   */
  @ApiModelProperty("商品库存操作类型")
  private String productStockOperationType;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  private String originalOrderCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 订单编号
   */
  @ApiModelProperty("订单编号")
  private String orderCode;

  /**
   * 订单行编号
   */
  @ApiModelProperty("订单行编号")
  private String orderItemCode;

  /**
   * 关联商品库存单据类型
   */
  @ApiModelProperty("关联商品库存单据类型")
  private String billType;

  /**
   * 关联商品库存单据编号
   */
  @ApiModelProperty("关联商品库存单据编号")
  private String billCode;

  /**
   * 本单库存操作商品数量
   */
  @ApiModelProperty("本单库存操作商品数量")
  private BigDecimal stockQuantity;

  /**
   * 总库存商品数量;记录的是本次操作完成后的库存商品总量
   */
  @ApiModelProperty("总库存商品数量")
  private BigDecimal totalStockQuantity;

  /**
   * 本单占用库存商品数量
   */
  @ApiModelProperty("本单占用库存商品数量")
  private BigDecimal frozenQuantity;

  /**
   * 总占用库存商品数量;记录的是本次操作完成后的库存商品占用总量
   */
  @ApiModelProperty("总占用库存商品数量")
  private BigDecimal totalFrozenQuantity;

}
