package com.biz.crm.dms.business.psi.product.sdk.vo.store;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * <p>
 * 商品入库单明细vo
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductStoredBillDetailVo", description = "商品入库单明细vo")
public class ProductStoredBillDetailVo extends TenantOpVo {


  /**
   * 入库单id
   */
  @ApiModelProperty("入库单id")
  private String storedBillId;

  /**
   * 入库单编码
   */
  @ApiModelProperty("入库单编码")
  private String storedBillCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  private String originalOrderCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 行项目类型
   */
  @ApiModelProperty("行项目类型")
  private String itemType;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 物料类别
   */
  @ApiModelProperty("物料类别")
  private String materialType;

  /**
   * 物料类别名称
   */
  @ApiModelProperty("物料类别名称")
  private String materialTypeName;

  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;

  /**
   * 商品层级名称
   */
  @ApiModelProperty("商品层级名称")
  private String productLevel;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 商品规格
   */
  @ApiModelProperty("商品规格")
  private String productSpec;

  /**
   * 商品单位
   */
  @ApiModelProperty("商品单位")
  private String productUnit;

  /**
   * 收货单行项id
   */
  @ApiModelProperty("收货单行项id")
  private String receivingItemId;

  /**
   * 收货单行项总数
   */
  @ApiModelProperty("收货单行项总数")
  private BigDecimal receivingItemQuantity;

  /**
   * 入库数
   */
  @ApiModelProperty("入库数")
  private BigDecimal storedQuantity;


}
