/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.sdk.context.store;

import com.biz.crm.dms.business.psi.product.sdk.register.store.StoredBillProductStockRegister;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StoredBillProductStockContext {
    private static final Map<String, StoredBillProductStockRegister> REGISTERS_CACHE = new ConcurrentHashMap<String, StoredBillProductStockRegister>();

    @Autowired(required=false)
    public StoredBillProductStockContext(List<StoredBillProductStockRegister> storedBillProductStockRegisters) {
        if (CollectionUtils.isNotEmpty(storedBillProductStockRegisters)) {
            for (StoredBillProductStockRegister storedBillProductStockRegister : storedBillProductStockRegisters) {
                REGISTERS_CACHE.put(storedBillProductStockRegister.getOperationType(), storedBillProductStockRegister);
            }
        }
    }

    public StoredBillProductStockRegister getRegisterByOperationType(String operationType) {
        if (StringUtils.isBlank((CharSequence)operationType)) {
            return null;
        }
        if (CollectionUtils.isEmpty(REGISTERS_CACHE.values())) {
            return null;
        }
        return REGISTERS_CACHE.get(operationType);
    }
}

