package com.biz.crm.dms.business.rebate.local.service.internal;

import com.biz.crm.common.form.sdk.DynamicFieldConfiguration;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.DynamicFormServiceBuilder;
import com.biz.crm.dms.business.rebate.local.service.register.criterionregister.configurable.SaleVolumeCriterionImpl;
import com.biz.crm.dms.business.rebate.sdk.service.CriterionVoService;
import com.biz.crm.dms.business.rebate.sdk.vo.dynamic.AbstractCriterionVo;
import com.biz.crm.dms.business.rebate.sdk.vo.dynamic.ConfigurableCriterionVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 返利变量Vo
 *
 * @author hefan
 * @date 2022/06/23
 */
@Service
public class CriterionVoServiceImpl implements CriterionVoService {

  @Autowired(required = false)
  private ApplicationContext applicationContext;

  @Override
  public AbstractCriterionVo findByPolicyCodeAndCriterionCode(String saleRebatePolicyCode, String saleRebatePolicyCriterionCode) {
    /**
     * - 只查询入参返利变量的信息
     * - 按入参有限构造动态表单服务
     */
    DynamicFormServiceBuilder<ConfigurableCriterionVo> dynamicFormServiceBuilder = applicationContext.getBean(DynamicFormServiceBuilder.class , ConfigurableCriterionVo.class , this.applicationContext);
    DynamicFieldConfiguration<ConfigurableCriterionVo> dynamicFieldConfiguration = dynamicFormServiceBuilder.dynamicField("criterionMap");
    if (StringUtils.startsWith(saleRebatePolicyCriterionCode, SaleVolumeCriterionImpl.REBATE_POLICY_CRITERION_CODE)) {
      dynamicFieldConfiguration.addDynamicMapping(SaleVolumeCriterionImpl.REBATE_POLICY_CRITERION_CODE, SaleVolumeCriterionImpl.REBATE_POLICY_CRITERION_CODE);
    } else {
      return null;
    }
    DynamicFormService<ConfigurableCriterionVo> dynamicFormService = dynamicFieldConfiguration.config().build();
    // 开始做动态表单数据的详情查询
    ConfigurableCriterionVo configurableCriterionVo = new ConfigurableCriterionVo();
    dynamicFormService.perfectDynamicDetails(configurableCriterionVo, saleRebatePolicyCode);
    Map<String, List<AbstractCriterionVo>> criterionMap = configurableCriterionVo.getCriterionMap();
    List<AbstractCriterionVo> abstractCriterionVos;
    if (StringUtils.startsWith(saleRebatePolicyCriterionCode, SaleVolumeCriterionImpl.REBATE_POLICY_CRITERION_CODE)) {
      abstractCriterionVos = criterionMap.get(SaleVolumeCriterionImpl.REBATE_POLICY_CRITERION_CODE);
    } else{
      abstractCriterionVos = Lists.newArrayList();
    }
    Optional<AbstractCriterionVo> first = abstractCriterionVos.stream()
        .filter(vo -> vo.getInstanceCode().startsWith(saleRebatePolicyCriterionCode))
        .findFirst();
    return first.get();
  }
}
