/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebateAdjustDetail;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebateCalculationLog;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicy;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyCheckProductInfo;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyDetail;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyFormulaInfo;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyProductInfo;
import com.biz.crm.dms.business.rebate.local.service.SaleRebateAdjustDetailService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebateCalculationLogService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyCalculateService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyCheckProductInfoService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyDetailService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyFormulaInfoService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyProductInfoService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyVoService;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebatePolicyCalculateUtil;
import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.biz.crm.dms.business.rebate.sdk.enums.SaleOnAccountStatusEnums;
import com.biz.crm.dms.business.rebate.sdk.enums.SaleRebatePolicyProductTypeEnum;
import com.biz.crm.dms.business.rebate.sdk.enums.SaleRebatePolicyStatusEnum;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCycleRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyTemplateRegister;
import com.biz.crm.dms.business.rebate.sdk.strategy.SaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateComputeBuildParamVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateComputeParamVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateConditionResultVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateExecutionDateRangeVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateFormulaResultVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyFormulaInfoVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyProductInfoVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.common.vo.UuidVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleRebatePolicyCalculateServiceImpl
implements SaleRebatePolicyCalculateService {
    @Autowired(required=false)
    private SaleRebatePolicyVoService saleRebatePolicyVoService;
    @Autowired(required=false)
    private SaleRebatePolicyDetailService saleRebatePolicyDetailService;
    @Autowired(required=false)
    private List<SaleRebatePolicyCycleRegister> saleRebatePolicyCycleRegisters;
    @Autowired(required=false)
    private List<SaleRebatePolicyTemplateRegister> saleRebatePolicyTemplateRegisters;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private SaleRebatePolicyCheckProductInfoService saleRebatePolicyCheckProductInfoService;
    @Autowired(required=false)
    private SaleRebatePolicyProductInfoService saleRebatePolicyProductInfoService;
    @Autowired(required=false)
    private SaleRebatePolicyFormulaInfoService saleRebatePolicyFormulaInfoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private SaleRebateCalculationLogService saleRebateCalculationLogService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SaleRebatePolicyService saleRebatePolicyService;
    @Autowired(required=false)
    private List<SaleRebatePolicyCriterionRegister> saleRebatePolicyCriterionRegisters;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SaleRebateAdjustDetailService saleRebateAdjustDetailService;

    @Override
    @Transactional
    public void onCalculateByCode(List<String> saleRebatePolicyCodes, String isTest, Date date) {
        List<SaleRebatePolicyVo> saleRebatePolicyVos = this.saleRebatePolicyVoService.findByCodes(saleRebatePolicyCodes);
        Validate.isTrue((org.apache.commons.collections.CollectionUtils.isNotEmpty(saleRebatePolicyVos) && saleRebatePolicyVos.size() == saleRebatePolicyCodes.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List saleRebatePolicyVoList = saleRebatePolicyVos.stream().filter(saleRebatePolicyVo -> saleRebatePolicyVo.getEnableStatus().equals(EnableStatusEnum.DISABLE.getCode())).collect(Collectors.toList());
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(saleRebatePolicyVoList), (String)"\u8fd4\u5229\u653f\u7b56\u8ba1\u7b97\u4e2d\u5b58\u5728\u5df2\u7981\u7528\u6570\u636e\uff01", (Object[])new Object[0]);
        Map<String, SaleRebateExecutionDateRangeVo> dateRangeVoHashMap = this.getSaleRebateExecutionDateRangeVoMap(saleRebatePolicyVos, date);
        if (Objects.isNull(dateRangeVoHashMap)) {
            return;
        }
        Map<String, Set<String>> customerCodeMap = this.getCustomerCodeMap(saleRebatePolicyCodes);
        Map<String, Set<String>> checkproductCodeMap = this.getProductCodeMap(saleRebatePolicyCodes);
        Map<String, List<SaleRebatePolicyFormulaInfoVo>> formulalistMap = this.getSaleRebatePolicyFormulaInfoMap(saleRebatePolicyCodes);
        Map<String, List<SaleRebatePolicyProductInfoVo>> rebateproductCodeMap = this.getSaleRebatePolicyProductInfoMap(saleRebatePolicyCodes);
        this.buildAndCreateParam(saleRebatePolicyVos, customerCodeMap, checkproductCodeMap, dateRangeVoHashMap, rebateproductCodeMap, formulalistMap, isTest);
        if (BooleanEnum.FALSE.getNumStr().equals(isTest)) {
            saleRebatePolicyVos.forEach(saleRebatePolicyVo -> {
                String saleRebatePolicyCode = saleRebatePolicyVo.getSaleRebatePolicyCode();
                SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = (SaleRebateExecutionDateRangeVo)dateRangeVoHashMap.get(saleRebatePolicyCode);
                if (Objects.nonNull(saleRebateExecutionDateRangeVo)) {
                    if (saleRebateExecutionDateRangeVo.getSaleRebateEndTime().compareTo(saleRebatePolicyVo.getSaleRebateEndTime()) >= 0) {
                        this.saleRebatePolicyService.updateSaleRebatePolicyStatus(saleRebatePolicyVo.getId(), SaleRebatePolicyStatusEnum.COMPLETED);
                    } else {
                        this.saleRebatePolicyService.updateSaleRebatePolicyStatus(saleRebatePolicyVo.getId(), SaleRebatePolicyStatusEnum.ON_EXECUTION);
                    }
                }
            });
        }
    }

    @Override
    @Transactional
    public void onCalculateByDetailIds(List<String> detailIds) {
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty(detailIds) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<SaleRebatePolicyDetail> saleRebatePolicyDetails = this.saleRebatePolicyDetailService.findByIds(detailIds);
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty(saleRebatePolicyDetails) && saleRebatePolicyDetails.size() == detailIds.size() ? 1 : 0) != 0, (String)"\u8fd4\u5229\u8ba1\u7b97\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List collect = saleRebatePolicyDetails.stream().filter(saleRebatePolicyDetail -> SaleOnAccountStatusEnums.ON_ACCOUNT.getKey().equals(saleRebatePolicyDetail.getBillStatus())).collect(Collectors.toList());
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(collect), (String)"\u5df2\u4e0a\u8d26\u6570\u636e\u4e0d\u80fd\u8fdb\u884c\u8fd4\u5229\u8ba1\u7b97", (Object[])new Object[0]);
        List<String> saleRebatePolicyCodes = saleRebatePolicyDetails.stream().map(SaleRebatePolicyDetail::getSaleRebatePolicyCode).collect(Collectors.toList());
        List<SaleRebatePolicy> saleRebatePolicies = this.saleRebatePolicyService.findBySaleRebatePolicyCodes(saleRebatePolicyCodes);
        List saleRebatePolicyVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(saleRebatePolicies, SaleRebatePolicy.class, SaleRebatePolicyVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, SaleRebatePolicyVo> saleRebatePolicyVoMap = saleRebatePolicyVos.stream().collect(Collectors.toMap(SaleRebatePolicyVo::getSaleRebatePolicyCode, item -> item));
        Map<String, Set<String>> checkproductCodeMap = this.getProductCodeMap(saleRebatePolicyCodes);
        List<String> formulaIds = saleRebatePolicyDetails.stream().map(SaleRebatePolicyDetail::getSaleRebatePolicyFormulaId).collect(Collectors.toList());
        List<SaleRebatePolicyFormulaInfo> saleRebatePolicyFormulaInfos = this.saleRebatePolicyFormulaInfoService.findByIds(formulaIds);
        List saleRebatePolicyFormulaInfoVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(saleRebatePolicyFormulaInfos, SaleRebatePolicyFormulaInfo.class, SaleRebatePolicyFormulaInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, SaleRebatePolicyFormulaInfoVo> saleRebatePolicyFormulaInfoVoMap = saleRebatePolicyFormulaInfoVos.stream().collect(Collectors.toMap(UuidVo::getId, item -> item));
        Set customerCodes = saleRebatePolicyDetails.stream().map(SaleRebatePolicyDetail::getCustomerCode).collect(Collectors.toSet());
        List customerVos = this.customerVoService.findForPriceByCustomerCodes(customerCodes);
        Map<String, CustomerVo> customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, item -> item));
        Date date = new Date();
        ArrayList<SaleRebateComputeParamVo> paramVos = new ArrayList<SaleRebateComputeParamVo>();
        for (SaleRebatePolicyDetail saleRebatePolicyDetail2 : saleRebatePolicyDetails) {
            SaleRebateComputeParamVo saleRebateComputeParamVo = new SaleRebateComputeParamVo();
            saleRebateComputeParamVo.setSpeedNo(saleRebatePolicyDetail2.getSpeedNo());
            saleRebateComputeParamVo.setProductType(saleRebatePolicyDetail2.getProductType());
            saleRebateComputeParamVo.setSaleRebatePolicyDetailId(saleRebatePolicyDetail2.getId());
            saleRebateComputeParamVo.setSaleRebateDetailCode(saleRebatePolicyDetail2.getSaleRebateDetailCode());
            if (saleRebatePolicyDetail2.getProductType() != null) {
                if (SaleRebatePolicyProductTypeEnum.PRODUCT.getKey().equals(saleRebatePolicyDetail2.getProductType())) {
                    saleRebateComputeParamVo.setCode(saleRebatePolicyDetail2.getProductCode());
                    saleRebateComputeParamVo.setName(saleRebatePolicyDetail2.getProductName());
                } else {
                    saleRebateComputeParamVo.setCode(saleRebatePolicyDetail2.getProductLevelCode());
                    saleRebateComputeParamVo.setName(saleRebatePolicyDetail2.getProductLevelName());
                }
            }
            saleRebateComputeParamVo.setAllocationType(saleRebatePolicyDetail2.getAllocationType());
            saleRebateComputeParamVo.setRebateRatio(saleRebatePolicyDetail2.getRebateRatio());
            SaleRebatePolicyVo saleRebatePolicyVo = saleRebatePolicyVoMap.get(saleRebatePolicyDetail2.getSaleRebatePolicyCode());
            Validate.notNull((Object)saleRebatePolicyVo, (String)"\u4e0d\u5b58\u5728\u542f\u7528\u5f97\u8fd4\u5229\u653f\u7b56\uff01", (Object[])new Object[0]);
            saleRebateComputeParamVo.setSaleRebateStartTime(saleRebatePolicyVo.getSaleRebateStartTime());
            saleRebateComputeParamVo.setSaleRebateEndTime(saleRebatePolicyVo.getSaleRebateEndTime());
            saleRebateComputeParamVo.setSaleRebateComputeEndTime(saleRebatePolicyDetail2.getSaleRebateEndTime());
            saleRebateComputeParamVo.setSaleRebateComputeStartTime(saleRebatePolicyDetail2.getSaleRebateStartTime());
            saleRebateComputeParamVo.setCalculationTime(date);
            saleRebateComputeParamVo.setIsTest(saleRebatePolicyDetail2.getIsTest());
            SaleRebatePolicyFormulaInfoVo saleRebatePolicyFormulaInfoVo = saleRebatePolicyFormulaInfoVoMap.get(saleRebatePolicyDetail2.getSaleRebatePolicyFormulaId());
            saleRebateComputeParamVo.setSaleRebatePolicyFormulaInfoVo(saleRebatePolicyFormulaInfoVo);
            Set<String> productCodes = checkproductCodeMap.get(saleRebatePolicyDetail2.getSaleRebatePolicyCode());
            Map<String, BigDecimal> amountMap = this.getAmountMap(saleRebatePolicyFormulaInfoVo, productCodes, saleRebatePolicyDetail2.getCustomerCode(), saleRebatePolicyDetail2, saleRebateComputeParamVo);
            saleRebateComputeParamVo.setAmountMap(amountMap);
            saleRebateComputeParamVo.setSaleRebatePolicyVo(saleRebatePolicyVo);
            if (Objects.isNull(customerVoMap)) {
                return;
            }
            CustomerVo customerVo = customerVoMap.get(saleRebatePolicyDetail2.getCustomerCode());
            if (Objects.isNull(customerVo)) {
                return;
            }
            saleRebateComputeParamVo.setCusJson(JsonUtils.toJSONObject((Object)customerVo));
            paramVos.add(saleRebateComputeParamVo);
        }
        this.onCalculate(paramVos);
    }

    private void buildAndCreateParam(List<SaleRebatePolicyVo> saleRebatePolicyVos, Map<String, Set<String>> customerCodeMap, Map<String, Set<String>> checkproductCodeMap, Map<String, SaleRebateExecutionDateRangeVo> dateRangeVoHashMap, Map<String, List<SaleRebatePolicyProductInfoVo>> rebateproductCodeMap, Map<String, List<SaleRebatePolicyFormulaInfoVo>> formulalistMap, String isTest) {
        if (Objects.isNull(dateRangeVoHashMap) && BooleanEnum.FALSE.getNumStr().equals(isTest)) {
            return;
        }
        List<SaleRebatePolicyTemplateRegister> templateRegisters = this.getSaleRebatePolicyTemplateRegisters(saleRebatePolicyVos);
        List<SaleRebateComputeBuildParamVo> saleRebateComputeBuildParamVos = this.buildParamSaleRebateCodeVo(saleRebatePolicyVos, customerCodeMap, checkproductCodeMap, dateRangeVoHashMap, rebateproductCodeMap, formulalistMap, isTest);
        Map<String, List<SaleRebateComputeBuildParamVo>> saleRebateComputeBuildParamMap = saleRebateComputeBuildParamVos.stream().collect(Collectors.groupingBy(SaleRebateComputeBuildParamVo::getSaleRebateType));
        templateRegisters.forEach(saleRebatePolicyTemplateRegister -> {
            List computeBuildParamVos = (List)saleRebateComputeBuildParamMap.get(saleRebatePolicyTemplateRegister.getSaleRebatePolicytemplateCode());
            List saleRebateComputeParamVos = saleRebatePolicyTemplateRegister.onbuildParam(computeBuildParamVos);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)saleRebateComputeParamVos)) {
                saleRebateComputeParamVos.forEach(saleRebateComputeParamVo -> saleRebateComputeParamVo.setIsTest(isTest));
            }
            this.onCalculate(saleRebateComputeParamVos);
        });
    }

    private Map<String, List<SaleRebatePolicyFormulaInfoVo>> getSaleRebatePolicyFormulaInfoMap(List<String> saleRebatePolicyCodes) {
        List<SaleRebatePolicyFormulaInfo> saleRebatePolicyFormulaInfos = this.saleRebatePolicyFormulaInfoService.findBySaleRebatePolicyCodes(saleRebatePolicyCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(saleRebatePolicyFormulaInfos)) {
            return null;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(saleRebatePolicyFormulaInfos, SaleRebatePolicyFormulaInfo.class, SaleRebatePolicyFormulaInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
        return list.stream().collect(Collectors.groupingBy(SaleRebatePolicyFormulaInfoVo::getSaleRebatePolicyCode));
    }

    private Map<String, List<SaleRebatePolicyProductInfoVo>> getSaleRebatePolicyProductInfoMap(List<String> saleRebatePolicyCodes) {
        HashMap<String, List<SaleRebatePolicyProductInfoVo>> listMap = new HashMap<String, List<SaleRebatePolicyProductInfoVo>>();
        List<SaleRebatePolicyProductInfo> saleRebatePolicyProductInfos = this.saleRebatePolicyProductInfoService.findBySaleRebatePolicyCodes(saleRebatePolicyCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(saleRebatePolicyProductInfos)) {
            return listMap;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(saleRebatePolicyProductInfos, SaleRebatePolicyProductInfo.class, SaleRebatePolicyProductInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
        return list.stream().collect(Collectors.groupingBy(SaleRebatePolicyProductInfoVo::getSaleRebatePolicyCode));
    }

    private Map<String, SaleRebateExecutionDateRangeVo> getSaleRebateExecutionDateRangeVoMap(List<SaleRebatePolicyVo> saleRebatePolicyVos, Date date) {
        HashMap<String, SaleRebateExecutionDateRangeVo> listMap = new HashMap<String, SaleRebateExecutionDateRangeVo>();
        saleRebatePolicyVos.forEach(saleRebatePolicyVo -> {
            List registers = this.saleRebatePolicyCycleRegisters.stream().filter(saleRebatePolicyCycleRegister -> saleRebatePolicyCycleRegister.getSaleRebatePolicyCycleCode().equals(saleRebatePolicyVo.getSaleRebatePolicyCycle())).collect(Collectors.toList());
            Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(registers), (String)"\u65e0\u53ef\u7528\u7684\u8fd4\u5229\u5468\u671f\u7ef4\u5ea6\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
            SaleRebatePolicyCycleRegister saleRebatePolicyCycleRegister2 = (SaleRebatePolicyCycleRegister)registers.get(0);
            SaleRebatePolicyDto saleRebatePolicyDto = (SaleRebatePolicyDto)this.nebulaToolkitService.copyObjectByWhiteList(saleRebatePolicyVo, SaleRebatePolicyDto.class, HashSet.class, ArrayList.class, new String[0]);
            saleRebatePolicyDto.setCalculateTime(date);
            SaleRebateExecutionDateRangeVo executionDateRangeVo = saleRebatePolicyCycleRegister2.getExecutionDateRangeVo(saleRebatePolicyDto);
            if (!Objects.isNull(executionDateRangeVo)) {
                listMap.put(saleRebatePolicyVo.getSaleRebatePolicyCode(), executionDateRangeVo);
            }
        });
        return listMap.size() > 0 ? listMap : null;
    }

    private List<SaleRebatePolicyTemplateRegister> getSaleRebatePolicyTemplateRegisters(List<SaleRebatePolicyVo> saleRebatePolicyVos) {
        Set saleRebateTypes = saleRebatePolicyVos.stream().map(SaleRebatePolicyVo::getSaleRebateType).collect(Collectors.toSet());
        List<SaleRebatePolicyTemplateRegister> templateRegisters = this.saleRebatePolicyTemplateRegisters.stream().filter(saleRebatePolicyTemplateRegister -> saleRebateTypes.contains(saleRebatePolicyTemplateRegister.getSaleRebatePolicytemplateCode())).collect(Collectors.toList());
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(templateRegisters), (String)"\u8fd4\u5229\u7c7b\u578b\u6ce8\u518c\u5668\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        return templateRegisters;
    }

    private List<SaleRebateComputeBuildParamVo> buildParamSaleRebateCodeVo(List<SaleRebatePolicyVo> saleRebatePolicyVos, Map<String, Set<String>> customerCodeMap, Map<String, Set<String>> checkproductCodeMap, Map<String, SaleRebateExecutionDateRangeVo> dateRangeVoHashMap, Map<String, List<SaleRebatePolicyProductInfoVo>> rebateproductCodeMap, Map<String, List<SaleRebatePolicyFormulaInfoVo>> formulalistMap, String isTest) {
        Date date = new Date();
        ArrayList<SaleRebateComputeBuildParamVo> saleRebateComputeBuildParamVos = new ArrayList<SaleRebateComputeBuildParamVo>();
        saleRebatePolicyVos.forEach(saleRebatePolicyVo -> {
            String speedNo = (String)this.generateCodeService.generateCode("FLPC", 1).get(0);
            SaleRebateExecutionDateRangeVo saleRebateExecutionDate = (SaleRebateExecutionDateRangeVo)dateRangeVoHashMap.get(saleRebatePolicyVo.getSaleRebatePolicyCode());
            if (Objects.isNull(saleRebateExecutionDate) && BooleanEnum.FALSE.getNumStr().equals(isTest)) {
                return;
            }
            if (Objects.isNull(saleRebateExecutionDate)) {
                saleRebateExecutionDate = new SaleRebateExecutionDateRangeVo();
                saleRebateExecutionDate.setSaleRebateStartTime(new Date());
                saleRebateExecutionDate.setSaleRebateEndTime(new Date());
            }
            SaleRebateComputeBuildParamVo saleRebateComputeBuildParamVo = new SaleRebateComputeBuildParamVo();
            saleRebateComputeBuildParamVo.setSaleRebatePolicyVo(saleRebatePolicyVo);
            saleRebateComputeBuildParamVo.setSaleRebateStartTime(saleRebateExecutionDate.getSaleRebateStartTime());
            saleRebateComputeBuildParamVo.setSaleRebateEndTime(saleRebateExecutionDate.getSaleRebateEndTime());
            saleRebateComputeBuildParamVo.setCustomerCodes((Set)customerCodeMap.get(saleRebatePolicyVo.getSaleRebatePolicyCode()));
            saleRebateComputeBuildParamVo.setProductCodes((Set)checkproductCodeMap.get(saleRebatePolicyVo.getSaleRebatePolicyCode()));
            saleRebateComputeBuildParamVo.setSaleRebateType(saleRebatePolicyVo.getSaleRebateType());
            saleRebateComputeBuildParamVo.setSaleRebatePolicyProductInfoVos((List)rebateproductCodeMap.get(saleRebatePolicyVo.getSaleRebatePolicyCode()));
            saleRebateComputeBuildParamVo.setSaleRebatePolicyFormulaInfoVos((List)formulalistMap.get(saleRebatePolicyVo.getSaleRebatePolicyCode()));
            saleRebateComputeBuildParamVo.setSpeedNo(speedNo);
            saleRebateComputeBuildParamVo.setCalculationTime(date);
            saleRebateComputeBuildParamVos.add(saleRebateComputeBuildParamVo);
        });
        return saleRebateComputeBuildParamVos;
    }

    private void onCalculate(List<SaleRebateComputeParamVo> params) {
        params.forEach(param -> {
            SaleRebatePolicyCalculateUtil.validateCal(param);
            SaleRebatePolicyFormulaInfoVo saleRebatePolicyFormulaInfoVo = param.getSaleRebatePolicyFormulaInfoVo();
            SaleRebatePolicyVo saleRebatePolicyVo = param.getSaleRebatePolicyVo();
            SaleRebateConditionResultVo conditionResult = SaleRebatePolicyCalculateUtil.computeConditionExpression(saleRebatePolicyFormulaInfoVo.getSaleRebatePolicyCondition(), saleRebatePolicyFormulaInfoVo.getSaleRebatePolicyConditionName(), param);
            SaleRebateFormulaResultVo executeComputeResult = null;
            boolean flag = conditionResult.isValue();
            String saleRebatePolicyDetailId = null;
            boolean isTest = BooleanEnum.TRUE.getNumStr().equals(param.getIsTest());
            if (flag) {
                CustomerVo customerVo;
                SaleRebatePolicyDetail saleRebatePolicyDetail;
                executeComputeResult = SaleRebatePolicyCalculateUtil.computeRebateExpression(saleRebatePolicyFormulaInfoVo.getSaleRebatePolicyFormula(), saleRebatePolicyFormulaInfoVo.getSaleRebatePolicyFormulaName(), param);
                if (isTest) {
                    this.saleRebatePolicyDetailService.deleteByRebateCodeAndTest(saleRebatePolicyVo.getSaleRebatePolicyCode(), BooleanEnum.TRUE.getNumStr(), param.getSpeedNo());
                }
                if ((saleRebatePolicyDetail = SaleRebatePolicyCalculateUtil.buildDetail(param, executeComputeResult, customerVo = (CustomerVo)JsonUtils.json2Obj((String)param.getCusJson().toJSONString(), CustomerVo.class))).getRebateRatio() != null) {
                    BigDecimal rebateAmount = executeComputeResult.getValue().multiply(saleRebatePolicyDetail.getRebateRatio()).divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP);
                    saleRebatePolicyDetail.setRebateAmount(rebateAmount);
                    saleRebatePolicyDetail.setActualRebateAmount(rebateAmount);
                } else {
                    saleRebatePolicyDetail.setRebateAmount(executeComputeResult.getValue());
                    saleRebatePolicyDetail.setActualRebateAmount(executeComputeResult.getValue());
                }
                saleRebatePolicyDetail.setAdjustAmount(BigDecimal.ZERO);
                saleRebatePolicyDetail.setId(param.getSaleRebatePolicyDetailId());
                saleRebatePolicyDetail.setSaleRebateDetailCode(param.getSaleRebateDetailCode());
                Validate.notNull((Object)((Object)saleRebatePolicyDetail), (String)"\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u660e\u7ec6\u5931\u8d25", (Object[])new Object[0]);
                SaleRebatePolicyDetail rebatePolicyDetail = this.saleRebatePolicyDetailService.createOrUpdate(saleRebatePolicyDetail);
                saleRebatePolicyDetailId = rebatePolicyDetail.getId();
                this.handleAdjust(rebatePolicyDetail);
            }
            if (isTest) {
                this.saleRebateCalculationLogService.deleteByRebateCodeAndTest(saleRebatePolicyVo.getSaleRebatePolicyCode(), BooleanEnum.TRUE.getNumStr(), param.getSpeedNo());
            }
            SaleRebateCalculationLog saleRebateCalculationLog = SaleRebatePolicyCalculateUtil.buildComputeLog(param, conditionResult, executeComputeResult, saleRebatePolicyDetailId);
            this.saleRebateCalculationLogService.create(saleRebateCalculationLog);
        });
    }

    private Map<String, Set<String>> getProductCodeMap(List<String> saleRebatePolicyCodes) {
        HashMap<String, Set<String>> setMap = new HashMap<String, Set<String>>();
        List<SaleRebatePolicyCheckProductInfo> saleRebatePolicyCheckProductInfos = this.saleRebatePolicyCheckProductInfoService.findBySaleRebatePolicyCodes(saleRebatePolicyCodes);
        Validate.isTrue((!CollectionUtils.isEmpty(saleRebatePolicyCheckProductInfos) ? 1 : 0) != 0, (String)"\u8003\u6838\u5546\u54c1\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Map<String, List<SaleRebatePolicyCheckProductInfo>> collect = saleRebatePolicyCheckProductInfos.stream().collect(Collectors.groupingBy(SaleRebatePolicyCheckProductInfo::getSaleRebatePolicyCode));
        collect.forEach((s, checkProductInfos) -> {
            HashSet collectProduct = new HashSet();
            Set productLevels = checkProductInfos.stream().filter(saleRebatePolicyCheckProductInfo -> saleRebatePolicyCheckProductInfo.getType().equals(SaleRebatePolicyProductTypeEnum.PRODUCT_LEVEL.getDictCode())).map(SaleRebatePolicyCheckProductInfo::getCode).collect(Collectors.toSet());
            collectProduct.addAll(checkProductInfos.stream().filter(saleRebatePolicyCheckProductInfo -> saleRebatePolicyCheckProductInfo.getType().equals(SaleRebatePolicyProductTypeEnum.PRODUCT.getDictCode())).map(SaleRebatePolicyCheckProductInfo::getCode).collect(Collectors.toSet()));
            List curAndChildrenCodesByCodes = this.productLevelVoSdkService.findCurAndChildrenCodesByCodes(productLevels);
            List productVos = this.productVoService.findByProductLevelCodes(curAndChildrenCodesByCodes);
            if (!CollectionUtils.isEmpty((Collection)productVos)) {
                collectProduct.addAll(productVos.stream().map(ProductVo::getProductCode).collect(Collectors.toSet()));
            }
            Validate.isTrue((!CollectionUtils.isEmpty(collectProduct) ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u7f16\u7801%s\u8003\u6838\u5546\u54c1\u4e0d\u5b58\u5728!", (Object[])new Object[]{s});
            setMap.put((String)s, collectProduct);
        });
        return setMap;
    }

    private Map<String, Set<String>> getCustomerCodeMap(List<String> saleRebatePolicyCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(saleRebatePolicyCodes) ? 1 : 0) != 0, (String)"\u4f20\u5165\u8fd4\u5229\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SaleRebatePolicy> saleRebatePolicys = this.saleRebatePolicyService.findBySaleRebatePolicyCodes(saleRebatePolicyCodes);
        Validate.isTrue((!CollectionUtils.isEmpty(saleRebatePolicys) ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.isTrue((saleRebatePolicyCodes.size() == saleRebatePolicys.size() ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\uff0c\u4f20\u5165\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u548c\u5339\u914d\u6570\u91cf\u4e0d\u76f8\u7b49", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.saleRebatePolicyTemplateRegisters) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u8fd4\u5229\u7c7b\u578b\u6ce8\u518c\u5668\uff01", (Object[])new Object[0]);
        HashMap<String, Set<String>> setMap = new HashMap<String, Set<String>>();
        saleRebatePolicys.forEach(saleRebatePolicy -> {
            HashSet customers = new HashSet();
            List templateRegisters = this.saleRebatePolicyTemplateRegisters.stream().filter(saleRebatePolicyTemplateRegister -> saleRebatePolicyTemplateRegister.getSaleRebatePolicytemplateCode().equals(saleRebatePolicy.getSaleRebateType())).collect(Collectors.toList());
            SaleRebatePolicyTemplateRegister saleRebatePolicyTemplateRegister2 = (SaleRebatePolicyTemplateRegister)templateRegisters.get(0);
            Collection customerScopeStrategyClasses = saleRebatePolicyTemplateRegister2.getCustomerScopeStrategyClasses();
            for (Class customerScopeStrategyClass : customerScopeStrategyClasses) {
                SaleRebateCustomerScopeStrategy customerScopeStrategy = (SaleRebateCustomerScopeStrategy)this.applicationContext.getBean(customerScopeStrategyClass);
                Set set = customerScopeStrategy.onRequestCustomerCodes(saleRebatePolicy.getSaleRebatePolicyCode(), saleRebatePolicy.getTenantCode());
                if (CollectionUtils.isEmpty((Collection)set)) continue;
                customers.addAll(set);
            }
            Set customerList = customers.stream().collect(Collectors.toSet());
            setMap.put(saleRebatePolicy.getSaleRebatePolicyCode(), customerList);
        });
        return setMap;
    }

    private Map<String, BigDecimal> getAmountMap(SaleRebatePolicyFormulaInfoVo formulaInfo, Set<String> productCodes, String customerCode, SaleRebatePolicyDetail saleRebatePolicyDetail, SaleRebateComputeParamVo saleRebateComputeParamVo) {
        Set<String> collect = SaleRebatePolicyCalculateUtil.getCriterionSet(Collections.singletonList(formulaInfo));
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        collect.forEach(s -> {
            List list = this.saleRebatePolicyCriterionRegisters.stream().filter(saleRebatePolicyCriterionRegister -> s.startsWith(saleRebatePolicyCriterionRegister.getSaleRebatePolicyCriterionCode())).collect(Collectors.toList());
            Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(list), (String)"\u57fa\u51c6\u6ce8\u518c\u5668\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            SaleRebatePolicyCriterionRegister bean = (SaleRebatePolicyCriterionRegister)list.get(0);
            String saleRebatePolicyCode = saleRebatePolicyDetail.getSaleRebatePolicyCode();
            amountMap.putAll(bean.getAmountMap(s, saleRebatePolicyCode, Collections.singleton(customerCode), productCodes, saleRebatePolicyDetail.getSaleRebateStartTime(), saleRebatePolicyDetail.getSaleRebateEndTime(), saleRebateComputeParamVo.getSaleRebateStartTime(), saleRebateComputeParamVo.getSaleRebateEndTime()));
        });
        return amountMap;
    }

    private void handleAdjust(SaleRebatePolicyDetail rebatePolicyDetail) {
        List<SaleRebateAdjustDetail> saleRebateAdjustDetails = this.saleRebateAdjustDetailService.findBySaleRebateDetailCode(rebatePolicyDetail.getSaleRebateDetailCode());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleRebateAdjustDetails)) {
            BigDecimal decimal = saleRebateAdjustDetails.stream().map(SaleRebateAdjustDetail::getAdjustAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            SaleRebateAdjustDetail saleRebateAdjustDetail = new SaleRebateAdjustDetail();
            saleRebateAdjustDetail.setTenantCode(TenantUtils.getTenantCode());
            saleRebateAdjustDetail.setCustomerName(rebatePolicyDetail.getCustomerName());
            saleRebateAdjustDetail.setCustomerCode(rebatePolicyDetail.getCustomerCode());
            saleRebateAdjustDetail.setSaleRebatePolicyName(rebatePolicyDetail.getSaleRebatePolicyName());
            saleRebateAdjustDetail.setSaleRebateDetailCode(rebatePolicyDetail.getSaleRebateDetailCode());
            saleRebateAdjustDetail.setAdjustAmount(BigDecimal.ZERO.subtract(decimal));
            saleRebateAdjustDetail.setRemark("\u8fd4\u5229\u91cd\u65b0\u8ba1\u7b97\u540e\uff0c\u51b2\u8d26\u8bb0\u5f55\u3002");
            this.saleRebateAdjustDetailService.create(saleRebateAdjustDetail);
        }
    }
}

