/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.internal;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyFormulaInfo;
import com.biz.crm.dms.business.rebate.local.repository.SaleRebatePolicyFormulaInfoRepository;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyFormulaInfoService;
import com.biz.crm.dms.business.rebate.local.utils.MathUtil;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="saleRebatePolicyFormulaInfoService")
public class SaleRebatePolicyFormulaInfoServiceImpl
implements SaleRebatePolicyFormulaInfoService {
    @Autowired(required=false)
    private SaleRebatePolicyFormulaInfoRepository saleRebatePolicyFormulaInfoRepository;
    @Autowired(required=false)
    private List<SaleRebatePolicyCriterionRegister> saleRebatePolicyCriterionRegisters;

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.saleRebatePolicyFormulaInfoRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void deleteBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        Validate.notBlank((CharSequence)saleRebatePolicyCode, (String)"\u4f20\u5165\u8fd4\u5229\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.saleRebatePolicyFormulaInfoRepository.deleteBySaleRebatePolicyCode(saleRebatePolicyCode);
    }

    @Override
    public List<SaleRebatePolicyFormulaInfo> findBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        if (StringUtils.isBlank((CharSequence)saleRebatePolicyCode)) {
            return null;
        }
        return this.saleRebatePolicyFormulaInfoRepository.findBySaleRebatePolicyCode(saleRebatePolicyCode);
    }

    @Override
    public List<SaleRebatePolicyFormulaInfo> findBySaleRebatePolicyCodes(List<String> saleRebatePolicyCodes) {
        if (CollectionUtils.isEmpty(saleRebatePolicyCodes)) {
            return null;
        }
        return this.saleRebatePolicyFormulaInfoRepository.findBySaleRebatePolicyCodes(saleRebatePolicyCodes);
    }

    @Override
    @Transactional
    public void createBatch(List<SaleRebatePolicyFormulaInfo> list) {
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u8fd4\u5229\u516c\u5f0f\u65b0\u589e\u6570\u636e\u7f3a\u5931", (Object[])new Object[0]);
        for (SaleRebatePolicyFormulaInfo saleRebatePolicyFormulaInfo : list) {
            this.createValidate(saleRebatePolicyFormulaInfo);
        }
        this.saleRebatePolicyFormulaInfoRepository.saveBatch(list);
    }

    @Override
    public List<SaleRebatePolicyFormulaInfo> findByIds(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8fd4\u5229\u516c\u5f0fid\u96c6\u5408\u7f3a\u5931", (Object[])new Object[0]);
        return this.saleRebatePolicyFormulaInfoRepository.listByIds(ids);
    }

    private void createValidate(SaleRebatePolicyFormulaInfo saleRebatePolicyFormulaInfo) {
        Validate.notNull((Object)((Object)saleRebatePolicyFormulaInfo), (String)"\u8fd4\u5229\u516c\u5f0f\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        saleRebatePolicyFormulaInfo.setId(null);
        saleRebatePolicyFormulaInfo.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)saleRebatePolicyFormulaInfo.getTenantCode(), (String)"\u8fd4\u5229\u516c\u5f0f\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyFormulaInfo.getSaleRebatePolicyCode(), (String)"\u8fd4\u5229\u516c\u5f0f\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyFormulaInfo.getSaleRebatePolicyCondition(), (String)"\u8fd4\u5229\u516c\u5f0f\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyFormulaInfo.getSaleRebatePolicyConditionName(), (String)"\u8fd4\u5229\u516c\u5f0f\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u6761\u4ef6\uff08\u5c55\u793a\u7528\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyFormulaInfo.getSaleRebatePolicyFormula(), (String)"\u8fd4\u5229\u516c\u5f0f\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyFormulaInfo.getSaleRebatePolicyFormulaName(), (String)"\u8fd4\u5229\u516c\u5f0f\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u516c\u5f0f\uff08\u5c55\u793a\u7528\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String saleRebatePolicyCondition = MathUtil.replaceDefaultVariable(saleRebatePolicyFormulaInfo.getSaleRebatePolicyCondition());
        String saleRebatePolicyFormula = MathUtil.replaceDefaultVariable(saleRebatePolicyFormulaInfo.getSaleRebatePolicyFormula());
        try {
            Validate.notNull((Object)MathUtil.computeCondition(saleRebatePolicyCondition), (String)"\u6761\u4ef6\u9a8c\u8bc1\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(StringUtils.join((Object[])new String[]{"\u6761\u4ef6\u9a8c\u8bc1\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6", saleRebatePolicyFormulaInfo.getSaleRebatePolicyCondition()}), e);
        }
        try {
            Validate.notNull((Object)MathUtil.computeFormula(saleRebatePolicyFormula), (String)"\u516c\u5f0f\u9a8c\u8bc1\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(StringUtils.join((Object[])new String[]{"\u516c\u5f0f\u9a8c\u8bc1\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f", saleRebatePolicyFormulaInfo.getSaleRebatePolicyFormula()}), e);
        }
    }
}

