/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.internal;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyProductInfo;
import com.biz.crm.dms.business.rebate.local.repository.SaleRebatePolicyProductInfoRepository;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyProductInfoService;
import com.biz.crm.dms.business.rebate.sdk.enums.AllocationTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="saleRebatePolicyProductInfoService")
public class SaleRebatePolicyProductInfoServiceImpl
implements SaleRebatePolicyProductInfoService {
    @Autowired(required=false)
    private SaleRebatePolicyProductInfoRepository saleRebatePolicyProductInfoRepository;

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u4f20\u5165id\u96c6\u5408\u4e3a\u7a7a", (Object[])new Object[0]);
        this.saleRebatePolicyProductInfoRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void deleteBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        Validate.notBlank((CharSequence)saleRebatePolicyCode, (String)"\u4f20\u5165\u8fd4\u5229\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.saleRebatePolicyProductInfoRepository.deleteBySaleRebatePolicyCode(saleRebatePolicyCode);
    }

    @Override
    public List<SaleRebatePolicyProductInfo> findBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        if (StringUtils.isBlank((CharSequence)saleRebatePolicyCode)) {
            return null;
        }
        return this.saleRebatePolicyProductInfoRepository.findBySaleRebatePolicyCode(saleRebatePolicyCode);
    }

    @Override
    public List<SaleRebatePolicyProductInfo> findBySaleRebatePolicyCodes(List<String> saleRebatePolicyCodes) {
        if (CollectionUtils.isEmpty(saleRebatePolicyCodes)) {
            return null;
        }
        return this.saleRebatePolicyProductInfoRepository.findBySaleRebatePolicyCodes(saleRebatePolicyCodes);
    }

    @Override
    @Transactional
    public void createBatch(List<SaleRebatePolicyProductInfo> list) {
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u521b\u5efa\u65f6\u8fd4\u5229\u4ea7\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (SaleRebatePolicyProductInfo saleRebatePolicyProductInfo : list) {
            this.createValidate(saleRebatePolicyProductInfo);
        }
        this.rebateRatioValidate(list);
        this.saleRebatePolicyProductInfoRepository.saveBatch(list);
    }

    private void createValidate(SaleRebatePolicyProductInfo saleRebatePolicyProductInfo) {
        Validate.notNull((Object)((Object)saleRebatePolicyProductInfo), (String)"\u8fd4\u5229\u5546\u54c1\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        saleRebatePolicyProductInfo.setId(null);
        saleRebatePolicyProductInfo.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)saleRebatePolicyProductInfo.getTenantCode(), (String)"\u8fd4\u5229\u5546\u54c1\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyProductInfo.getType(), (String)"\u8fd4\u5229\u5546\u54c1\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyProductInfo.getCode(), (String)"\u8fd4\u5229\u5546\u54c1\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5546\u54c1\u6216\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyProductInfo.getName(), (String)"\u8fd4\u5229\u5546\u54c1\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5546\u54c1\u6216\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyProductInfo.getSaleRebatePolicyCode(), (String)"\u8fd4\u5229\u5546\u54c1\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void rebateRatioValidate(List<SaleRebatePolicyProductInfo> list) {
        BigDecimal res = BigDecimal.ZERO;
        List collect = list.stream().map(SaleRebatePolicyProductInfo::getAllocationType).distinct().collect(Collectors.toList());
        Validate.isTrue((collect.size() == 1 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u5546\u54c1\u5206\u914d\u6bd4\u4f8b\u7c7b\u578b\u4e0d\u7edf\u4e00\uff01", (Object[])new Object[0]);
        if (AllocationTypeEnum.RATIO_AMOUNT.getKey().equals(collect.get(0))) {
            for (SaleRebatePolicyProductInfo saleRebatePolicyProductInfo : list) {
                BigDecimal rebateRatio = saleRebatePolicyProductInfo.getRebateRatio();
                Validate.notNull((Object)rebateRatio, (String)"\u8fd4\u5229\u5546\u54c1\u6bd4\u4f8b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                res = res.add(rebateRatio);
            }
            Validate.isTrue((res.compareTo(new BigDecimal("100")) == 0 ? 1 : 0) != 0, (String)"\u5206\u914d\u6bd4\u4f8b\u9519\u8bef\uff0c\u603b\u548c\u5e94\u8be5\u7b49\u4e8e100", (Object[])new Object[0]);
        } else {
            list.forEach(s -> s.setRebateRatio(BigDecimal.valueOf(100L)));
        }
    }
}

