/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.DynamicFormServiceBuilder;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicy;
import com.biz.crm.dms.business.rebate.local.repository.SaleRebatePolicyRepository;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyTaskService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebateRegisterService;
import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.biz.crm.dms.business.rebate.sdk.enums.SaleRebatePolicyStatusEnum;
import com.biz.crm.dms.business.rebate.sdk.event.SaleRebatePolicyEventListener;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCycleRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyElementDataVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyVo;
import com.biz.crm.dms.business.rebate.sdk.vo.dynamic.ConfigurableCriterionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="saleRebatePolicyService")
public class SaleRebatePolicyServiceImpl<T extends SaleRebatePolicyElementDataVo>
implements SaleRebatePolicyService {
    @Autowired(required=false)
    private SaleRebatePolicyRepository saleRebatePolicyRepository;
    @Autowired(required=false)
    private SaleRebatePolicyTaskService saleRebatePolicyTaskService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private SaleRebateRegisterService saleRebateRegisterService;
    @Autowired(required=false)
    private List<SaleRebatePolicyEventListener> saleRebatePolicyEventListeners;
    @Autowired(required=false)
    private List<SaleRebatePolicyCycleRegister> saleRebatePolicyCycleRegisters;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private List<SaleRebatePolicyCriterionRegister> saleRebatePolicyCriterionRegisters;

    @Override
    public Page<SaleRebatePolicy> findByConditions(Pageable pageable, SaleRebatePolicy saleRebatePolicy) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)saleRebatePolicy)) {
            saleRebatePolicy = new SaleRebatePolicy();
        }
        return this.saleRebatePolicyRepository.findByConditions(pageable, saleRebatePolicy);
    }

    @Override
    public SaleRebatePolicy findById(String id) {
        return (SaleRebatePolicy)((Object)this.saleRebatePolicyRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public SaleRebatePolicy create(SaleRebatePolicyDto saleRebatePolicyDto) {
        this.createValidate(saleRebatePolicyDto);
        SaleRebatePolicy entity = this.transformCreate(saleRebatePolicyDto);
        this.saveSaleRebatePolicyElementData(saleRebatePolicyDto);
        this.saveSaleRebatePolicyCycle(saleRebatePolicyDto);
        entity.setSaleRebatePolicyStatus(SaleRebatePolicyStatusEnum.WAIT_EXECUTION.getKey());
        this.saleRebatePolicyRepository.save((Object)entity);
        this.saveCriterionConfig(saleRebatePolicyDto);
        if (!CollectionUtils.isEmpty(this.saleRebatePolicyEventListeners)) {
            SaleRebatePolicyVo saleRebatePolicyVo = (SaleRebatePolicyVo)this.nebulaToolkitService.copyObjectByBlankList((Object)saleRebatePolicyDto, SaleRebatePolicyVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.saleRebatePolicyEventListeners.forEach(eventListener -> eventListener.onCreate(saleRebatePolicyVo));
        }
        return entity;
    }

    private void saveCriterionConfig(SaleRebatePolicyDto saleRebatePolicyDto) {
        JSONObject configurableCriterion = saleRebatePolicyDto.getConfigurableCriterion();
        Boolean reassemble = this.reassemble(configurableCriterion);
        if (!reassemble.booleanValue()) {
            return;
        }
        DynamicFormServiceBuilder dynamicFormServiceBuilder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{ConfigurableCriterionVo.class, this.applicationContext});
        DynamicFormService dynamicFormService = dynamicFormServiceBuilder.dynamicField("criterionMap").addDynamicMapping("CPXSSL", "CPXSSL").config().build();
        ConfigurableCriterionVo configurableCriterionVo = (ConfigurableCriterionVo)dynamicFormService.dynamic(configurableCriterion);
        dynamicFormService.createDynamicDetails((Object)configurableCriterionVo, saleRebatePolicyDto.getSaleRebatePolicyCode());
    }

    private Boolean reassemble(JSONObject configurableCriterion) {
        Validate.isTrue((!CollectionUtils.isEmpty(this.saleRebatePolicyCriterionRegisters) ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u8fd4\u5229\u53d8\u91cf\uff01", (Object[])new Object[0]);
        if (ObjectUtils.isEmpty((Object)configurableCriterion)) {
            return false;
        }
        JSONObject criterionMap = configurableCriterion.getJSONObject("criterionMap");
        if (ObjectUtils.isEmpty((Object)criterionMap)) {
            return false;
        }
        Set keySet = criterionMap.keySet();
        if (CollectionUtils.isEmpty((Collection)keySet)) {
            return false;
        }
        JSONObject criterionMapAfter = new JSONObject(keySet.size());
        for (String instanceCode : keySet) {
            Optional<SaleRebatePolicyCriterionRegister> registerOpt = this.saleRebatePolicyCriterionRegisters.stream().filter(register -> StringUtils.startsWith((CharSequence)instanceCode, (CharSequence)register.getSaleRebatePolicyCriterionCode())).findFirst();
            if (!registerOpt.isPresent()) continue;
            SaleRebatePolicyCriterionRegister criterionRegister = registerOpt.get();
            String criterionCode = criterionRegister.getSaleRebatePolicyCriterionCode();
            JSONObject formJson = criterionMap.getJSONObject(instanceCode);
            formJson.put("instanceCode", (Object)instanceCode);
            JSONArray jsonArray = criterionMapAfter.getJSONArray(criterionCode);
            if (ObjectUtils.isNotEmpty((Object)jsonArray)) {
                jsonArray.add((Object)formJson);
                continue;
            }
            JSONArray array = new JSONArray();
            array.add((Object)formJson);
            criterionMapAfter.put(criterionCode, (Object)array);
        }
        configurableCriterion.put("criterionMap", (Object)criterionMapAfter);
        return true;
    }

    @Override
    @Transactional
    public SaleRebatePolicy update(SaleRebatePolicyDto saleRebatePolicyDto) {
        this.updateValidate(saleRebatePolicyDto);
        SaleRebatePolicy saleRebatePolicyOld = (SaleRebatePolicy)((Object)this.saleRebatePolicyRepository.getById((Serializable)((Object)saleRebatePolicyDto.getId())));
        SaleRebatePolicy entity = this.transformUpdate(saleRebatePolicyDto, saleRebatePolicyOld);
        this.updateSaleRebatePolicyElementData(saleRebatePolicyDto);
        this.updateSaleRebatePolicyCycle(saleRebatePolicyDto);
        this.saleRebatePolicyRepository.updateById((Object)entity);
        this.updateCriterionConfig(saleRebatePolicyDto);
        if (!CollectionUtils.isEmpty(this.saleRebatePolicyEventListeners)) {
            SaleRebatePolicyVo oldVo = (SaleRebatePolicyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)saleRebatePolicyOld, SaleRebatePolicyVo.class, HashSet.class, ArrayList.class, new String[0]);
            SaleRebatePolicyVo newVo = (SaleRebatePolicyVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, SaleRebatePolicyVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.saleRebatePolicyEventListeners.forEach(eventListener -> eventListener.onUpdate(oldVo, newVo));
        }
        return entity;
    }

    private void updateCriterionConfig(SaleRebatePolicyDto saleRebatePolicyDto) {
        JSONObject configurableCriterion = saleRebatePolicyDto.getConfigurableCriterion();
        Boolean reassemble = this.reassemble(configurableCriterion);
        if (!reassemble.booleanValue()) {
            return;
        }
        DynamicFormServiceBuilder dynamicFormServiceBuilder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{ConfigurableCriterionVo.class, this.applicationContext});
        DynamicFormService dynamicFormService = dynamicFormServiceBuilder.dynamicField("criterionMap").addDynamicMapping("CPXSSL", "CPXSSL").config().build();
        ConfigurableCriterionVo configurableCriterionVo = (ConfigurableCriterionVo)dynamicFormService.dynamic(configurableCriterion);
        dynamicFormService.modifyDynamicDetails((Object)configurableCriterionVo, saleRebatePolicyDto.getSaleRebatePolicyCode());
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List entities = this.saleRebatePolicyRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == idList.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List collect1 = entities.stream().filter(saleRebatePolicy -> !SaleRebatePolicyStatusEnum.WAIT_EXECUTION.getKey().equals(saleRebatePolicy.getSaleRebatePolicyStatus())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(collect1), (String)"\u53ea\u80fd\u5220\u9664\u5f85\u6267\u884c\u72b6\u6001\u8fd4\u5229\u653f\u7b56", (Object[])new Object[0]);
        this.saleRebatePolicyRepository.removeByIds(idList);
        List<String> collect = entities.stream().map(SaleRebatePolicy::getSaleRebatePolicyCode).collect(Collectors.toList());
        this.saleRebatePolicyTaskService.deleteBatchBySaleRebatePolicyCodes(collect);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entities = this.saleRebatePolicyRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u6062\u590d\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.saleRebatePolicyRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        List<String> collect = entities.stream().map(SaleRebatePolicy::getSaleRebatePolicyCode).collect(Collectors.toList());
        this.saleRebatePolicyTaskService.effectiveBatchBySaleRebatePolicyCodes(collect);
        if (!CollectionUtils.isEmpty(this.saleRebatePolicyEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, SaleRebatePolicy.class, SaleRebatePolicyVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.saleRebatePolicyEventListeners.forEach(listener -> listener.onEnable(voList));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.saleRebatePolicyRepository.listByIds(ids);
        Validate.isTrue((org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u4f5c\u5e9f\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.saleRebatePolicyRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        List<String> collect = entities.stream().map(SaleRebatePolicy::getSaleRebatePolicyCode).collect(Collectors.toList());
        this.saleRebatePolicyTaskService.invalidBatchBySaleRebatePolicyCodes(collect);
        if (!CollectionUtils.isEmpty(this.saleRebatePolicyEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, SaleRebatePolicy.class, SaleRebatePolicyVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.saleRebatePolicyEventListeners.forEach(listener -> listener.onDisable(voList));
        }
    }

    @Override
    @Transactional
    public void updateSaleRebatePolicyStatus(String id, SaleRebatePolicyStatusEnum saleRebatePolicyStatusEnum) {
        this.saleRebatePolicyRepository.updateSaleRebatePolicyStatus(saleRebatePolicyStatusEnum, id);
    }

    @Override
    public List<SaleRebatePolicy> findBySaleRebatePolicyCodes(List<String> codes) {
        return this.saleRebatePolicyRepository.findBySaleRebatePolicyCodes(codes, TenantUtils.getTenantCode());
    }

    @Override
    public SaleRebatePolicy findBySaleRebatePolicyCode(String code) {
        return this.saleRebatePolicyRepository.findBySalePolicyCodeAndTenantCode(code, TenantUtils.getTenantCode());
    }

    private SaleRebatePolicy transformCreate(SaleRebatePolicyDto saleRebatePolicyDto) {
        SaleRebatePolicy entity = (SaleRebatePolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)saleRebatePolicyDto, SaleRebatePolicy.class, HashSet.class, ArrayList.class, new String[0]));
        if (StringUtils.isBlank((CharSequence)entity.getSaleRebatePolicyCode())) {
            entity.setSaleRebatePolicyCode((String)this.generateCodeService.generateCode("FLZC", 1).get(0));
        } else {
            Validate.isTrue((entity.getSaleRebatePolicyCode().length() < 128 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7128", (Object[])new Object[0]);
        }
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        saleRebatePolicyDto.setSaleRebatePolicyCode(entity.getSaleRebatePolicyCode());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(entity.getSaleRebateEndTime());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date endTime = calendar.getTime();
        entity.setSaleRebateEndTime(endTime);
        return entity;
    }

    private SaleRebatePolicy transformUpdate(SaleRebatePolicyDto saleRebatePolicyDto, SaleRebatePolicy saleRebatePolicy) {
        SaleRebatePolicy entity = (SaleRebatePolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)saleRebatePolicyDto, SaleRebatePolicy.class, HashSet.class, ArrayList.class, new String[0]));
        Validate.isTrue((boolean)Objects.nonNull((Object)saleRebatePolicy), (String)"\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((!SaleRebatePolicyStatusEnum.WAIT_EXECUTION.equals((Object)saleRebatePolicy.getSaleRebatePolicyStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u4fee\u6539\u5f85\u6267\u884c\u7684\u653f\u7b56\uff01", (Object[])new Object[0]);
        entity.setTenantCode(saleRebatePolicy.getTenantCode());
        entity.setDelFlag(saleRebatePolicy.getDelFlag());
        entity.setSaleRebatePolicyStatus(entity.getSaleRebatePolicyStatus());
        entity.setEnableStatus(saleRebatePolicy.getEnableStatus());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(entity.getSaleRebateEndTime());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date endTime = calendar.getTime();
        entity.setSaleRebateEndTime(endTime);
        return entity;
    }

    private void saveSaleRebatePolicyElementData(SaleRebatePolicyDto saleRebatePolicyDto) {
        Map data = saleRebatePolicyDto.getElementDataMap();
        Collection<Class<? extends SaleRebatePolicyElementRegister>> classes = this.saleRebateRegisterService.findTemplateCollection(saleRebatePolicyDto.getSaleRebateType());
        for (Class<? extends SaleRebatePolicyElementRegister> aClass : classes) {
            SaleRebatePolicyElementRegister saleRebatePolicyElementRegister = (SaleRebatePolicyElementRegister)this.applicationContext.getBean(aClass);
            JSONObject jsonObject = (JSONObject)data.get(saleRebatePolicyElementRegister.getSaleRebatePolicyElementCode());
            Validate.isTrue((boolean)Objects.nonNull(jsonObject), (String)"\u8fd4\u5229\u653f\u7b56\u4e2d%s\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[]{saleRebatePolicyElementRegister.getSaleRebatePolicyElementName()});
            Class elementClass = saleRebatePolicyElementRegister.getSaleRebatePolicyElementClass();
            saleRebatePolicyElementRegister.onRequestSaleRebatePolicyCreate(saleRebatePolicyDto.getSaleRebatePolicyCode(), (SaleRebatePolicyElementDataVo)JSON.parseObject((String)jsonObject.toJSONString(), (Class)elementClass));
        }
    }

    private void updateSaleRebatePolicyElementData(SaleRebatePolicyDto saleRebatePolicyDto) {
        Map data = saleRebatePolicyDto.getElementDataMap();
        Collection<Class<? extends SaleRebatePolicyElementRegister>> classes = this.saleRebateRegisterService.findTemplateCollection(saleRebatePolicyDto.getSaleRebateType());
        for (Class<? extends SaleRebatePolicyElementRegister> aClass : classes) {
            SaleRebatePolicyElementRegister saleRebatePolicyElementRegister = (SaleRebatePolicyElementRegister)this.applicationContext.getBean(aClass);
            JSONObject jsonObject = (JSONObject)data.get(saleRebatePolicyElementRegister.getSaleRebatePolicyElementCode());
            Validate.isTrue((boolean)Objects.nonNull(jsonObject), (String)"\u8fd4\u5229\u653f\u7b56\u4e2d%s\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[]{saleRebatePolicyElementRegister.getSaleRebatePolicyElementName()});
            Class elementClass = saleRebatePolicyElementRegister.getSaleRebatePolicyElementClass();
            saleRebatePolicyElementRegister.onRequestSaleRebatePolicyUpdate(saleRebatePolicyDto.getSaleRebatePolicyCode(), (SaleRebatePolicyElementDataVo)JSON.parseObject((String)jsonObject.toJSONString(), (Class)elementClass));
        }
    }

    private void saveSaleRebatePolicyCycle(SaleRebatePolicyDto saleRebatePolicyDto) {
        String saleRebatePolicyCycle = saleRebatePolicyDto.getSaleRebatePolicyCycle();
        List collect = this.saleRebatePolicyCycleRegisters.stream().filter(saleRebatePolicyCycleRegister -> saleRebatePolicyCycleRegister.getSaleRebatePolicyCycleCode().equals(saleRebatePolicyCycle)).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(collect) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5468\u671f\u8981\u7d20\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        SaleRebatePolicyCycleRegister saleRebatePolicyCycleRegister2 = (SaleRebatePolicyCycleRegister)collect.get(0);
        saleRebatePolicyCycleRegister2.onRequestcreate(saleRebatePolicyDto);
    }

    private void updateSaleRebatePolicyCycle(SaleRebatePolicyDto saleRebatePolicyDto) {
        String saleRebatePolicyCycle = saleRebatePolicyDto.getSaleRebatePolicyCycle();
        List collect = this.saleRebatePolicyCycleRegisters.stream().filter(saleRebatePolicyCycleRegister -> saleRebatePolicyCycleRegister.getSaleRebatePolicyCycleCode().equals(saleRebatePolicyCycle)).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(collect) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5468\u671f\u8981\u7d20\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        SaleRebatePolicyCycleRegister saleRebatePolicyCycleRegister2 = (SaleRebatePolicyCycleRegister)collect.get(0);
        saleRebatePolicyCycleRegister2.onRequestUpdate(saleRebatePolicyDto);
    }

    private void createValidate(SaleRebatePolicyDto saleRebatePolicyDto) {
        Validate.notNull((Object)saleRebatePolicyDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        saleRebatePolicyDto.setId(null);
        Validate.notNull((Object)saleRebatePolicyDto.getSaleRebateEndTime(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u7ed3\u675f\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyDto.getSaleRebatePolicyName(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebatePolicyDto.getSaleRebateStartTime(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u5f00\u59cb\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((saleRebatePolicyDto.getSaleRebatePolicyName().length() <= 128 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57", (Object[])new Object[0]);
        Validate.isTrue((saleRebatePolicyDto.getSaleRebateStartTime().compareTo(saleRebatePolicyDto.getSaleRebateEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyDto.getSaleRebateType(), (String)"\u8fd4\u5229\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebatePolicyDto.getBillType(), (String)"\u4e0a\u8d26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyDto.getRemark(), (String)"\u8fd4\u5229\u653f\u7b56\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.isTrue((saleRebatePolicyDto.getRemark().length() <= 400 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u63cf\u8ff0\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57", (Object[])new Object[0]);
    }

    private void updateValidate(SaleRebatePolicyDto saleRebatePolicyDto) {
        Validate.notNull((Object)saleRebatePolicyDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyDto.getId(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebatePolicyDto.getSaleRebateEndTime(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u7ed3\u675f\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyDto.getSaleRebatePolicyCode(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u4fc3\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyDto.getSaleRebatePolicyName(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebatePolicyDto.getSaleRebateStartTime(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u5f00\u59cb\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((saleRebatePolicyDto.getSaleRebatePolicyCode().length() <= 225 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7225", (Object[])new Object[0]);
        Validate.isTrue((saleRebatePolicyDto.getSaleRebatePolicyName().length() <= 128 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57", (Object[])new Object[0]);
        Validate.isTrue((saleRebatePolicyDto.getSaleRebateStartTime().compareTo(saleRebatePolicyDto.getSaleRebateEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
    }
}

