/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.criterionregister;

import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleRebateMothCriterionRegister
implements SaleRebatePolicyCriterionRegister {
    private static final Logger log = LoggerFactory.getLogger(SaleRebateMothCriterionRegister.class);
    private static final String REBATE_POLICY_CRITERION_NAME = "\u6708\u9500\u552e\u6570\u91cf";
    private static final String REBATE_POLICY_CRITERION_CODE = "YXSSL";
    private static final Integer REBATE_POLICY_CRITERION_SORT = 1;

    public String getSaleRebatePolicyCriterionCode() {
        return REBATE_POLICY_CRITERION_CODE;
    }

    public String getSaleRebatePolicyCriterionName() {
        return REBATE_POLICY_CRITERION_NAME;
    }

    public Integer getCriterionSort() {
        return REBATE_POLICY_CRITERION_SORT;
    }

    public Map<String, BigDecimal> getAmountMap(String saleRebatePolicyCriterionCode, String saleRebatePolicyCode, Set<String> cusCodes, Set<String> productCode, Date startTime, Date endTime, Date saleRebateStartTime, Date saleRebateEndTime) {
        Validate.isTrue((!CollectionUtils.isEmpty(cusCodes) ? 1 : 0) != 0, (String)"\u57fa\u51c6\u4fe1\u606f\u67e5\u8be2\u65f6\u5ba2\u6237\u96c6\u5408\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(productCode) ? 1 : 0) != 0, (String)"\u57fa\u51c6\u4fe1\u606f\u67e5\u8be2\u65f6\u8003\u6838\u4ea7\u54c1\u96c6\u5408\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)startTime, (String)"\u57fa\u51c6\u4fe1\u606f\u67e5\u8be2\u65f6\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)endTime, (String)"\u57fa\u51c6\u4fe1\u606f\u67e5\u8be2\u65f6\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        cusCodes.forEach(s -> {
            String key = REBATE_POLICY_CRITERION_CODE + s;
            map.put(key, BigDecimal.valueOf(50L));
        });
        return map;
    }
}

