/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.criterionregister;

import com.biz.crm.dms.business.delivery.sdk.dto.DeliverySalesTargetDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryDetailVo;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebateCycleUtil;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateExecutionDateRangeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleRebateQuarterAmountRegister
implements SaleRebatePolicyCriterionRegister {
    private static final Logger log = LoggerFactory.getLogger(SaleRebateQuarterAmountRegister.class);
    @Autowired(required=false)
    private DeliveryDetailVoService deliveryDetailVoService;
    private static final String REBATE_POLICY_CRITERION_NAME = "\u5b63\u9500\u552e\u91d1\u989d";
    private static final String REBATE_POLICY_CRITERION_CODE = "JXSJE";
    private static final Integer REBATE_POLICY_CRITERION_SORT = 3;

    public String getSaleRebatePolicyCriterionCode() {
        return REBATE_POLICY_CRITERION_CODE;
    }

    public String getSaleRebatePolicyCriterionName() {
        return REBATE_POLICY_CRITERION_NAME;
    }

    public Integer getCriterionSort() {
        return REBATE_POLICY_CRITERION_SORT;
    }

    public Map<String, BigDecimal> getAmountMap(String saleRebatePolicyCriterionCode, String saleRebatePolicyCode, Set<String> cusCodes, Set<String> productCode, Date startTime, Date endTime, Date saleRebateStartTime, Date saleRebateEndTime) {
        Set deliveryCodes;
        List detailByDeliveryCodes;
        List<SaleRebateExecutionDateRangeVo> executionQuarterList = SaleRebateCycleUtil.getExecutionQuarterList(saleRebateStartTime, saleRebateEndTime);
        Map<String, SaleRebateExecutionDateRangeVo> saleRebateExecutionDateRangeVoMap = executionQuarterList.stream().collect(Collectors.toMap(SaleRebateExecutionDateRangeVo::getSaleRebateQuarter, t -> t));
        List<String> list = this.getQuarterList(startTime, endTime);
        ArrayList dateRangeVoList = new ArrayList();
        list.forEach(s -> {
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = (SaleRebateExecutionDateRangeVo)saleRebateExecutionDateRangeVoMap.get(s);
            if (Objects.nonNull(saleRebateExecutionDateRangeVo)) {
                dateRangeVoList.add(saleRebateExecutionDateRangeVo);
            }
        });
        Validate.isTrue((!CollectionUtils.isEmpty(cusCodes) ? 1 : 0) != 0, (String)"\u57fa\u51c6\u4fe1\u606f\u67e5\u8be2\u65f6\u5ba2\u6237\u96c6\u5408\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(productCode) ? 1 : 0) != 0, (String)"\u57fa\u51c6\u4fe1\u606f\u67e5\u8be2\u65f6\u8003\u6838\u4ea7\u54c1\u96c6\u5408\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)startTime, (String)"\u57fa\u51c6\u4fe1\u606f\u67e5\u8be2\u65f6\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)endTime, (String)"\u57fa\u51c6\u4fe1\u606f\u67e5\u8be2\u65f6\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverySalesTargetDto deliverySalesTargetDto = new DeliverySalesTargetDto();
        deliverySalesTargetDto.setCustomerCodes(cusCodes);
        deliverySalesTargetDto.setGoodsCodes(productCode);
        deliverySalesTargetDto.setTenantCode(TenantUtils.getTenantCode());
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        Date saleRebateEnd = dateRangeVoList.stream().max(Comparator.comparing(SaleRebateExecutionDateRangeVo::getSaleRebateEndTime)).get().getSaleRebateEndTime();
        Date saleRebateBegin = dateRangeVoList.stream().min(Comparator.comparing(SaleRebateExecutionDateRangeVo::getSaleRebateStartTime)).get().getSaleRebateStartTime();
        deliverySalesTargetDto.setEndTime(saleRebateEnd);
        deliverySalesTargetDto.setStartTime(saleRebateBegin);
        List deliveryDetailVos = this.deliveryDetailVoService.findByRelateCodesInAndGoodsCodesInAndBetweenStartTimeAndEndTime(deliverySalesTargetDto);
        HashMap<String, List<DeliveryDetailVo>> listMap = new HashMap<String, List<DeliveryDetailVo>>();
        if (!CollectionUtils.isEmpty((Collection)deliveryDetailVos) && !CollectionUtils.isEmpty((Collection)(detailByDeliveryCodes = this.deliveryDetailVoService.findDetailByDeliveryCodes(deliveryCodes = deliveryDetailVos.stream().map(DeliveryDetailVo::getDeliveryCode).collect(Collectors.toSet()))))) {
            listMap.putAll(detailByDeliveryCodes.stream().collect(Collectors.groupingBy(DeliveryDetailVo::getRelateCode)));
        }
        cusCodes.forEach(s -> {
            String key = REBATE_POLICY_CRITERION_CODE + s;
            List deliveryDetails = (List)listMap.get(s);
            if (!CollectionUtils.isEmpty((Collection)deliveryDetails)) {
                BigDecimal reduce = deliveryDetails.stream().filter(deliveryDetailVo -> Objects.nonNull(deliveryDetailVo.getDeliverShouldPaymentAmount())).map(DeliveryDetailVo::getDeliverShouldPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                map.put(key, reduce);
            } else {
                map.put(key, BigDecimal.ZERO);
            }
        });
        return map;
    }

    private List<String> getQuarterList(Date startTime, Date endTime) {
        List<SaleRebateExecutionDateRangeVo> executionQuarterList = SaleRebateCycleUtil.getExecutionQuarterList(startTime, endTime);
        return executionQuarterList.stream().map(SaleRebateExecutionDateRangeVo::getSaleRebateQuarter).collect(Collectors.toList());
    }
}

