/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.criterionregister.configurable;

import com.biz.crm.dms.business.delivery.sdk.dto.DeliverySalesTargetDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryDetailVo;
import com.biz.crm.dms.business.rebate.local.enums.TimeTypeEnum;
import com.biz.crm.dms.business.rebate.local.model.SaleVolumeCriterionVo;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import com.biz.crm.dms.business.rebate.sdk.service.CriterionVoService;
import com.biz.crm.dms.business.rebate.sdk.vo.dynamic.AbstractCriterionVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class SaleVolumeCriterionImpl
implements SaleRebatePolicyCriterionRegister {
    @Autowired(required=false)
    private CriterionVoService criterionVoService;
    @Autowired(required=false)
    private DeliveryDetailVoService deliveryDetailVoService;
    public static final String REBATE_POLICY_CRITERION_CODE = "CPXSSL";
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getSaleRebatePolicyCriterionCode() {
        return REBATE_POLICY_CRITERION_CODE;
    }

    public String getSaleRebatePolicyCriterionName() {
        return "\u53ef\u914d\u9500\u552e\u6570\u91cf";
    }

    public Integer getCriterionSort() {
        return 1;
    }

    public Map<String, BigDecimal> getAmountMap(String saleRebatePolicyCriterionCode, String saleRebatePolicyCode, Set<String> cusCodes, Set<String> productCode, Date startTime, Date endTime, Date saleRebateStartTime, Date saleRebateEndTime) {
        AbstractCriterionVo criterionVo = this.criterionVoService.findByPolicyCodeAndCriterionCode(saleRebatePolicyCode, saleRebatePolicyCriterionCode);
        SaleVolumeCriterionVo saleVolumeCriterionVo = (SaleVolumeCriterionVo)criterionVo;
        DeliverySalesTargetDto deliverySalesTargetDto = this.getDeliverySalesTargetDto(saleVolumeCriterionVo, productCode);
        deliverySalesTargetDto.setCustomerCodes(cusCodes);
        deliverySalesTargetDto.setTenantCode(TenantUtils.getTenantCode());
        List deliveryDetailVos = this.deliveryDetailVoService.findByRelateCodesInAndGoodsCodesInAndBetweenStartTimeAndEndTime(deliverySalesTargetDto);
        Map<String, BigDecimal> resultMap = this.getResultMap(saleRebatePolicyCriterionCode, cusCodes, deliveryDetailVos);
        return resultMap;
    }

    private DeliverySalesTargetDto getDeliverySalesTargetDto(SaleVolumeCriterionVo saleVolumeCriterionVo, Set<String> productCodeSet) {
        Date saleRebateEnd = this.getEndTime(saleVolumeCriterionVo);
        Date saleRebateBegin = this.getStartTime(saleVolumeCriterionVo);
        Set<String> productCodeSet1 = this.getProductCodeSet(productCodeSet, saleVolumeCriterionVo);
        DeliverySalesTargetDto deliverySalesTargetDto = new DeliverySalesTargetDto();
        deliverySalesTargetDto.setEndTime(saleRebateEnd);
        deliverySalesTargetDto.setStartTime(saleRebateBegin);
        deliverySalesTargetDto.setGoodsCodes(productCodeSet1);
        return deliverySalesTargetDto;
    }

    private Set<String> getProductCodeSet(Set<String> productCodeSet, SaleVolumeCriterionVo saleVolumeCriterionVo) {
        List<String> productCodes;
        Boolean defaultProduct = saleVolumeCriterionVo.getDefaultProduct();
        if (defaultProduct.booleanValue()) {
            return productCodeSet;
        }
        HashSet<String> newProductCodeSet = new HashSet<String>();
        List<String> productLevels = saleVolumeCriterionVo.getProductLevels();
        if (!CollectionUtils.isEmpty(productLevels)) {
            HashSet<String> productLevelSet = new HashSet<String>();
            for (String productLevel : productLevels) {
                productLevelSet.add(StringUtils.substringAfterLast((String)productLevel, (String)":"));
            }
            List curAndChildrenCodesByCodes = this.productLevelVoSdkService.findCurAndChildrenCodesByCodes(productLevelSet);
            List productVos = this.productVoService.findByProductLevelCodes(curAndChildrenCodesByCodes);
            if (!CollectionUtils.isEmpty((Collection)productVos)) {
                for (ProductVo productVo : productVos) {
                    newProductCodeSet.add(productVo.getProductCode());
                }
            }
        }
        if (!CollectionUtils.isEmpty(productCodes = saleVolumeCriterionVo.getProductCodes())) {
            for (String productCode : productCodes) {
                newProductCodeSet.add(StringUtils.substringAfterLast((String)productCode, (String)":"));
            }
        }
        return newProductCodeSet;
    }

    private Date getStartTime(SaleVolumeCriterionVo saleVolumeCriterionVo) {
        String timeType = saleVolumeCriterionVo.getTimeType();
        if (TimeTypeEnum.CUSTOM.getDictCode().equals(timeType)) {
            return saleVolumeCriterionVo.getLeftTime();
        }
        if (TimeTypeEnum.LAST_MONTH.getDictCode().equals(timeType)) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime lastMonth = now.minusMonths(1L);
            LocalDateTime firstDayOfLastMonth = lastMonth.with(TemporalAdjusters.firstDayOfMonth());
            return Date.from(firstDayOfLastMonth.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (TimeTypeEnum.LAST_QUARTER.getDictCode().equals(timeType)) {
            LocalDate now = LocalDate.now();
            Month firstMonthOfQuarter = Month.of(now.getMonth().firstMonthOfQuarter().getValue());
            Month firstMonthOfLastQuarter = firstMonthOfQuarter.minus(3L);
            int yearOfLastQuarter = firstMonthOfQuarter.getValue() < 4 ? now.getYear() - 1 : now.getYear();
            LocalDateTime firstDayOfLastQuarter = LocalDateTime.of(LocalDate.of(yearOfLastQuarter, firstMonthOfLastQuarter, 1), LocalTime.MIN);
            return Date.from(firstDayOfLastQuarter.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (TimeTypeEnum.LAST_YEAR.getDictCode().equals(timeType)) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime lastYear = now.minusYears(1L);
            LocalDateTime firstDayOfLastYear = lastYear.with(TemporalAdjusters.firstDayOfYear());
            return Date.from(firstDayOfLastYear.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    private Date getEndTime(SaleVolumeCriterionVo saleVolumeCriterionVo) {
        String timeType = saleVolumeCriterionVo.getTimeType();
        if (TimeTypeEnum.CUSTOM.getDictCode().equals(timeType)) {
            return saleVolumeCriterionVo.getRightTime();
        }
        if (TimeTypeEnum.LAST_MONTH.getDictCode().equals(timeType)) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime lastMonth = now.minusMonths(1L);
            LocalDateTime lastDayOfLastMonth = lastMonth.with(TemporalAdjusters.lastDayOfMonth());
            return Date.from(lastDayOfLastMonth.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (TimeTypeEnum.LAST_QUARTER.getDictCode().equals(timeType)) {
            LocalDate now = LocalDate.now();
            Month firstMonthOfQuarter = Month.of(now.getMonth().firstMonthOfQuarter().getValue());
            Month firstMonthOfLastQuarter = firstMonthOfQuarter.minus(1L);
            int yearOfLastQuarter = firstMonthOfQuarter.getValue() < 4 ? now.getYear() - 1 : now.getYear();
            LocalDateTime lastDayOfLastQuarter = LocalDateTime.of(LocalDate.of(yearOfLastQuarter, firstMonthOfLastQuarter, firstMonthOfLastQuarter.maxLength()), LocalTime.MAX);
            return Date.from(lastDayOfLastQuarter.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (TimeTypeEnum.LAST_YEAR.getDictCode().equals(timeType)) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime lastYear = now.minusYears(1L);
            LocalDateTime lastDayOfLastYear = lastYear.with(TemporalAdjusters.lastDayOfYear());
            return Date.from(lastDayOfLastYear.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    private Map<String, BigDecimal> getResultMap(String instanceCode, Set<String> cusCodes, List<DeliveryDetailVo> deliveryDetailVos) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(cusCodes.size());
        Map<Object, Object> relateToDeliveryMap = new HashMap(0);
        if (!CollectionUtils.isEmpty(deliveryDetailVos)) {
            relateToDeliveryMap = deliveryDetailVos.stream().collect(Collectors.groupingBy(DeliveryDetailVo::getRelateCode));
        }
        for (String cusCode : cusCodes) {
            String key = StringUtils.join((Object[])new String[]{instanceCode, cusCode});
            List deliveryDetails = (List)relateToDeliveryMap.get(cusCode);
            if (CollectionUtils.isEmpty((Collection)deliveryDetails)) {
                resultMap.put(key, BigDecimal.ZERO);
                continue;
            }
            BigDecimal reduce = deliveryDetails.stream().map(DeliveryDetailVo::getDeliveryQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            resultMap.put(key, reduce);
        }
        return resultMap;
    }

    public Boolean isConfigurable() {
        return Boolean.TRUE;
    }
}

