/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.cycleregister;

import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyTaskService;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebateCycleUtil;
import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.biz.crm.dms.business.rebate.sdk.enums.CycleTypeEnum;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCycleRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateExecutionDateRangeVo;
import com.biz.crm.mdm.business.fiscal.year.sdk.service.FiscalYearVoService;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class MonthCycleRegisterImpl
implements SaleRebatePolicyCycleRegister {
    private static final Logger log = LoggerFactory.getLogger(MonthCycleRegisterImpl.class);
    @Autowired(required=false)
    private FiscalYearVoService fiscalYearVoService;
    private static final String REBATE_POLICY_CYCLE_NAME = "\u6708\u5ea6\u8fd4\u5229";
    private static final String REBATE_POLICY_CYCLE_CODE = "MONTHCYCLE";
    private static final Integer REBATE_POLICY_CYCLE_SORT = 2;
    @Autowired(required=false)
    private SaleRebatePolicyTaskService saleRebatePolicyTaskService;

    public String getSaleRebatePolicyCycleCode() {
        return REBATE_POLICY_CYCLE_CODE;
    }

    public String getSaleRebatePolicyCycleName() {
        return REBATE_POLICY_CYCLE_NAME;
    }

    public Integer getCycleSort() {
        return REBATE_POLICY_CYCLE_SORT;
    }

    @Transactional
    public void onRequestcreate(SaleRebatePolicyDto saleRebatePolicyDto) {
        this.saleRebatePolicyTaskService.createRebatetask(saleRebatePolicyDto);
    }

    @Transactional
    public void onRequestUpdate(SaleRebatePolicyDto saleRebatePolicyDto) {
        this.saleRebatePolicyTaskService.updateRebatetask(saleRebatePolicyDto);
    }

    public SaleRebateExecutionDateRangeVo getExecutionDateRangeVo(SaleRebatePolicyDto saleRebatePolicyDto) {
        SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = null;
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        String format = formatDate.format(saleRebatePolicyDto.getCalculateTime());
        if (CycleTypeEnum.CIVIL_YEAR.getKey().equals(saleRebatePolicyDto.getCycleType())) {
            Map<String, SaleRebateExecutionDateRangeVo> saleRebateExecutionDateMap = SaleRebateCycleUtil.getSaleRebateExecutionMonthMap(saleRebatePolicyDto);
            saleRebateExecutionDateRangeVo = saleRebateExecutionDateMap.get(format);
        } else {
            List fiscalYearVoListByDate = this.fiscalYearVoService.findByBeginTimeAndEndTime(saleRebatePolicyDto.getSaleRebateStartTime(), saleRebatePolicyDto.getSaleRebateEndTime());
            if (!CollectionUtils.isEmpty((Collection)fiscalYearVoListByDate)) {
                for (FiscalYearVo fiscalYearVo : fiscalYearVoListByDate) {
                    if (fiscalYearVo.getBeginTime().before(saleRebatePolicyDto.getSaleRebateStartTime())) {
                        fiscalYearVo.setBeginTime(saleRebatePolicyDto.getSaleRebateStartTime());
                    }
                    if (fiscalYearVo.getEndTime().after(saleRebatePolicyDto.getSaleRebateEndTime())) {
                        fiscalYearVo.setEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
                    }
                    Calendar calendarexec = Calendar.getInstance();
                    calendarexec.setTime(fiscalYearVo.getEndTime());
                    calendarexec.set(6, calendarexec.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
                    String execDate = formatDate.format(calendarexec.getTime());
                    if (!execDate.equals(format)) continue;
                    saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
                    saleRebateExecutionDateRangeVo.setSaleRebateStartTime(fiscalYearVo.getBeginTime());
                    saleRebateExecutionDateRangeVo.setSaleRebateEndTime(fiscalYearVo.getEndTime());
                }
            }
        }
        return saleRebateExecutionDateRangeVo;
    }
}

