/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.cycleregister;

import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyTaskService;
import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCycleRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateExecutionDateRangeVo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SingleCycleRegisterImpl
implements SaleRebatePolicyCycleRegister {
    private static final Logger log = LoggerFactory.getLogger(SingleCycleRegisterImpl.class);
    private static final String REBATE_POLICY_CYCLE_NAME = "\u4e00\u6b21\u6027\u8fd4\u5229";
    private static final String REBATE_POLICY_CYCLE_CODE = "SINGLECYCLE";
    private static final Integer REBATE_POLICY_CYCLE_SORT = 6;
    @Autowired(required=false)
    private SaleRebatePolicyTaskService saleRebatePolicyTaskService;

    public String getSaleRebatePolicyCycleCode() {
        return REBATE_POLICY_CYCLE_CODE;
    }

    public String getSaleRebatePolicyCycleName() {
        return REBATE_POLICY_CYCLE_NAME;
    }

    public Integer getCycleSort() {
        return REBATE_POLICY_CYCLE_SORT;
    }

    @Transactional
    public void onRequestcreate(SaleRebatePolicyDto saleRebatePolicyDto) {
        this.saleRebatePolicyTaskService.createRebateSingletask(saleRebatePolicyDto);
    }

    @Transactional
    public void onRequestUpdate(SaleRebatePolicyDto saleRebatePolicyDto) {
        this.saleRebatePolicyTaskService.updateRebatetask(saleRebatePolicyDto);
    }

    public SaleRebateExecutionDateRangeVo getExecutionDateRangeVo(SaleRebatePolicyDto saleRebatePolicyDto) {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        String format = formatDate.format(saleRebatePolicyDto.getCalculateTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
        calendar.set(6, calendar.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
        String format1 = formatDate.format(calendar.getTime());
        if (format.equals(format1)) {
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            saleRebateExecutionDateRangeVo.setSaleRebateEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
            saleRebateExecutionDateRangeVo.setSaleRebateStartTime(saleRebatePolicyDto.getSaleRebateStartTime());
            return saleRebateExecutionDateRangeVo;
        }
        return null;
    }
}

