/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.elementregister;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyCheckProductInfo;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyCheckProductInfoService;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.element.CheckProductSaleRebatePolicyElementDataVo;
import com.biz.crm.dms.business.rebate.sdk.vo.element.CheckProductSaleRebatePolicyElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkProductSaleRebatePolicyElementRegisterImpl")
public class CheckProductSaleRebatePolicyElementRegisterImpl
implements SaleRebatePolicyElementRegister<CheckProductSaleRebatePolicyElementDataVo> {
    private static final Logger log = LoggerFactory.getLogger(CheckProductSaleRebatePolicyElementRegisterImpl.class);
    private static final String REBATE_POLICY_ELEMENT_NAME = "\u8003\u6838\u4ea7\u54c1";
    private static final String REBATE_POLICY_ELEMENT_CODE = "product";
    private static final Integer REBATE_POLICY_ELEMENT_SORT = 1;
    @Autowired(required=false)
    private SaleRebatePolicyCheckProductInfoService saleRebatePolicyCheckProductInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getSaleRebatePolicyElementName() {
        return REBATE_POLICY_ELEMENT_NAME;
    }

    public String getSaleRebatePolicyElementCode() {
        return REBATE_POLICY_ELEMENT_CODE;
    }

    public Integer getElementSort() {
        return REBATE_POLICY_ELEMENT_SORT;
    }

    public Class<CheckProductSaleRebatePolicyElementDataVo> getSaleRebatePolicyElementClass() {
        return CheckProductSaleRebatePolicyElementDataVo.class;
    }

    public CheckProductSaleRebatePolicyElementDataVo getBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        CheckProductSaleRebatePolicyElementDataVo vo = new CheckProductSaleRebatePolicyElementDataVo();
        List<SaleRebatePolicyCheckProductInfo> list = this.saleRebatePolicyCheckProductInfoService.findBySaleRebatePolicyCode(saleRebatePolicyCode);
        if (CollectionUtils.isEmpty(list)) {
            return vo;
        }
        this.getDataVoByList(list, vo);
        return vo;
    }

    public CheckProductSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyCreate(String saleRebatePolicyCode, CheckProductSaleRebatePolicyElementDataVo checkProductSaleRebatePolicyElementDataVo) {
        List<SaleRebatePolicyCheckProductInfo> list = this.getListByDataVo(saleRebatePolicyCode, checkProductSaleRebatePolicyElementDataVo);
        this.saleRebatePolicyCheckProductInfoService.createBatch(list);
        CheckProductSaleRebatePolicyElementDataVo vo = new CheckProductSaleRebatePolicyElementDataVo();
        this.getDataVoByList(list, vo);
        vo.setSaleRebatePolicyCode(saleRebatePolicyCode);
        return vo;
    }

    public CheckProductSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyUpdate(String saleRebatePolicyCode, CheckProductSaleRebatePolicyElementDataVo checkProductSaleRebatePolicyElementDataVo) {
        this.saleRebatePolicyCheckProductInfoService.deleteBySaleRebatePolicyCode(saleRebatePolicyCode);
        List<SaleRebatePolicyCheckProductInfo> list = this.getListByDataVo(saleRebatePolicyCode, checkProductSaleRebatePolicyElementDataVo);
        this.saleRebatePolicyCheckProductInfoService.createBatch(list);
        CheckProductSaleRebatePolicyElementDataVo vo = new CheckProductSaleRebatePolicyElementDataVo();
        this.getDataVoByList(list, vo);
        vo.setSaleRebatePolicyCode(saleRebatePolicyCode);
        return vo;
    }

    private List<SaleRebatePolicyCheckProductInfo> getListByDataVo(String saleRebatePolicyCode, CheckProductSaleRebatePolicyElementDataVo checkProductSaleRebatePolicyElementDataVo) {
        List list = checkProductSaleRebatePolicyElementDataVo.getCheckProductList();
        List newList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, CheckProductSaleRebatePolicyElementVo.class, SaleRebatePolicyCheckProductInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        newList.forEach(e -> {
            e.setSaleRebatePolicyCode(saleRebatePolicyCode);
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        return newList;
    }

    private void getDataVoByList(List<SaleRebatePolicyCheckProductInfo> list, CheckProductSaleRebatePolicyElementDataVo vo) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List newList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SaleRebatePolicyCheckProductInfo.class, CheckProductSaleRebatePolicyElementVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        vo.setCheckProductList(newList);
        vo.setSaleRebatePolicyCode(list.get(0).getSaleRebatePolicyCode());
        vo.setTenantCode(TenantUtils.getTenantCode());
    }
}

