/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.elementregister;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyFormulaInfo;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyFormulaInfoService;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.element.FormulaSaleRebatePolicyElementDataVo;
import com.biz.crm.dms.business.rebate.sdk.vo.element.FormulaSaleRebatePolicyElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="formulaSaleRebatePolicyElementRegisterImpl")
public class FormulaSaleRebatePolicyElementRegisterImpl
implements SaleRebatePolicyElementRegister<FormulaSaleRebatePolicyElementDataVo> {
    private static final Logger log = LoggerFactory.getLogger(FormulaSaleRebatePolicyElementRegisterImpl.class);
    @Autowired(required=false)
    private SaleRebatePolicyFormulaInfoService saleRebatePolicyFormulaInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    private static final String REBATE_POLICY_ELEMENT_NAME = "\u8fd4\u5229\u653f\u7b56\u516c\u5f0f";
    private static final String REBATE_POLICY_ELEMENT_CODE = "formula";
    private static final Integer REBATE_POLICY_ELEMENT_SORT = 4;

    public String getSaleRebatePolicyElementName() {
        return REBATE_POLICY_ELEMENT_NAME;
    }

    public String getSaleRebatePolicyElementCode() {
        return REBATE_POLICY_ELEMENT_CODE;
    }

    public Integer getElementSort() {
        return REBATE_POLICY_ELEMENT_SORT;
    }

    public Class<FormulaSaleRebatePolicyElementDataVo> getSaleRebatePolicyElementClass() {
        return FormulaSaleRebatePolicyElementDataVo.class;
    }

    public FormulaSaleRebatePolicyElementDataVo getBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        FormulaSaleRebatePolicyElementDataVo vo = new FormulaSaleRebatePolicyElementDataVo();
        List<SaleRebatePolicyFormulaInfo> list = this.saleRebatePolicyFormulaInfoService.findBySaleRebatePolicyCode(saleRebatePolicyCode);
        if (CollectionUtils.isEmpty(list)) {
            return vo;
        }
        this.getDataVoByList(list, vo);
        return vo;
    }

    public FormulaSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyCreate(String saleRebatePolicyCode, FormulaSaleRebatePolicyElementDataVo formulaSaleRebatePolicyElementDataVo) {
        List<SaleRebatePolicyFormulaInfo> list = this.getListByDataVo(saleRebatePolicyCode, formulaSaleRebatePolicyElementDataVo);
        this.saleRebatePolicyFormulaInfoService.createBatch(list);
        FormulaSaleRebatePolicyElementDataVo vo = new FormulaSaleRebatePolicyElementDataVo();
        this.getDataVoByList(list, vo);
        vo.setSaleRebatePolicyCode(saleRebatePolicyCode);
        return vo;
    }

    public FormulaSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyUpdate(String saleRebatePolicyCode, FormulaSaleRebatePolicyElementDataVo formulaSaleRebatePolicyElementDataVo) {
        this.saleRebatePolicyFormulaInfoService.deleteBySaleRebatePolicyCode(saleRebatePolicyCode);
        List<SaleRebatePolicyFormulaInfo> list = this.getListByDataVo(saleRebatePolicyCode, formulaSaleRebatePolicyElementDataVo);
        this.saleRebatePolicyFormulaInfoService.createBatch(list);
        FormulaSaleRebatePolicyElementDataVo vo = new FormulaSaleRebatePolicyElementDataVo();
        this.getDataVoByList(list, vo);
        vo.setSaleRebatePolicyCode(saleRebatePolicyCode);
        return vo;
    }

    private void getDataVoByList(List<SaleRebatePolicyFormulaInfo> list, FormulaSaleRebatePolicyElementDataVo vo) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List newList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SaleRebatePolicyFormulaInfo.class, FormulaSaleRebatePolicyElementVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        vo.setFromulaList(newList);
        vo.setSaleRebatePolicyCode(list.get(0).getSaleRebatePolicyCode());
        vo.setTenantCode(TenantUtils.getTenantCode());
    }

    private List<SaleRebatePolicyFormulaInfo> getListByDataVo(String saleRebatePolicyCode, FormulaSaleRebatePolicyElementDataVo formulaSaleRebatePolicyElementDataVo) {
        List list = formulaSaleRebatePolicyElementDataVo.getFromulaList();
        List newList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, FormulaSaleRebatePolicyElementVo.class, SaleRebatePolicyFormulaInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        newList.forEach(e -> {
            e.setSaleRebatePolicyCode(saleRebatePolicyCode);
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        return newList;
    }
}

