/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.elementregister;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyProductInfo;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyProductInfoService;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.element.RebateProductSaleRebatePolicyElementDataVo;
import com.biz.crm.dms.business.rebate.sdk.vo.element.RebateProductSaleRebatePolicyElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rebateProductSaleRebatePolicyElementRegister")
public class RebateProductSaleRebatePolicyElementRegister
implements SaleRebatePolicyElementRegister<RebateProductSaleRebatePolicyElementDataVo> {
    private static final Logger log = LoggerFactory.getLogger(RebateProductSaleRebatePolicyElementRegister.class);
    @Autowired(required=false)
    private SaleRebatePolicyProductInfoService saleRebatePolicyProductInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    private static final String REBATE_POLICY_ELEMENT_NAME = "\u8fd4\u5229\u5546\u54c1";
    private static final String REBATE_POLICY_ELEMENT_CODE = "rebate_product";
    private static final Integer REBATE_POLICY_ELEMENT_SORT = 2;

    public String getSaleRebatePolicyElementName() {
        return REBATE_POLICY_ELEMENT_NAME;
    }

    public String getSaleRebatePolicyElementCode() {
        return REBATE_POLICY_ELEMENT_CODE;
    }

    public Integer getElementSort() {
        return REBATE_POLICY_ELEMENT_SORT;
    }

    public Class<RebateProductSaleRebatePolicyElementDataVo> getSaleRebatePolicyElementClass() {
        return RebateProductSaleRebatePolicyElementDataVo.class;
    }

    public RebateProductSaleRebatePolicyElementDataVo getBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        RebateProductSaleRebatePolicyElementDataVo vo = new RebateProductSaleRebatePolicyElementDataVo();
        List<SaleRebatePolicyProductInfo> list = this.saleRebatePolicyProductInfoService.findBySaleRebatePolicyCode(saleRebatePolicyCode);
        if (CollectionUtils.isEmpty(list)) {
            return vo;
        }
        this.getDataVoByList(list, vo);
        return vo;
    }

    public RebateProductSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyCreate(String saleRebatePolicyCode, RebateProductSaleRebatePolicyElementDataVo rebateProductSaleRebatePolicyElementDataVo) {
        List<SaleRebatePolicyProductInfo> list = this.getListByDataVo(saleRebatePolicyCode, rebateProductSaleRebatePolicyElementDataVo);
        this.saleRebatePolicyProductInfoService.createBatch(list);
        RebateProductSaleRebatePolicyElementDataVo vo = new RebateProductSaleRebatePolicyElementDataVo();
        this.getDataVoByList(list, vo);
        vo.setSaleRebatePolicyCode(saleRebatePolicyCode);
        return vo;
    }

    public RebateProductSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyUpdate(String saleRebatePolicyCode, RebateProductSaleRebatePolicyElementDataVo rebateProductSaleRebatePolicyElementDataVo) {
        this.saleRebatePolicyProductInfoService.deleteBySaleRebatePolicyCode(saleRebatePolicyCode);
        List<SaleRebatePolicyProductInfo> list = this.getListByDataVo(saleRebatePolicyCode, rebateProductSaleRebatePolicyElementDataVo);
        this.saleRebatePolicyProductInfoService.createBatch(list);
        RebateProductSaleRebatePolicyElementDataVo vo = new RebateProductSaleRebatePolicyElementDataVo();
        this.getDataVoByList(list, vo);
        vo.setSaleRebatePolicyCode(saleRebatePolicyCode);
        return vo;
    }

    private void getDataVoByList(List<SaleRebatePolicyProductInfo> list, RebateProductSaleRebatePolicyElementDataVo vo) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List newList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SaleRebatePolicyProductInfo.class, RebateProductSaleRebatePolicyElementVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        vo.setRebateProductList(newList);
        vo.setSaleRebatePolicyCode(list.get(0).getSaleRebatePolicyCode());
        vo.setTenantCode(TenantUtils.getTenantCode());
    }

    private List<SaleRebatePolicyProductInfo> getListByDataVo(String saleRebatePolicyCode, RebateProductSaleRebatePolicyElementDataVo rebateProductSaleRebatePolicyElementDataVo) {
        List list = rebateProductSaleRebatePolicyElementDataVo.getRebateProductList();
        List newList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, RebateProductSaleRebatePolicyElementVo.class, SaleRebatePolicyProductInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        newList.forEach(e -> {
            e.setSaleRebatePolicyCode(saleRebatePolicyCode);
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        return newList;
    }
}

