/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.elementregister;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyScopeInfo;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyScopeInfoService;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.element.ScopeSaleRebatePolicyElementDataVo;
import com.biz.crm.dms.business.rebate.sdk.vo.element.ScopeSaleRebatePolicyElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="scopeSaleRebatePolicyElementRegisterImpl")
public class ScopeSaleRebatePolicyElementRegisterImpl
implements SaleRebatePolicyElementRegister<ScopeSaleRebatePolicyElementDataVo> {
    private static final Logger log = LoggerFactory.getLogger(ScopeSaleRebatePolicyElementRegisterImpl.class);
    private static final String REBATE_POLICY_ELEMENT_NAME = "\u8fd4\u5229\u653f\u7b56\u8303\u56f4";
    private static final String REBATE_POLICY_ELEMENT_CODE = "scope";
    private static final Integer REBATE_POLICY_ELEMENT_SORT = 3;
    @Autowired(required=false)
    private SaleRebatePolicyScopeInfoService saleRebatePolicyScopeInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getSaleRebatePolicyElementName() {
        return REBATE_POLICY_ELEMENT_NAME;
    }

    public String getSaleRebatePolicyElementCode() {
        return REBATE_POLICY_ELEMENT_CODE;
    }

    public Integer getElementSort() {
        return REBATE_POLICY_ELEMENT_SORT;
    }

    public Class<ScopeSaleRebatePolicyElementDataVo> getSaleRebatePolicyElementClass() {
        return ScopeSaleRebatePolicyElementDataVo.class;
    }

    public ScopeSaleRebatePolicyElementDataVo getBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        ScopeSaleRebatePolicyElementDataVo vo = new ScopeSaleRebatePolicyElementDataVo();
        List<SaleRebatePolicyScopeInfo> list = this.saleRebatePolicyScopeInfoService.findBySaleRebatePolicyCode(saleRebatePolicyCode);
        if (CollectionUtils.isEmpty(list)) {
            return vo;
        }
        this.getDataVoByList(list, vo);
        return vo;
    }

    public ScopeSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyCreate(String saleRebatePolicyCode, ScopeSaleRebatePolicyElementDataVo scopeSaleRebatePolicyElementDataVo) {
        List<SaleRebatePolicyScopeInfo> list = this.getListByDataVo(saleRebatePolicyCode, scopeSaleRebatePolicyElementDataVo);
        HashSet<SaleRebatePolicyScopeInfo> set = new HashSet<SaleRebatePolicyScopeInfo>();
        set.addAll(list);
        this.saleRebatePolicyScopeInfoService.createBatch(set);
        ScopeSaleRebatePolicyElementDataVo vo = new ScopeSaleRebatePolicyElementDataVo();
        this.getDataVoByList(list, vo);
        vo.setSaleRebatePolicyCode(saleRebatePolicyCode);
        return vo;
    }

    public ScopeSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyUpdate(String saleRebatePolicyCode, ScopeSaleRebatePolicyElementDataVo scopeSaleRebatePolicyElementDataVo) {
        this.saleRebatePolicyScopeInfoService.deleteBySaleRebatePolicyCode(saleRebatePolicyCode);
        List<SaleRebatePolicyScopeInfo> list = this.getListByDataVo(saleRebatePolicyCode, scopeSaleRebatePolicyElementDataVo);
        HashSet<SaleRebatePolicyScopeInfo> set = new HashSet<SaleRebatePolicyScopeInfo>();
        set.addAll(list);
        this.saleRebatePolicyScopeInfoService.createBatch(set);
        ScopeSaleRebatePolicyElementDataVo vo = new ScopeSaleRebatePolicyElementDataVo();
        this.getDataVoByList(list, vo);
        return vo;
    }

    private void getDataVoByList(List<SaleRebatePolicyScopeInfo> list, ScopeSaleRebatePolicyElementDataVo vo) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List newList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SaleRebatePolicyScopeInfo.class, ScopeSaleRebatePolicyElementVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        vo.setScopeList(newList);
        vo.setSaleRebatePolicyCode(list.get(0).getSaleRebatePolicyCode());
        vo.setTenantCode(TenantUtils.getTenantCode());
    }

    private List<SaleRebatePolicyScopeInfo> getListByDataVo(String saleRebatePolicyCode, ScopeSaleRebatePolicyElementDataVo scopeSaleRebatePolicyElementDataVo) {
        List list = scopeSaleRebatePolicyElementDataVo.getScopeList();
        List newList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ScopeSaleRebatePolicyElementVo.class, SaleRebatePolicyScopeInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        newList.forEach(e -> {
            e.setSaleRebatePolicyCode(saleRebatePolicyCode);
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        return newList;
    }
}

