/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.templateregister;

import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentProductDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolPayTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolUseTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.OperationTypeStrategy;
import com.biz.crm.dms.business.rebate.local.service.register.elementregister.CheckProductSaleRebatePolicyElementRegisterImpl;
import com.biz.crm.dms.business.rebate.local.service.register.elementregister.FormulaSaleRebatePolicyElementRegisterImpl;
import com.biz.crm.dms.business.rebate.local.service.register.elementregister.RebateProductSaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.local.service.register.elementregister.ScopeSaleRebatePolicyElementRegisterImpl;
import com.biz.crm.dms.business.rebate.local.strategy.ChannelForSaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.local.strategy.DistributorForSaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.local.strategy.OrgForSaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebatePolicyCalculateUtil;
import com.biz.crm.dms.business.rebate.sdk.enums.SaleRebatePolicyProductTypeEnum;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyTemplateRegister;
import com.biz.crm.dms.business.rebate.sdk.strategy.SaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateComputeBuildParamVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateComputeParamVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyDetailVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyFormulaInfoVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyVo;
import com.biz.crm.dms.business.rebate.sdk.vo.scope.AbstractSaleRebatePolicyCustomerInfo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CompensateRebateTemplateRegister
implements SaleRebatePolicyTemplateRegister {
    private static final Logger log = LoggerFactory.getLogger(CompensateRebateTemplateRegister.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<SaleRebatePolicyCriterionRegister> saleRebatePolicyCriterionRegisters;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    @Qualifier(value="replenishmentAccountOperationTypeStrategyImpl")
    private OperationTypeStrategy operationTypeStrategy;
    @Autowired(required=false)
    private ProductVoService productVoService;
    private static final String REBATE_POLICY_TEMPLATE_NAME = "\u8d27 \u8865";
    private static final String REBATE_POLICY_TEMPLATE_CODE = "compensateRebateTemplate";
    private static final Integer REBATE_POLICY_TEMPLATE_SORT = 1;

    public String getSaleRebatePolicytemplateCode() {
        return REBATE_POLICY_TEMPLATE_CODE;
    }

    public String getSaleRebatePolicytemplateName() {
        return REBATE_POLICY_TEMPLATE_NAME;
    }

    public Integer getTemplateSort() {
        return REBATE_POLICY_TEMPLATE_SORT;
    }

    public Collection<Class<? extends SaleRebateCustomerScopeStrategy<? extends AbstractSaleRebatePolicyCustomerInfo>>> getCustomerScopeStrategyClasses() {
        return Sets.newHashSet((Object[])new Class[]{DistributorForSaleRebateCustomerScopeStrategy.class, ChannelForSaleRebateCustomerScopeStrategy.class, OrgForSaleRebateCustomerScopeStrategy.class});
    }

    public Collection<Class<? extends SaleRebatePolicyElementRegister>> getSaleRebateElementClasses() {
        return Sets.newHashSet((Object[])new Class[]{CheckProductSaleRebatePolicyElementRegisterImpl.class, FormulaSaleRebatePolicyElementRegisterImpl.class, ScopeSaleRebatePolicyElementRegisterImpl.class, RebateProductSaleRebatePolicyElementRegister.class});
    }

    public List<SaleRebateComputeParamVo> onbuildParam(List<SaleRebateComputeBuildParamVo> saleRebateComputeBuildParamVos) {
        if (CollectionUtils.isNotEmpty(saleRebateComputeBuildParamVos)) {
            return this.buildParam(saleRebateComputeBuildParamVos);
        }
        return null;
    }

    public void onAccount(List<SaleRebatePolicyDetailVo> saleRebatePolicyDetailVos) {
        if (!CollectionUtils.isEmpty(saleRebatePolicyDetailVos)) {
            List productVos;
            HashMap<String, ProductVo> productVoMap = new HashMap<String, ProductVo>();
            List productCodes = saleRebatePolicyDetailVos.stream().filter(saleRebatePolicyDetailVo -> SaleRebatePolicyProductTypeEnum.PRODUCT.getKey().equals(saleRebatePolicyDetailVo.getProductType())).map(SaleRebatePolicyDetailVo::getProductCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(productCodes) && CollectionUtils.isNotEmpty((Collection)(productVos = this.productVoService.findMainDetailsByProductCodes(productCodes)))) {
                productVoMap.putAll(productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, t -> t, (key1, key2) -> key2)));
            }
            saleRebatePolicyDetailVos.forEach(saleRebatePolicyDetailVo -> {
                CostPoolReplenishmentDto dto = new CostPoolReplenishmentDto();
                dto.setPoolType(PoolTypeEnum.Replenishment.getKey());
                dto.setCustomerCode(saleRebatePolicyDetailVo.getCustomerCode());
                dto.setFromCode(saleRebatePolicyDetailVo.getSaleRebateDetailCode());
                dto.setFromDesc(PoolOperationTypeEnum.REBATE_ACCOUNT.getValue());
                dto.setAmount(saleRebatePolicyDetailVo.getActualRebateAmount());
                dto.setPoolGroup(PoolGroupEnum.DEFAULT.getDictCode());
                dto.setPayType(PoolPayTypeEnum.Replenishment.getDictCode());
                dto.setUseType(PoolUseTypeEnum.DEFAULT.getDictCode());
                dto.setCustomerName(saleRebatePolicyDetailVo.getCustomerName());
                dto.setOperationType(PoolOperationTypeEnum.REBATE_ACCOUNT.getDictCode());
                if (SaleRebatePolicyProductTypeEnum.PRODUCT.getKey().equals(saleRebatePolicyDetailVo.getProductType())) {
                    CostPoolReplenishmentProductDto costPoolReplenishmentProductDto = new CostPoolReplenishmentProductDto();
                    costPoolReplenishmentProductDto.setGoodsProductCode(saleRebatePolicyDetailVo.getProductCode());
                    costPoolReplenishmentProductDto.setGoodsProductName(saleRebatePolicyDetailVo.getProductName());
                    dto.setCostPoolReplenishmentProduct(Collections.singletonList(costPoolReplenishmentProductDto));
                    ProductVo productVo = (ProductVo)productVoMap.get(saleRebatePolicyDetailVo.getProductCode());
                    if (Objects.isNull(productVo)) {
                        return;
                    }
                    dto.setGoodsProductLevelCode(productVo.getProductLevelCode());
                    dto.setGoodsProductLevelName(productVo.getProductLevelName());
                } else {
                    dto.setGoodsProductLevelCode(saleRebatePolicyDetailVo.getProductLevelCode());
                    dto.setGoodsProductLevelName(saleRebatePolicyDetailVo.getProductLevelName());
                }
                this.operationTypeStrategy.onSaveDiscountInfos(dto);
            });
        }
    }

    private List<SaleRebateComputeParamVo> buildParam(List<SaleRebateComputeBuildParamVo> saleRebateComputeParamVos) {
        ArrayList params = Lists.newArrayList();
        saleRebateComputeParamVos.forEach(saleRebateComputeBuildParamVo -> {
            Set cusCodes = saleRebateComputeBuildParamVo.getCustomerCodes();
            Set productCodes = saleRebateComputeBuildParamVo.getProductCodes();
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)cusCodes), (String)"\u8fd4\u5229\u653f\u7b56\u5ba2\u6237\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List customerVos = this.customerVoService.findForPriceByCustomerCodes(cusCodes);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)customerVos), (String)"\u5ba2\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            List formulaInfos = saleRebateComputeBuildParamVo.getSaleRebatePolicyFormulaInfoVos();
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)formulaInfos), (String)"\u8fd4\u5229\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)saleRebateComputeBuildParamVo.getSaleRebateStartTime(), (String)"\u8fd4\u5229\u672c\u6b21\u6267\u884c\u8303\u56f4\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)saleRebateComputeBuildParamVo.getSaleRebateEndTime(), (String)"\u8fd4\u5229\u672c\u6b21\u6267\u884c\u8303\u56f4\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Map<String, BigDecimal> amountMap = this.getAmountMap(formulaInfos, productCodes, customerVos, (SaleRebateComputeBuildParamVo)saleRebateComputeBuildParamVo);
            Validate.notNull(amountMap, (String)"\u8fd4\u5229\u516c\u5f0f\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List saleRebatePolicyProductInfoVos = saleRebateComputeBuildParamVo.getSaleRebatePolicyProductInfoVos();
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)saleRebatePolicyProductInfoVos), (String)"\u8fd4\u5229\u653f\u7b56\u4e2d\u8fd4\u5229\u5546\u54c1\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            customerVos.forEach(cus -> saleRebatePolicyProductInfoVos.forEach(product -> formulaInfos.forEach(express -> {
                SaleRebateComputeParamVo param = (SaleRebateComputeParamVo)this.nebulaToolkitService.copyObjectByBlankList(product, SaleRebateComputeParamVo.class, HashSet.class, ArrayList.class, new String[0]);
                param.setCode(product.getCode());
                param.setName(product.getName());
                param.setProductType(Integer.valueOf(product.getType()));
                param.setAllocationType(product.getAllocationType());
                param.setRebateRatio(product.getRebateRatio());
                SaleRebatePolicyFormulaInfoVo saleRebatePolicyFormulaInfoVo = (SaleRebatePolicyFormulaInfoVo)this.nebulaToolkitService.copyObjectByBlankList(express, SaleRebatePolicyFormulaInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
                param.setCusJson(JsonUtils.toJSONObject((Object)cus));
                param.setSaleRebatePolicyFormulaInfoVo(saleRebatePolicyFormulaInfoVo);
                param.setAmountMap(amountMap);
                param.setSaleRebateStartTime(saleRebateComputeBuildParamVo.getSaleRebateStartTime());
                param.setSaleRebateEndTime(saleRebateComputeBuildParamVo.getSaleRebateEndTime());
                param.setSaleRebateComputeStartTime(saleRebateComputeBuildParamVo.getSaleRebateStartTime());
                param.setSaleRebateComputeEndTime(saleRebateComputeBuildParamVo.getSaleRebateEndTime());
                param.setSaleRebatePolicyVo(saleRebateComputeBuildParamVo.getSaleRebatePolicyVo());
                param.setAllocationType(product.getAllocationType());
                param.setSpeedNo(saleRebateComputeBuildParamVo.getSpeedNo());
                param.setCalculationTime(saleRebateComputeBuildParamVo.getCalculationTime());
                params.add(param);
            })));
        });
        return params;
    }

    private Map<String, BigDecimal> getAmountMap(List<SaleRebatePolicyFormulaInfoVo> formulaInfos, Set<String> productCodes, List<CustomerVo> customerVos, SaleRebateComputeBuildParamVo saleRebateComputeBuildParamVo) {
        Set<String> collect = SaleRebatePolicyCalculateUtil.getCriterionSet(formulaInfos);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        collect.forEach(s -> {
            List list = this.saleRebatePolicyCriterionRegisters.stream().filter(saleRebatePolicyCriterionRegister -> s.startsWith(saleRebatePolicyCriterionRegister.getSaleRebatePolicyCriterionCode())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u57fa\u51c6\u6ce8\u518c\u5668\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            SaleRebatePolicyCriterionRegister bean = (SaleRebatePolicyCriterionRegister)list.get(0);
            Set saleRebateCustomerSet = customerVos.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toSet());
            SaleRebatePolicyVo saleRebatePolicyVo = saleRebateComputeBuildParamVo.getSaleRebatePolicyVo();
            String saleRebatePolicyCode = saleRebatePolicyVo.getSaleRebatePolicyCode();
            amountMap.putAll(bean.getAmountMap(s, saleRebatePolicyCode, saleRebateCustomerSet, productCodes, saleRebateComputeBuildParamVo.getSaleRebateStartTime(), saleRebateComputeBuildParamVo.getSaleRebateEndTime(), saleRebatePolicyVo.getSaleRebateStartTime(), saleRebatePolicyVo.getSaleRebateEndTime()));
        });
        return amountMap;
    }
}

