/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.strategy;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyScopeInfo;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyScopeInfoService;
import com.biz.crm.dms.business.rebate.local.strategy.AbstractSaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.strategy.SaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.vo.scope.SaleRebatePolicyScopeOrgInfoVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrgForSaleRebateCustomerScopeStrategy
extends AbstractSaleRebateCustomerScopeStrategy
implements SaleRebateCustomerScopeStrategy<SaleRebatePolicyScopeOrgInfoVo> {
    @Autowired(required=false)
    private SaleRebatePolicyScopeInfoService saleRebatePolicyScopeInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    private static final String SCOPE_TYPE = "orgForSalePolicyCustomer";
    private static final Integer SCOPE_SORT = 3;

    public String getScopeType() {
        return SCOPE_TYPE;
    }

    public String getScopeTypeDesc() {
        return "\u7ec4\u7ec7\u673a\u6784";
    }

    public Integer getSort() {
        return SCOPE_SORT;
    }

    public Set<String> onRequestCustomerCodes(String salePolicyCode, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode})) {
            return null;
        }
        List<SaleRebatePolicyScopeInfo> salePolicyScopeInfos = this.saleRebatePolicyScopeInfoService.findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(tenantCode, salePolicyCode, SCOPE_TYPE);
        if (CollectionUtils.isEmpty(salePolicyScopeInfos)) {
            return null;
        }
        Set<String> customerCodes = this.buildCustomerCodes(salePolicyScopeInfos);
        if (CollectionUtils.isEmpty(customerCodes)) {
            return null;
        }
        return customerCodes;
    }

    private Set<String> buildCustomerCodes(List<SaleRebatePolicyScopeInfo> salePolicyScopeInfos) {
        List includeList = salePolicyScopeInfos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCode())).map(SaleRebatePolicyScopeInfo::getCode).collect(Collectors.toList());
        List includeCustomerCodeList = this.customerVoService.findByOrgCodes(includeList);
        if (CollectionUtils.isEmpty((Collection)includeCustomerCodeList)) {
            return null;
        }
        Set<String> includeCustomerCodes = includeCustomerCodeList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toSet());
        return includeCustomerCodes;
    }
}

