package com.biz.crm.dms.business.rebate.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 返利政策主表
 * @author: rentao
 * @date: 2022/2/15 14:39
 */
@Getter
@Setter
@TableName("dms_sale_rebate_policy")
@Entity
@Table(name = "dms_sale_rebate_policy" , indexes = {@Index(columnList = "tenant_code , sale_rebate_policy_code" , unique = true),
    @Index(columnList = "tenant_code, sale_rebate_start_time , sale_rebate_end_time")})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_rebate_policy", comment = "返利政策，按照租户进行隔离")
public class SaleRebatePolicy extends TenantFlagOpEntity {

  private static final long serialVersionUID = 4598956993151944736L;
  /**
   * 返利编码（一旦创建，不允许修改），不输入就是系统生成(按照租户生成)
   */
  @Column(name = "sale_rebate_policy_code" , length = 225 , nullable = false, columnDefinition = "VARCHAR(225) COMMENT '促销编码'")
  @ApiModelProperty("返利编码")
  private String saleRebatePolicyCode;

  /**
   * 返利名称
   */
  @Column(name = "sale_rebate_policy_name" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '促销名称'")
  @ApiModelProperty("返利名称")
  private String saleRebatePolicyName;

  /**
   * 返利状态
   */
  @Column(name = "sale_rebate_policy_status" ,  columnDefinition = "int(5) COMMENT '返利状态'")
  @ApiModelProperty("返利状态")
  private Integer saleRebatePolicyStatus;

  /**
   * 周期类型 自然年 企业财年
   */
  @Column(name = "cycle_type" , columnDefinition = "int(5) COMMENT '周期类型 自然年 企业财年'")
  @ApiModelProperty("周期类型")
  private Integer cycleType;

  /**
   * 返利周期
   */
  @Column(name = "sale_rebate_policy_cycle" , columnDefinition = "varchar(64) COMMENT '返利周期'")
  @ApiModelProperty("返利周期")
  private String saleRebatePolicyCycle;

  /**
   * 返利周期
   */
  @Column(name = "sale_rebate_policy_cycle_name" , columnDefinition = "varchar(64) COMMENT '返利周期名称'")
  @ApiModelProperty("返利周期名称")
  private String saleRebatePolicyCycleName;

  /**
   * 上账方式 手动 自动
   */
  @Column(name = "bill_type" , columnDefinition = "int(5) COMMENT '上账方式 手动 自动'")
  @ApiModelProperty("上账方式")
  private Integer billType;

  /**
   * 返利政策开始时间（包括）
   */
  @Column(name = "sale_rebate_start_time" , nullable = false, columnDefinition = "Datetime COMMENT '返利政策开始时间（包括）'")
  @ApiModelProperty("返利政策开始时间（包括）")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date saleRebateStartTime;

  /**
   * 返利政策结束时间（包括）
   */
  @Column(name = "sale_rebate_end_time" , nullable = false, columnDefinition = "Datetime COMMENT '返利政策结束时间（包括）'")
  @ApiModelProperty("返利政策结束时间（包括）")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date saleRebateEndTime;

  /**
   * 返利类型 货补 折扣
   */
  @Column(name = "sale_rebate_type" , columnDefinition = "VARCHAR(128) COMMENT '返利类型 货补 折扣'")
  @ApiModelProperty("返利类型编码")
  private String saleRebateType;

  /**
   * 返利类型 货补 折扣
   */
  @Column(name = "sale_rebate_type_name" , columnDefinition = "VARCHAR(128) COMMENT '返利类型名称 货补 折扣'")
  @ApiModelProperty("返利类型名称")
  private String saleRebateTypeName;

  /**
   * 计算时间 返利政策结束后第几天
   */
  @Column(name = "calculate_day_num" , columnDefinition = "int(5) COMMENT '计算时间 返利政策结束后第几天'")
  @ApiModelProperty("计算时间 返利政策结束后第几天")
  private Integer calculateDayNum;

}
