package com.biz.crm.dms.business.rebate.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyCheckProductInfo;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyFormulaInfo;
import com.biz.crm.dms.business.rebate.local.mapper.SaleRebatePolicyFormulaInfoMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 返利政策公式(SaleRebatePolicyFormulaInfo)
 *
 * @author rentao
 * @since 2022-02-16 17:55:57
 */
@Component
public class SaleRebatePolicyFormulaInfoRepository extends
    ServiceImpl<SaleRebatePolicyFormulaInfoMapper, SaleRebatePolicyFormulaInfo> {

  /**
   * 分页查询
   *
   * @param pageable                    分页
   * @param saleRebatePolicyFormulaInfo
   * @return
   */
  public Page<SaleRebatePolicyFormulaInfo> findByConditions(Pageable pageable,
      SaleRebatePolicyFormulaInfo saleRebatePolicyFormulaInfo) {
    Page<SaleRebatePolicyFormulaInfo> page = new Page<>(pageable.getPageNumber(),
        pageable.getPageSize());
    Page<SaleRebatePolicyFormulaInfo> pageList = this.baseMapper
        .findByConditions(page, saleRebatePolicyFormulaInfo);
    return pageList;
  }

  /**
   * 根据编码查询
   *
   * @param saleRebatePolicyCode
   * @return
   */
  public List<SaleRebatePolicyFormulaInfo> findBySaleRebatePolicyCode(String saleRebatePolicyCode) {
    return this.lambdaQuery()
        .eq(SaleRebatePolicyFormulaInfo::getSaleRebatePolicyCode, saleRebatePolicyCode)
        .eq(SaleRebatePolicyFormulaInfo::getTenantCode, TenantUtils.getTenantCode())
        .list();
  }

  /**
   * 根据编码查询
   *
   * @param saleRebatePolicyCodes
   * @return
   */
  public List<SaleRebatePolicyFormulaInfo> findBySaleRebatePolicyCodes(
      List<String> saleRebatePolicyCodes) {
    return this.lambdaQuery()
        .in(SaleRebatePolicyFormulaInfo::getSaleRebatePolicyCode, saleRebatePolicyCodes)
        .eq(SaleRebatePolicyFormulaInfo::getTenantCode, TenantUtils.getTenantCode())
        .list();
  }


  /**
   * 删除
   *
   * @param saleRebatePolicyCode
   * @return
   */
  public void deleteBySaleRebatePolicyCode(String saleRebatePolicyCode) {
    this.lambdaUpdate()
        .eq(SaleRebatePolicyFormulaInfo::getTenantCode, TenantUtils.getTenantCode())
        .eq(SaleRebatePolicyFormulaInfo::getSaleRebatePolicyCode, saleRebatePolicyCode)
        .remove();
  }
}

