package com.biz.crm.dms.business.rebate.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.rebate.local.constant.SalePolicyConstant;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyTaskService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyCalculateService;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebateCycleUtil;
import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 返利定时任务 service
 * @author: rentao
 * @date: 2022/2/22 11:16
 */
@Service
@Slf4j
public class SaleRebatePolicyTaskServiceImpl implements SaleRebatePolicyTaskService {

  @Autowired(required = false)
  private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
  @Autowired(required = false)
  private SaleRebatePolicyCalculateService saleRebatePolicycalculateService;


  /**
   *
   * @param saleRebatePolicyCode
   * @author rentao
   * @date
   */
  @Override
  @Transactional
  public void handleRebateTask(String saleRebatePolicyCode) {
    this.saleRebatePolicycalculateService.onCalculateByCode(
        Collections.singletonList(saleRebatePolicyCode), BooleanEnum.FALSE.getNumStr(),new Date());
  }

  @Override
  @Transactional
  public void createRebatetask(SaleRebatePolicyDto saleRebatePolicyDto) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
    calendar.set(Calendar.DAY_OF_YEAR,
        calendar.get(Calendar.DAY_OF_YEAR) + saleRebatePolicyDto.getCalculateDayNum());
    Date validityTime = SaleRebateCycleUtil.getLastday(calendar.getTime());
    dynamicTaskSchedulerVoService.createIgnorePrefix(
        saleRebatePolicyDto.getSaleRebatePolicyCode(),
        SalePolicyConstant.TASK_INVOKE_BEAN_NAME,
        SalePolicyConstant.TASK_METHOD,
        2,
        SaleRebateCycleUtil.createCronExpression(),
        null,
        validityTime,
        saleRebatePolicyDto.getSaleRebatePolicyName() + "定时任务",
        saleRebatePolicyDto.getSaleRebatePolicyCode(), TenantUtils.getAppCode(),TenantUtils.getTenantCode());
  }

  /**
   * 创建定时任务（一次性）
   *
   * @param saleRebatePolicyDto
   * @author rentao
   * @date
   */
  @Override
  @Transactional
  public void createRebateSingletask(SaleRebatePolicyDto saleRebatePolicyDto) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
    calendar.set(Calendar.DAY_OF_YEAR,
        calendar.get(Calendar.DAY_OF_YEAR) + saleRebatePolicyDto.getCalculateDayNum());
    //执行日期
    Date firstday = SaleRebateCycleUtil.getFirstday(calendar.getTime());
    dynamicTaskSchedulerVoService.createIgnorePrefix(
        saleRebatePolicyDto.getSaleRebatePolicyCode(),
        SalePolicyConstant.TASK_INVOKE_BEAN_NAME,
        SalePolicyConstant.TASK_METHOD,
        1,
        null,
        firstday,
        SaleRebateCycleUtil.getLastday(firstday),
        saleRebatePolicyDto.getSaleRebatePolicyName() + "一次性定时任务",
        saleRebatePolicyDto.getSaleRebatePolicyCode(), TenantUtils.getAppCode(),TenantUtils.getTenantCode());
  }

  /**
   * 编辑定时任务
   *
   * @param saleRebatePolicyDto
   * @author rentao
   * @date
   */
  @Override
  @Transactional
  public void updateRebatetask(SaleRebatePolicyDto saleRebatePolicyDto) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
    calendar.set(Calendar.DAY_OF_YEAR,
        calendar.get(Calendar.DAY_OF_YEAR) + saleRebatePolicyDto.getCalculateDayNum());
    Date validityTime = SaleRebateCycleUtil.getLastday(calendar.getTime());
    dynamicTaskSchedulerVoService.updateIgnorePrefix(
        saleRebatePolicyDto.getSaleRebatePolicyCode(),
        SaleRebateCycleUtil.createCronExpression(),
        validityTime,
        saleRebatePolicyDto.getSaleRebatePolicyName() + "定时任务",
        saleRebatePolicyDto.getSaleRebatePolicyCode(),TenantUtils.getAppCode(),TenantUtils.getTenantCode());
  }

  /**
   * 根据无效化计算定时任务
   *
   * @param taskCodes
   */
  @Override
  @Transactional
  public void invalidBatchBySaleRebatePolicyCodes(List<String> taskCodes) {
    dynamicTaskSchedulerVoService.invalid(taskCodes.stream().toArray(String[]::new));
  }

  /**
   * 根据有效化计算定时任务
   *
   * @param taskCodes
   */
  @Override
  @Transactional
  public void effectiveBatchBySaleRebatePolicyCodes(List<String> taskCodes) {
    dynamicTaskSchedulerVoService.effective(taskCodes.stream().toArray(String[]::new));
  }

  /**
   * 根据删除计算定时任务
   *
   * @param taskCodes
   */
  @Override
  @Transactional
  public void deleteBatchBySaleRebatePolicyCodes(List<String> taskCodes) {
    dynamicTaskSchedulerVoService.invalid(taskCodes.stream().toArray(String[]::new));
    dynamicTaskSchedulerVoService.deleteByTaskcodes(taskCodes.stream().toArray(String[]::new));
  }

}



