package com.biz.crm.dms.business.rebate.local.service.register.criterionregister;

import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @description: 返利政策基准注册（月销售数量）
 * @author: rentao
 * @date: 2022/2/28 10:54
 */
@Service
@Slf4j
public class SaleRebateMothCriterionRegister implements SaleRebatePolicyCriterionRegister {


  /**
   * 返利政策基准名称
   */
  private static final String REBATE_POLICY_CRITERION_NAME = "月销售数量";

  /**
   * 返利政策基准编码
   */
  private static final String REBATE_POLICY_CRITERION_CODE = "YXSSL";

  /**
   * 排序
   */
  private static final Integer REBATE_POLICY_CRITERION_SORT = 1;

  @Override
  public String getSaleRebatePolicyCriterionCode() {
    return REBATE_POLICY_CRITERION_CODE;
  }

  @Override
  public String getSaleRebatePolicyCriterionName() {
    return REBATE_POLICY_CRITERION_NAME;
  }

  @Override
  public Integer getCriterionSort() {
    return REBATE_POLICY_CRITERION_SORT;
  }

  @Override
  public Map<String, BigDecimal> getAmountMap(String saleRebatePolicyCriterionCode,String saleRebatePolicyCode,Set<String> cusCodes, Set<String> productCode,
      Date startTime,Date endTime,Date saleRebateStartTime, Date saleRebateEndTime) {
    //todo 通过时间 产品 客户查询基准
    Validate.isTrue(!CollectionUtils.isEmpty(cusCodes), "基准信息查询时客户集合为空");
    Validate.isTrue(!CollectionUtils.isEmpty(productCode), "基准信息查询时考核产品集合为空");
    Validate.notNull(startTime, "基准信息查询时开始时间为空");
    Validate.notNull(endTime, "基准信息查询时结束时间为空");
    Map<String, BigDecimal> map = new HashMap<>();
    cusCodes.forEach(s -> {
          String key = REBATE_POLICY_CRITERION_CODE + s;
          map.put(key, BigDecimal.valueOf(50));
        }
    );
    return map;
  }


}
