package com.biz.crm.dms.business.rebate.local.service.register.criterionregister;

import com.biz.crm.dms.business.delivery.sdk.dto.DeliverySalesTargetDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryDetailVo;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebateCycleUtil;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateExecutionDateRangeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @description: 返利政策基准注册（季销售数量）
 * @author: rentao
 * @date: 2022/2/28 11:11
 */
@Service
@Slf4j
public class SaleRebateQuarterQuantityRegister implements SaleRebatePolicyCriterionRegister {

  @Autowired(required = false)
  private DeliveryDetailVoService deliveryDetailVoService;

  /**
   * 返利政策基准名称
   */
  private static final String REBATE_POLICY_CRITERION_NAME = "季销售数量";

  /**
   * 返利政策基准编码
   */
  private static final String REBATE_POLICY_CRITERION_CODE = "JXSSL";

  /**
   * 排序
   */
  private static final Integer REBATE_POLICY_CRITERION_SORT = 2;

  @Override
  public String getSaleRebatePolicyCriterionCode() {
    return REBATE_POLICY_CRITERION_CODE;
  }

  @Override
  public String getSaleRebatePolicyCriterionName() {
    return REBATE_POLICY_CRITERION_NAME;
  }

  @Override
  public Integer getCriterionSort() {
    return REBATE_POLICY_CRITERION_SORT;
  }

  @Override
  public Map<String, BigDecimal> getAmountMap(String saleRebatePolicyCriterionCode,String saleRebatePolicyCode, Set<String> cusCodes, Set<String> productCode,
      Date startTime,Date endTime,Date saleRebateStartTime, Date saleRebateEndTime) {
    //分割季度(政策开始时间的季度)
    List<SaleRebateExecutionDateRangeVo> executionQuarterList = SaleRebateCycleUtil
        .getExecutionQuarterList(saleRebateStartTime, saleRebateEndTime);
    Map<String, SaleRebateExecutionDateRangeVo> saleRebateExecutionDateRangeVoMap = executionQuarterList.stream()
        .collect(Collectors.toMap(SaleRebateExecutionDateRangeVo::getSaleRebateQuarter, t -> t));
    //拿到本次执行日期的集合按照季度去分割得到 年度+季度例如 2021-1季度
    List<String> list = this.getQuarterList(startTime,endTime);
    //本次需要分开执行的季度
    List<SaleRebateExecutionDateRangeVo> dateRangeVoList = new ArrayList<>();
    list.forEach(s -> {
      SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = saleRebateExecutionDateRangeVoMap
          .get(s);
      if(Objects.nonNull(saleRebateExecutionDateRangeVo)){
        dateRangeVoList.add(saleRebateExecutionDateRangeVo);
      }
    });
    Validate.isTrue(!CollectionUtils.isEmpty(cusCodes), "基准信息查询时客户集合为空");
    Validate.isTrue(!CollectionUtils.isEmpty(productCode), "基准信息查询时考核产品集合为空");
    Validate.notNull(startTime, "基准信息查询时开始时间为空");
    Validate.notNull(endTime, "基准信息查询时结束时间为空");
    DeliverySalesTargetDto deliverySalesTargetDto = new DeliverySalesTargetDto();
    deliverySalesTargetDto.setCustomerCodes(cusCodes);
    deliverySalesTargetDto.setGoodsCodes(productCode);
    deliverySalesTargetDto.setTenantCode(TenantUtils.getTenantCode());
    Map<String, BigDecimal> map = new HashMap<>();
    Date saleRebateEnd = dateRangeVoList.stream().max(Comparator.comparing(SaleRebateExecutionDateRangeVo::getSaleRebateEndTime)).get().getSaleRebateEndTime();
    Date saleRebateBegin = dateRangeVoList.stream().min(Comparator.comparing(SaleRebateExecutionDateRangeVo::getSaleRebateStartTime)).get().getSaleRebateStartTime();
    deliverySalesTargetDto.setEndTime(saleRebateEnd);
    deliverySalesTargetDto.setStartTime(saleRebateBegin);
    List<DeliveryDetailVo> deliveryDetailVos = this.deliveryDetailVoService
        .findByRelateCodesInAndGoodsCodesInAndBetweenStartTimeAndEndTime(deliverySalesTargetDto);
    Map<String, List<DeliveryDetailVo>> listMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(deliveryDetailVos)) {
      listMap.putAll(deliveryDetailVos.stream().collect(Collectors.groupingBy(DeliveryDetailVo::getRelateCode)));
    }
    cusCodes.forEach(s -> {
          String key = REBATE_POLICY_CRITERION_CODE + s;
          List<DeliveryDetailVo> deliveryDetails = listMap.get(s);
          if (!CollectionUtils.isEmpty(deliveryDetails)) {
            BigDecimal reduce = deliveryDetails.stream()
                .map(DeliveryDetailVo::getDeliveryQuantity)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
            map.put(key, reduce);
          } else {
            map.put(key, BigDecimal.ZERO);
          }
        }
    );
    return map;
  }

  /**
   *
   * 获取季度
   * @param startTime
   * @param endTime
   * @author rentao
   * @date
   */
  private List<String> getQuarterList(Date startTime, Date endTime){
    List<SaleRebateExecutionDateRangeVo> executionQuarterList = SaleRebateCycleUtil
        .getExecutionQuarterList(startTime, endTime);
    return executionQuarterList.stream().map(SaleRebateExecutionDateRangeVo::getSaleRebateQuarter).collect(
        Collectors.toList());
  }

}