package com.biz.crm.dms.business.rebate.local.service.register.cycleregister;

import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyTaskService;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebateCycleUtil;
import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.biz.crm.dms.business.rebate.sdk.enums.CycleTypeEnum;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCycleRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateExecutionDateRangeVo;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.service.FiscalYearVoService;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * @description: 月度返利
 * @author: rentao
 * @date: 2022/2/21 14:13
 */
@Component
@Slf4j
public class MonthCycleRegisterImpl implements SaleRebatePolicyCycleRegister {

  @Autowired(required = false)
  private FiscalYearVoService fiscalYearVoService;

  /**
   * 返利周期名称
   */
  private static final String REBATE_POLICY_CYCLE_NAME = "月度返利";

  /**
   * 返利周期编码
   */
  private static final String REBATE_POLICY_CYCLE_CODE = "MONTHCYCLE";

  /**
   * 排序
   */
  private static final Integer REBATE_POLICY_CYCLE_SORT = 2;

  @Autowired(required = false)
  private SaleRebatePolicyTaskService saleRebatePolicyTaskService;

  @Override
  public String getSaleRebatePolicyCycleCode() {
    return REBATE_POLICY_CYCLE_CODE;
  }

  @Override
  public String getSaleRebatePolicyCycleName() {
    return REBATE_POLICY_CYCLE_NAME;
  }

  @Override
  public Integer getCycleSort() {
    return REBATE_POLICY_CYCLE_SORT;
  }

  /**
   *
   * （创建定时任务）
   * @author rentao
   * @date
   */
  @Override
  @Transactional
  public void onRequestcreate(SaleRebatePolicyDto saleRebatePolicyDto) {
    this.saleRebatePolicyTaskService.createRebatetask(saleRebatePolicyDto);
  }

  /**
   *
   * （修改定时任务）
   * @author rentao
   * @date
   */
  @Override
  @Transactional
  public void onRequestUpdate(SaleRebatePolicyDto saleRebatePolicyDto) {
    this.saleRebatePolicyTaskService.updateRebatetask(saleRebatePolicyDto);
  }

  /**
   *
   * 获取当天定时任务执行范围
   * @author rentao
   * @date
   */
  @Override
  public SaleRebateExecutionDateRangeVo getExecutionDateRangeVo(
      SaleRebatePolicyDto saleRebatePolicyDto) {
    SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo =null;
    SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
    String format = formatDate.format(saleRebatePolicyDto.getCalculateTime());
    if(CycleTypeEnum.CIVIL_YEAR.getKey().equals(saleRebatePolicyDto.getCycleType())){
      Map<String, SaleRebateExecutionDateRangeVo> saleRebateExecutionDateMap = SaleRebateCycleUtil.getSaleRebateExecutionMonthMap(saleRebatePolicyDto);
      saleRebateExecutionDateRangeVo = saleRebateExecutionDateMap
          .get(format);
    }else {
      List<FiscalYearVo> fiscalYearVoListByDate = this.fiscalYearVoService
          .findByBeginTimeAndEndTime(saleRebatePolicyDto.getSaleRebateStartTime(), saleRebatePolicyDto.getSaleRebateEndTime());
      //拿到自然时间范围内的财年数据 如果有数据替换开始时间 结束时间
      if(!CollectionUtils.isEmpty(fiscalYearVoListByDate)){
        for (FiscalYearVo fiscalYearVo : fiscalYearVoListByDate) {
          if(fiscalYearVo.getBeginTime().before(saleRebatePolicyDto.getSaleRebateStartTime())){
            fiscalYearVo.setBeginTime(saleRebatePolicyDto.getSaleRebateStartTime());
          }
          if(fiscalYearVo.getEndTime().after(saleRebatePolicyDto.getSaleRebateEndTime())){
            fiscalYearVo.setEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
          }
          //执行日历
          Calendar calendarexec = Calendar.getInstance();
          calendarexec.setTime(fiscalYearVo.getEndTime());
          calendarexec.set(Calendar.DAY_OF_YEAR,
              calendarexec.get(Calendar.DAY_OF_YEAR) + saleRebatePolicyDto.getCalculateDayNum()+1);
          String execDate = formatDate.format(calendarexec.getTime());
          if(execDate.equals(format)){
            saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            saleRebateExecutionDateRangeVo.setSaleRebateStartTime(fiscalYearVo.getBeginTime());
            saleRebateExecutionDateRangeVo.setSaleRebateEndTime(fiscalYearVo.getEndTime());
          }
        }
      }
    }
    return saleRebateExecutionDateRangeVo;
  }

}
