package com.biz.crm.dms.business.rebate.local.service.register.elementregister;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyFormulaInfo;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyFormulaInfoService;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.element.FormulaSaleRebatePolicyElementDataVo;
import com.biz.crm.dms.business.rebate.sdk.vo.element.FormulaSaleRebatePolicyElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年02月21日 09:50:00
 */
@Slf4j
@Service("formulaSaleRebatePolicyElementRegisterImpl")
public class FormulaSaleRebatePolicyElementRegisterImpl implements
    SaleRebatePolicyElementRegister<FormulaSaleRebatePolicyElementDataVo> {

  @Autowired(required = false)
  private SaleRebatePolicyFormulaInfoService saleRebatePolicyFormulaInfoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 返利政策要素名称
   */
  private static final String REBATE_POLICY_ELEMENT_NAME = "返利政策公式";

  /**
   * 返利政策要素编码
   */
  private static final String REBATE_POLICY_ELEMENT_CODE = "formula";

  /**
   * 排序
   */
  private static final Integer REBATE_POLICY_ELEMENT_SORT = 4;

  @Override
  public String getSaleRebatePolicyElementName() {
    return REBATE_POLICY_ELEMENT_NAME;
  }

  @Override
  public String getSaleRebatePolicyElementCode() {
    return REBATE_POLICY_ELEMENT_CODE;
  }

  @Override
  public Integer getElementSort() {
    return REBATE_POLICY_ELEMENT_SORT;
  }

  @Override
  public Class<FormulaSaleRebatePolicyElementDataVo> getSaleRebatePolicyElementClass() {
    return FormulaSaleRebatePolicyElementDataVo.class;
  }

  @Override
  public FormulaSaleRebatePolicyElementDataVo getBySaleRebatePolicyCode(
      String saleRebatePolicyCode) {
    FormulaSaleRebatePolicyElementDataVo vo = new FormulaSaleRebatePolicyElementDataVo();
    List<SaleRebatePolicyFormulaInfo> list = this.saleRebatePolicyFormulaInfoService
        .findBySaleRebatePolicyCode(saleRebatePolicyCode);
    if (CollectionUtils.isEmpty(list)) {
      return vo;
    }
    this.getDataVoByList(list, vo);
    return vo;
  }

  @Override
  public FormulaSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyCreate(
      String saleRebatePolicyCode,
      FormulaSaleRebatePolicyElementDataVo formulaSaleRebatePolicyElementDataVo) {
    List<SaleRebatePolicyFormulaInfo> list = this
        .getListByDataVo(saleRebatePolicyCode, formulaSaleRebatePolicyElementDataVo);
    this.saleRebatePolicyFormulaInfoService.createBatch(list);
    FormulaSaleRebatePolicyElementDataVo vo = new FormulaSaleRebatePolicyElementDataVo();
    this.getDataVoByList(list, vo);
    vo.setSaleRebatePolicyCode(saleRebatePolicyCode);
    return vo;
  }

  @Override
  public FormulaSaleRebatePolicyElementDataVo onRequestSaleRebatePolicyUpdate(
      String saleRebatePolicyCode,
      FormulaSaleRebatePolicyElementDataVo formulaSaleRebatePolicyElementDataVo) {
    this.saleRebatePolicyFormulaInfoService.deleteBySaleRebatePolicyCode(saleRebatePolicyCode);
    List<SaleRebatePolicyFormulaInfo> list = this
        .getListByDataVo(saleRebatePolicyCode, formulaSaleRebatePolicyElementDataVo);
    this.saleRebatePolicyFormulaInfoService.createBatch(list);
    FormulaSaleRebatePolicyElementDataVo vo = new FormulaSaleRebatePolicyElementDataVo();
    this.getDataVoByList(list, vo);
    vo.setSaleRebatePolicyCode(saleRebatePolicyCode);
    return vo;
  }

  /**
   * 根据要素实体集合获得封装vo
   *
   * @param list
   * @param vo
   */
  private void getDataVoByList(List<SaleRebatePolicyFormulaInfo> list,
      FormulaSaleRebatePolicyElementDataVo vo) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    List<FormulaSaleRebatePolicyElementVo> newList = (List<FormulaSaleRebatePolicyElementVo>) this.nebulaToolkitService
        .copyCollectionByWhiteList(list, SaleRebatePolicyFormulaInfo.class,
            FormulaSaleRebatePolicyElementVo.class,
            LinkedHashSet.class,
            ArrayList.class);
    vo.setFromulaList(newList);
    vo.setSaleRebatePolicyCode(list.get(0).getSaleRebatePolicyCode());
    vo.setTenantCode(TenantUtils.getTenantCode());
  }

  /**
   * 根据封装vo获得实体集合
   *
   * @param formulaSaleRebatePolicyElementDataVo
   * @return
   */
  private List<SaleRebatePolicyFormulaInfo> getListByDataVo(String saleRebatePolicyCode,
      FormulaSaleRebatePolicyElementDataVo formulaSaleRebatePolicyElementDataVo) {
    List<FormulaSaleRebatePolicyElementVo> list = formulaSaleRebatePolicyElementDataVo
        .getFromulaList();
    //copy list
    List<SaleRebatePolicyFormulaInfo> newList = (List<SaleRebatePolicyFormulaInfo>) this.nebulaToolkitService
        .copyCollectionByWhiteList(list,
            FormulaSaleRebatePolicyElementVo.class,
            SaleRebatePolicyFormulaInfo.class,
            LinkedHashSet.class,
            ArrayList.class);
    newList.forEach(e -> {
      e.setSaleRebatePolicyCode(saleRebatePolicyCode);
      e.setTenantCode(TenantUtils.getTenantCode());
    });
    return newList;

  }
}
