/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicy;
import com.biz.crm.dms.business.rebate.local.mapper.SaleRebatePolicyMapper;
import com.biz.crm.dms.business.rebate.sdk.enums.SaleRebatePolicyStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class SaleRebatePolicyRepository
extends ServiceImpl<SaleRebatePolicyMapper, SaleRebatePolicy> {
    public Page<SaleRebatePolicy> findByConditions(Pageable pageable, SaleRebatePolicy saleRebatePolicy) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<SaleRebatePolicy> pageList = ((SaleRebatePolicyMapper)this.baseMapper).findByConditions((Page<SaleRebatePolicy>)page, saleRebatePolicy);
        return pageList;
    }

    public SaleRebatePolicy findBySalePolicyCodeAndTenantCode(String saleRebatePolicyCode, String tenantCode) {
        SaleRebatePolicy salePolicy = (SaleRebatePolicy)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(SaleRebatePolicy::getSaleRebatePolicyCode, (Object)saleRebatePolicyCode)).one());
        return salePolicy;
    }

    public List<SaleRebatePolicy> findBySaleRebatePolicyCodes(List<String> saleRebatePolicyCodes, String tenantCode) {
        List salePolicys = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(SaleRebatePolicy::getSaleRebatePolicyCode, saleRebatePolicyCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
        return salePolicys;
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).update();
    }

    public void updateSaleRebatePolicyStatus(SaleRebatePolicyStatusEnum saleRebatePolicyStatusEnum, String id) {
        if (StringUtils.isEmpty((Object)id)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(SaleRebatePolicy::getSaleRebatePolicyStatus, (Object)saleRebatePolicyStatusEnum.getKey())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidEntity::getId, (Object)id)).update();
    }
}

