/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebateCalculationLog;
import com.biz.crm.dms.business.rebate.local.repository.SaleRebateCalculationLogRepository;
import com.biz.crm.dms.business.rebate.local.service.SaleRebateCalculationLogService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="saleRebateCalculationLogService")
public class SaleRebateCalculationLogServiceImpl
implements SaleRebateCalculationLogService {
    @Autowired(required=false)
    private SaleRebateCalculationLogRepository saleRebateCalculationLogRepository;

    @Override
    public Page<SaleRebateCalculationLog> findByDetailId(Pageable pageable, String saleRebatePolicyDetailId) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (StringUtils.isBlank((CharSequence)saleRebatePolicyDetailId)) {
            return null;
        }
        SaleRebateCalculationLog saleRebateCalculationLog = new SaleRebateCalculationLog();
        saleRebateCalculationLog.setSaleRebatePolicyDetailId(saleRebatePolicyDetailId);
        saleRebateCalculationLog.setTenantCode(TenantUtils.getTenantCode());
        return this.saleRebateCalculationLogRepository.findByConditions(pageable, saleRebateCalculationLog);
    }

    @Override
    @Transactional
    public SaleRebateCalculationLog create(SaleRebateCalculationLog saleRebateCalculationLog) {
        this.createValidate(saleRebateCalculationLog);
        this.saleRebateCalculationLogRepository.saveOrUpdate((Object)saleRebateCalculationLog);
        return saleRebateCalculationLog;
    }

    @Override
    public void deleteByRebateCodeAndTest(String saleRebatePolicyCode, String isTest, String speedNo) {
        Validate.notEmpty((CharSequence)saleRebatePolicyCode, (String)"\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)BooleanEnum.TRUE.getNumStr().equals(isTest), (String)"\u6d4b\u8bd5\u72b6\u6001\u53ea\u80fd\u4f20\u662f\uff081\uff09", (Object[])new Object[0]);
        this.saleRebateCalculationLogRepository.deleteByRebateCodeAndTest(saleRebatePolicyCode, isTest, speedNo);
    }

    private void createValidate(SaleRebateCalculationLog saleRebateCalculationLog) {
        saleRebateCalculationLog.setTenantCode(TenantUtils.getTenantCode());
        saleRebateCalculationLog.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        saleRebateCalculationLog.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)((Object)saleRebateCalculationLog), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        saleRebateCalculationLog.setId(null);
        Validate.notNull((Object)saleRebateCalculationLog.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebateCalculationLog.getSaleRebateCalculationYears(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u8ba1\u7b97\u65f6\u95f4\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebateCalculationLog.getSaleRebatePolicyCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebateCalculationLog.getSaleRebatePolicyCondition(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebateCalculationLog.getSaleRebatePolicyName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebateCalculationLog.getSaleRebateResults(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u6761\u4ef6\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

