/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebateAdjustDetail;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyDetail;
import com.biz.crm.dms.business.rebate.local.repository.SaleRebatePolicyDetailRepository;
import com.biz.crm.dms.business.rebate.local.service.SaleRebateAdjustDetailService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyCalculateService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyDetailService;
import com.biz.crm.dms.business.rebate.sdk.enums.BillTypeEnum;
import com.biz.crm.dms.business.rebate.sdk.enums.SaleOnAccountStatusEnums;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyTemplateRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="saleRebatePolicyDetailService")
public class SaleRebatePolicyDetailServiceImpl
implements SaleRebatePolicyDetailService {
    @Autowired(required=false)
    private SaleRebatePolicyDetailRepository saleRebatePolicyDetailRepository;
    @Autowired(required=false)
    private SaleRebatePolicyCalculateService saleRebatePolicyCalculateService;
    @Autowired(required=false)
    private SaleRebateAdjustDetailService saleRebateAdjustDetailService;
    @Autowired(required=false)
    private List<SaleRebatePolicyTemplateRegister> saleRebatePolicyTemplateRegisters;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    public Page<SaleRebatePolicyDetail> findByConditions(Pageable pageable, SaleRebatePolicyDetail saleRebatePolicyDetail) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)saleRebatePolicyDetail)) {
            saleRebatePolicyDetail = new SaleRebatePolicyDetail();
        }
        saleRebatePolicyDetail.setTenantCode(TenantUtils.getTenantCode());
        saleRebatePolicyDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.saleRebatePolicyDetailRepository.findByConditions(pageable, saleRebatePolicyDetail);
    }

    @Override
    public List<SaleRebatePolicyDetail> findByConditionsList(SaleRebatePolicyDetail saleRebatePolicyDetail) {
        return this.saleRebatePolicyDetailRepository.findByConditionsList(saleRebatePolicyDetail);
    }

    @Override
    public SaleRebatePolicyDetail findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.saleRebatePolicyDetailRepository.findById(id);
    }

    @Override
    public List<SaleRebatePolicyDetail> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return this.saleRebatePolicyDetailRepository.findByIds(ids);
    }

    @Override
    @Transactional
    public SaleRebatePolicyDetail createOrUpdate(SaleRebatePolicyDetail saleRebatePolicyDetail) {
        this.createValidate(saleRebatePolicyDetail);
        this.calculateValidate(saleRebatePolicyDetail);
        if (StringUtils.isBlank((CharSequence)saleRebatePolicyDetail.getSaleRebateDetailCode())) {
            saleRebatePolicyDetail.setSaleRebateDetailCode((String)this.generateCodeService.generateCode("FLMX", 1).get(0));
        }
        this.saleRebatePolicyDetailRepository.saveOrUpdate((Object)saleRebatePolicyDetail);
        if (BillTypeEnum.AUTO_KEEP_BOOKS.getKey().equals(saleRebatePolicyDetail.getBillType())) {
            this.onAccount(Collections.singletonList(saleRebatePolicyDetail));
        }
        return saleRebatePolicyDetail;
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u4f5c\u5e9f\u6570\u636e\u65f6\uff0c\u53c2\u6570\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SaleRebatePolicyDetail> list = this.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e", (Object[])new Object[0]);
        List collect = list.stream().filter(e -> !e.getBillStatus().equals(SaleOnAccountStatusEnums.WAIT_ACCOUNT.getKey())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(collect), (String)"\u4ec5\u80fd\u4f5c\u5e9f\u72b6\u6001\u4e3a\u5f85\u4e0a\u8d26\u7c7b\u578b\u7684\u660e\u7ec6", (Object[])new Object[0]);
        this.saleRebatePolicyDetailRepository.disableBatch(ids);
    }

    @Override
    public List<SaleRebatePolicyDetail> findBySaleRebatePolicyCodes(List<String> saleRebatePolicyCodes) {
        if (CollectionUtils.isEmpty(saleRebatePolicyCodes)) {
            return new ArrayList<SaleRebatePolicyDetail>(0);
        }
        return this.saleRebatePolicyDetailRepository.findBySaleRebatePolicyCodes(saleRebatePolicyCodes);
    }

    @Override
    @Transactional
    public void handleAccount(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<SaleRebatePolicyDetail> list = this.findByIds(ids);
        this.operationValidate(list);
        this.onAccount(list);
        list.forEach(s -> s.setBillStatus(SaleOnAccountStatusEnums.ON_ACCOUNT.getKey()));
        this.saleRebatePolicyDetailRepository.updateBatchById(list);
    }

    @Override
    @Transactional
    public void handleCalculation(List<String> ids) {
        this.saleRebatePolicyCalculateService.onCalculateByDetailIds(ids);
    }

    @Override
    @Transactional
    public SaleRebatePolicyDetail handleAdjust(SaleRebatePolicyDetail saleRebatePolicyDetail) {
        Validate.notNull((Object)((Object)saleRebatePolicyDetail), (String)"\u8fd4\u5229\u660e\u7ec6\u8c03\u6574\u65f6\u4f20\u5165\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebatePolicyDetail.getId(), (String)"\u8fd4\u5229\u660e\u7ec6\u8c03\u6574\u65f6\u4f20\u5165\u4e3b\u952e\u4e3a\u7a7a", (Object[])new Object[0]);
        SaleRebatePolicyDetail entityOld = this.findById(saleRebatePolicyDetail.getId());
        Validate.isTrue((boolean)SaleOnAccountStatusEnums.WAIT_ACCOUNT.getKey().equals(entityOld.getBillStatus()), (String)"\u53ea\u80fd\u8c03\u6574\u5f85\u4e0a\u8d26\u6570\u636e\uff01", (Object[])new Object[0]);
        BigDecimal adjustAmount = saleRebatePolicyDetail.getAdjustAmount();
        Validate.notNull((Object)adjustAmount, (String)"\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal actualRebateAmountOld = entityOld.getActualRebateAmount();
        BigDecimal actualRebateAmountNew = actualRebateAmountOld.add(adjustAmount);
        BigDecimal adjustAmountOld = entityOld.getAdjustAmount();
        BigDecimal adjustAmountNew = adjustAmountOld.add(adjustAmount);
        entityOld.setActualRebateAmount(actualRebateAmountNew);
        entityOld.setAdjustAmount(adjustAmountNew);
        entityOld.setRemark(saleRebatePolicyDetail.getRemark());
        this.saleRebatePolicyDetailRepository.updateById((Object)entityOld);
        SaleRebateAdjustDetail saleRebateAdjustDetail = new SaleRebateAdjustDetail();
        saleRebateAdjustDetail.setAdjustAmount(saleRebatePolicyDetail.getAdjustAmount());
        saleRebateAdjustDetail.setCustomerCode(entityOld.getCustomerCode());
        saleRebateAdjustDetail.setCustomerName(entityOld.getCustomerName());
        saleRebateAdjustDetail.setSaleRebatePolicyName(entityOld.getSaleRebatePolicyName());
        saleRebateAdjustDetail.setSaleRebateDetailCode(entityOld.getSaleRebateDetailCode());
        this.saleRebateAdjustDetailService.create(saleRebateAdjustDetail);
        return entityOld;
    }

    @Override
    @Transactional
    public void deleteByRebateCodeAndTest(String saleRebatePolicyCode, String isTest, String speedNo) {
        Validate.notEmpty((CharSequence)saleRebatePolicyCode, (String)"\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)BooleanEnum.TRUE.getNumStr().equals(isTest), (String)"\u6d4b\u8bd5\u72b6\u6001\u53ea\u80fd\u4f20\u662f\uff081\uff09", (Object[])new Object[0]);
        this.saleRebatePolicyDetailRepository.deleteByRebateCodeAndTest(saleRebatePolicyCode, isTest, speedNo);
    }

    private void createValidate(SaleRebatePolicyDetail saleRebatePolicyDetail) {
        saleRebatePolicyDetail.setTenantCode(TenantUtils.getTenantCode());
        saleRebatePolicyDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        saleRebatePolicyDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)((Object)saleRebatePolicyDetail), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebatePolicyDetail.getCalculationTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u8ba1\u7b97\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)saleRebatePolicyDetail.getSaleRebateCalculationYears(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u8ba1\u7b97\u65f6\u95f4\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebatePolicyDetail.getSaleRebateEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u7ed3\u675f\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)saleRebatePolicyDetail.getSaleRebatePolicyCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4fc3\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)saleRebatePolicyDetail.getSaleRebatePolicyName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)saleRebatePolicyDetail.getSaleRebateStartTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u5f00\u59cb\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((saleRebatePolicyDetail.getSaleRebateStartTime().compareTo(saleRebatePolicyDetail.getSaleRebateEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u989d\u5f00\u59cb\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)saleRebatePolicyDetail.getRemark())) {
            Validate.isTrue((saleRebatePolicyDetail.getRemark().length() <= 100 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57", (Object[])new Object[0]);
        }
        List<SaleRebatePolicyDetail> byConditionsList = this.findByConditionsList(saleRebatePolicyDetail);
        if (StringUtils.isBlank((CharSequence)saleRebatePolicyDetail.getId()) && BooleanEnum.FALSE.getNumStr().equals(saleRebatePolicyDetail.getIsTest())) {
            List collect = byConditionsList.stream().filter(detail -> BooleanEnum.FALSE.getNumStr().equals(detail.getIsTest())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(collect), (String)"\u5df2\u5b58\u5728\u5468\u671f\u5185\u8fd4\u5229\u660e\u7ec6", (Object[])new Object[0]);
        }
    }

    private void operationValidate(List<SaleRebatePolicyDetail> list) {
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e", (Object[])new Object[0]);
        List collect = list.stream().filter(e -> !e.getBillStatus().equals(SaleOnAccountStatusEnums.WAIT_ACCOUNT.getKey())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(collect), (String)"\u4ec5\u80fd\u4e0a\u8d26\u72b6\u6001\u4e3a\u5f85\u4e0a\u8d26\u7c7b\u578b\u7684\u660e\u7ec6", (Object[])new Object[0]);
    }

    private void onAccount(List<SaleRebatePolicyDetail> details) {
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(details, SaleRebatePolicyDetail.class, SaleRebatePolicyDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<SaleRebatePolicyDetailVo>> map = voList.stream().collect(Collectors.groupingBy(SaleRebatePolicyDetailVo::getSaleRebateType));
        map.forEach((k, v) -> this.saleRebatePolicyTemplateRegisters.forEach(saleRebatePolicyTemplateRegister -> {
            if (saleRebatePolicyTemplateRegister.getSaleRebatePolicytemplateCode().equals(k)) {
                saleRebatePolicyTemplateRegister.onAccount(v);
            }
        }));
    }

    private void calculateValidate(SaleRebatePolicyDetail saleRebatePolicyDetail) {
        if (saleRebatePolicyDetail.getAdjustAmount() == null) {
            saleRebatePolicyDetail.setActualRebateAmount(saleRebatePolicyDetail.getRebateAmount());
            return;
        }
        BigDecimal adjustAmount = saleRebatePolicyDetail.getAdjustAmount();
        BigDecimal rebateAmount = saleRebatePolicyDetail.getRebateAmount();
        BigDecimal actualRebateAmount = rebateAmount.add(adjustAmount);
        saleRebatePolicyDetail.setActualRebateAmount(actualRebateAmount);
    }
}

