/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyScopeInfo;
import com.biz.crm.dms.business.rebate.local.repository.SaleRebatePolicyScopeInfoRepository;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyScopeInfoService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyService;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyTemplateRegister;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="saleRebatePolicyScopeInfoService")
public class SaleRebatePolicyScopeInfoServiceImpl
implements SaleRebatePolicyScopeInfoService {
    @Autowired(required=false)
    private SaleRebatePolicyScopeInfoRepository saleRebatePolicyScopeInfoRepository;
    @Autowired(required=false)
    private List<SaleRebatePolicyTemplateRegister> saleRebatePolicyTemplateRegisters;
    @Autowired(required=false)
    private SaleRebatePolicyService saleRebatePolicyService;
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u4f20\u5165id\u96c6\u5408\u4e3a\u7a7a", (Object[])new Object[0]);
        this.saleRebatePolicyScopeInfoRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void deleteBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        Validate.notBlank((CharSequence)saleRebatePolicyCode, (String)"\u4f20\u5165\u8fd4\u5229\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.saleRebatePolicyScopeInfoRepository.deleteBySaleRebatePolicyCode(saleRebatePolicyCode);
    }

    private void createValidate(SaleRebatePolicyScopeInfo saleRebatePolicyScopeInfo) {
        Validate.notNull((Object)((Object)saleRebatePolicyScopeInfo), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        saleRebatePolicyScopeInfo.setId(null);
        saleRebatePolicyScopeInfo.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u88ab\u9009\u5b9a\u6216\u8005\u88ab\u6392\u9664\u7684\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getCustomerScopeType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd9\u4e2a\u5c5e\u6027\u5c06\u8fd4\u56de\u8fd9\u4e2a\u5177\u4f53\u5ba2\u6237\u8303\u56f4\u63a7\u5236\u7b56\u7565\u7684\u8bc6\u522b\u7c7b\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u88ab\u9009\u5b9a\u6216\u8005\u88ab\u6392\u9664\u7684\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getSaleRebatePolicyCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void createBatch(Set<SaleRebatePolicyScopeInfo> saleRebatePolicyScopeInfos) {
        Validate.isTrue((!CollectionUtils.isEmpty(saleRebatePolicyScopeInfos) ? 1 : 0) != 0, (String)"\u521b\u5efa\u8fd4\u5229\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u4f20\u5165\u4e00\u6761\u9002\u7528\u8303\u56f4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        long codeCount = saleRebatePolicyScopeInfos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCode())).map(SaleRebatePolicyScopeInfo::getCode).distinct().count();
        Validate.isTrue((codeCount == (long)saleRebatePolicyScopeInfos.size() ? 1 : 0) != 0, (String)"\u521b\u5efa\u8fd4\u5229\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u81f3\u5c11\u6709\u4e24\u7ec4\u8303\u56f4\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7\u91cd\u590d\u6216\u8005\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (SaleRebatePolicyScopeInfo salePolicyScopeInfo : saleRebatePolicyScopeInfos) {
            this.createHandle(salePolicyScopeInfo);
        }
    }

    @Override
    public List<SaleRebatePolicyScopeInfo> findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(String tenantCode, String salePolicyCode, String customerScopeType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode, customerScopeType})) {
            return null;
        }
        return this.saleRebatePolicyScopeInfoRepository.findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(tenantCode, salePolicyCode, customerScopeType);
    }

    @Override
    public List<SaleRebatePolicyScopeInfo> findBySaleRebatePolicyCode(String saleRebatePolicyCode) {
        if (StringUtils.isBlank((CharSequence)saleRebatePolicyCode)) {
            return new ArrayList<SaleRebatePolicyScopeInfo>(0);
        }
        return this.saleRebatePolicyScopeInfoRepository.findBySaleRebatePolicyCode(saleRebatePolicyCode);
    }

    @Override
    @Transactional
    public void updateBatch(Set<SaleRebatePolicyScopeInfo> saleRebatePolicyScopeInfos) {
        Validate.isTrue((!CollectionUtils.isEmpty(saleRebatePolicyScopeInfos) ? 1 : 0) != 0, (String)"\u8fd4\u5229\u8303\u56f4\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        for (SaleRebatePolicyScopeInfo saleRebatePolicyScopeInfo : saleRebatePolicyScopeInfos) {
            this.updateValidate(saleRebatePolicyScopeInfo);
        }
        List<String> idList = saleRebatePolicyScopeInfos.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.delete(idList);
        this.saleRebatePolicyScopeInfoRepository.saveBatch(saleRebatePolicyScopeInfos);
    }

    private void updateValidate(SaleRebatePolicyScopeInfo saleRebatePolicyScopeInfo) {
        Validate.notNull((Object)((Object)saleRebatePolicyScopeInfo), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getTenantCode(), (String)"\u4fee\u6539\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getCode(), (String)"\u4fee\u6539\u65f6\uff0c\u88ab\u9009\u5b9a\u6216\u8005\u88ab\u6392\u9664\u7684\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getCustomerScopeType(), (String)"\u4fee\u6539\u65f6\uff0c\u8fd9\u4e2a\u5c5e\u6027\u5c06\u8fd4\u56de\u8fd9\u4e2a\u5177\u4f53\u5ba2\u6237\u8303\u56f4\u63a7\u5236\u7b56\u7565\u7684\u8bc6\u522b\u7c7b\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getName(), (String)"\u4fee\u6539\u65f6\uff0c\u88ab\u9009\u5b9a\u6216\u8005\u88ab\u6392\u9664\u7684\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)saleRebatePolicyScopeInfo.getSaleRebatePolicyCode(), (String)"\u4fee\u6539\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createHandle(SaleRebatePolicyScopeInfo saleRebatePolicyScopeInfo) {
        String tenantCode = TenantUtils.getTenantCode();
        saleRebatePolicyScopeInfo.setTenantCode(tenantCode);
        saleRebatePolicyScopeInfo.setId(null);
        String code = saleRebatePolicyScopeInfo.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u521b\u5efa\u8fd4\u5229\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String name = saleRebatePolicyScopeInfo.getName();
        Validate.notBlank((CharSequence)name, (String)"\u521b\u5efa\u8fd4\u5229\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u540d\u79f0\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String customerScopeType = saleRebatePolicyScopeInfo.getCustomerScopeType();
        Validate.notBlank((CharSequence)customerScopeType, (String)"\u521b\u5efa\u8fd4\u5229\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u8303\u56f4\u7c7b\u578b\uff08customerScopeType\uff09\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        this.saleRebatePolicyScopeInfoRepository.save((Object)saleRebatePolicyScopeInfo);
    }
}

