/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyCalculateService;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyTaskService;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebateCycleUtil;
import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleRebatePolicyTaskServiceImpl
implements SaleRebatePolicyTaskService {
    private static final Logger log = LoggerFactory.getLogger(SaleRebatePolicyTaskServiceImpl.class);
    @Autowired(required=false)
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired(required=false)
    private SaleRebatePolicyCalculateService saleRebatePolicycalculateService;

    @Override
    @Transactional
    public void handleRebateTask(String saleRebatePolicyCode) {
        this.saleRebatePolicycalculateService.onCalculateByCode(Collections.singletonList(saleRebatePolicyCode), BooleanEnum.FALSE.getNumStr(), new Date());
    }

    @Override
    @Transactional
    public void createRebatetask(SaleRebatePolicyDto saleRebatePolicyDto) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
        calendar.set(6, calendar.get(6) + saleRebatePolicyDto.getCalculateDayNum());
        Date validityTime = SaleRebateCycleUtil.getLastday(calendar.getTime());
        this.dynamicTaskSchedulerVoService.createIgnorePrefix(saleRebatePolicyDto.getSaleRebatePolicyCode(), "saleRebatePolicyTaskServiceImpl", "handleRebateTask", Integer.valueOf(2), SaleRebateCycleUtil.createCronExpression(), null, validityTime, saleRebatePolicyDto.getSaleRebatePolicyName() + "\u5b9a\u65f6\u4efb\u52a1", new Object[]{saleRebatePolicyDto.getSaleRebatePolicyCode(), TenantUtils.getAppCode(), TenantUtils.getTenantCode()});
    }

    @Override
    @Transactional
    public void createRebateSingletask(SaleRebatePolicyDto saleRebatePolicyDto) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
        calendar.set(6, calendar.get(6) + saleRebatePolicyDto.getCalculateDayNum());
        Date firstday = SaleRebateCycleUtil.getFirstday(calendar.getTime());
        this.dynamicTaskSchedulerVoService.createIgnorePrefix(saleRebatePolicyDto.getSaleRebatePolicyCode(), "saleRebatePolicyTaskServiceImpl", "handleRebateTask", Integer.valueOf(1), null, firstday, SaleRebateCycleUtil.getLastday(firstday), saleRebatePolicyDto.getSaleRebatePolicyName() + "\u4e00\u6b21\u6027\u5b9a\u65f6\u4efb\u52a1", new Object[]{saleRebatePolicyDto.getSaleRebatePolicyCode(), TenantUtils.getAppCode(), TenantUtils.getTenantCode()});
    }

    @Override
    @Transactional
    public void updateRebatetask(SaleRebatePolicyDto saleRebatePolicyDto) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
        calendar.set(6, calendar.get(6) + saleRebatePolicyDto.getCalculateDayNum());
        Date validityTime = SaleRebateCycleUtil.getLastday(calendar.getTime());
        this.dynamicTaskSchedulerVoService.updateIgnorePrefix(saleRebatePolicyDto.getSaleRebatePolicyCode(), SaleRebateCycleUtil.createCronExpression(), validityTime, saleRebatePolicyDto.getSaleRebatePolicyName() + "\u5b9a\u65f6\u4efb\u52a1", new Object[]{saleRebatePolicyDto.getSaleRebatePolicyCode(), TenantUtils.getAppCode(), TenantUtils.getTenantCode()});
    }

    @Override
    @Transactional
    public void invalidBatchBySaleRebatePolicyCodes(List<String> taskCodes) {
        this.dynamicTaskSchedulerVoService.invalid((String[])taskCodes.stream().toArray(String[]::new));
    }

    @Override
    @Transactional
    public void effectiveBatchBySaleRebatePolicyCodes(List<String> taskCodes) {
        this.dynamicTaskSchedulerVoService.effective((String[])taskCodes.stream().toArray(String[]::new));
    }

    @Override
    @Transactional
    public void deleteBatchBySaleRebatePolicyCodes(List<String> taskCodes) {
        this.dynamicTaskSchedulerVoService.invalid((String[])taskCodes.stream().toArray(String[]::new));
        this.dynamicTaskSchedulerVoService.deleteByTaskcodes((String[])taskCodes.stream().toArray(String[]::new));
    }
}

