/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.internal;

import com.biz.crm.dms.business.rebate.local.service.SaleRebateRegisterService;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCycleRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyTemplateRegister;
import com.biz.crm.dms.business.rebate.sdk.strategy.SaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.vo.ConfigurableRebateRegisterVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyRegisterVo;
import com.biz.crm.dms.business.rebate.sdk.vo.scope.AbstractSaleRebatePolicyCustomerInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleRebateRegisterServiceImpl
implements SaleRebateRegisterService {
    private static final Logger log = LoggerFactory.getLogger(SaleRebateRegisterServiceImpl.class);
    @Autowired(required=false)
    private List<SaleRebatePolicyCycleRegister> saleRebatePolicyCycleRegisters;
    @Autowired(required=false)
    private List<SaleRebatePolicyTemplateRegister> saleRebatePolicyTemplateRegisters;
    @Autowired(required=false)
    private List<SaleRebatePolicyCriterionRegister> saleRebatePolicyCriterionRegisters;
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    @Override
    public List<SaleRebatePolicyRegisterVo> findForRebateCycle() {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(this.saleRebatePolicyCycleRegisters), (String)"\u65e0\u53ef\u7528\u7684\u8fd4\u5229\u5468\u671f\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        ArrayList<SaleRebatePolicyRegisterVo> list = new ArrayList<SaleRebatePolicyRegisterVo>();
        this.saleRebatePolicyCycleRegisters.forEach(saleRebatePolicyCycleRegister -> {
            SaleRebatePolicyRegisterVo saleRebatePolicyRegisterVo = new SaleRebatePolicyRegisterVo();
            saleRebatePolicyRegisterVo.setIndexCode(saleRebatePolicyCycleRegister.getCycleSort());
            saleRebatePolicyRegisterVo.setCode(saleRebatePolicyCycleRegister.getSaleRebatePolicyCycleCode());
            saleRebatePolicyRegisterVo.setName(saleRebatePolicyCycleRegister.getSaleRebatePolicyCycleName());
            list.add(saleRebatePolicyRegisterVo);
        });
        this.sortList(list);
        return list;
    }

    @Override
    public List<SaleRebatePolicyRegisterVo> findForRebateType() {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(this.saleRebatePolicyTemplateRegisters), (String)"\u65e0\u53ef\u7528\u7684\u8fd4\u5229\u7c7b\u578b\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        ArrayList<SaleRebatePolicyRegisterVo> list = new ArrayList<SaleRebatePolicyRegisterVo>();
        this.saleRebatePolicyTemplateRegisters.forEach(saleRebatePolicyTemplateRegister -> {
            SaleRebatePolicyRegisterVo saleRebatePolicyRegisterVo = new SaleRebatePolicyRegisterVo();
            saleRebatePolicyRegisterVo.setIndexCode(saleRebatePolicyTemplateRegister.getTemplateSort());
            saleRebatePolicyRegisterVo.setCode(saleRebatePolicyTemplateRegister.getSaleRebatePolicytemplateCode());
            saleRebatePolicyRegisterVo.setName(saleRebatePolicyTemplateRegister.getSaleRebatePolicytemplateName());
            list.add(saleRebatePolicyRegisterVo);
        });
        this.sortList(list);
        return list;
    }

    @Override
    public List<SaleRebatePolicyRegisterVo> findForRebateCriterion() {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(this.saleRebatePolicyCriterionRegisters), (String)"\u65e0\u53ef\u7528\u7684\u8fd4\u5229\u57fa\u51c6\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        ArrayList<SaleRebatePolicyRegisterVo> list = new ArrayList<SaleRebatePolicyRegisterVo>();
        for (SaleRebatePolicyCriterionRegister register : this.saleRebatePolicyCriterionRegisters) {
            ConfigurableRebateRegisterVo vo = new ConfigurableRebateRegisterVo();
            vo.setIndexCode(register.getCriterionSort());
            vo.setCode(register.getSaleRebatePolicyCriterionCode());
            vo.setName(register.getSaleRebatePolicyCriterionName());
            vo.setConfigurable(register.isConfigurable().booleanValue());
            list.add((SaleRebatePolicyRegisterVo)vo);
        }
        this.sortList(list);
        return list;
    }

    @Override
    public List<SaleRebatePolicyRegisterVo> findForRebateElement(String saleRebateType) {
        Collection<Class<? extends SaleRebatePolicyElementRegister>> classes = this.findTemplateCollection(saleRebateType);
        ArrayList<SaleRebatePolicyRegisterVo> list = new ArrayList<SaleRebatePolicyRegisterVo>();
        for (Class<? extends SaleRebatePolicyElementRegister> aClass : classes) {
            SaleRebatePolicyElementRegister saleRebatePolicyElementRegister = (SaleRebatePolicyElementRegister)this.applicationContext.getBean(aClass);
            SaleRebatePolicyRegisterVo saleRebatePolicyRegisterVo = new SaleRebatePolicyRegisterVo();
            saleRebatePolicyRegisterVo.setCode(saleRebatePolicyElementRegister.getSaleRebatePolicyElementCode());
            saleRebatePolicyRegisterVo.setName(saleRebatePolicyElementRegister.getSaleRebatePolicyElementName());
            saleRebatePolicyRegisterVo.setIndexCode(saleRebatePolicyElementRegister.getElementSort());
            list.add(saleRebatePolicyRegisterVo);
        }
        this.sortList(list);
        return list;
    }

    @Override
    public List<SaleRebatePolicyRegisterVo> findForRebateScope(String saleRebateType) {
        Collection<Class<? extends SaleRebateCustomerScopeStrategy<? extends AbstractSaleRebatePolicyCustomerInfo>>> classes = this.findScopeCollection(saleRebateType);
        ArrayList<SaleRebatePolicyRegisterVo> list = new ArrayList<SaleRebatePolicyRegisterVo>();
        for (Class<? extends SaleRebateCustomerScopeStrategy<? extends AbstractSaleRebatePolicyCustomerInfo>> aClass : classes) {
            SaleRebateCustomerScopeStrategy saleRebatePolicyElementRegister = (SaleRebateCustomerScopeStrategy)this.applicationContext.getBean(aClass);
            SaleRebatePolicyRegisterVo saleRebatePolicyRegisterVo = new SaleRebatePolicyRegisterVo();
            saleRebatePolicyRegisterVo.setCode(saleRebatePolicyElementRegister.getScopeType());
            saleRebatePolicyRegisterVo.setName(saleRebatePolicyElementRegister.getScopeTypeDesc());
            saleRebatePolicyRegisterVo.setIndexCode(saleRebatePolicyElementRegister.getSort());
            list.add(saleRebatePolicyRegisterVo);
        }
        this.sortList(list);
        return list;
    }

    @Override
    public Collection<Class<? extends SaleRebatePolicyElementRegister>> findTemplateCollection(String saleRebateType) {
        Validate.notBlank((CharSequence)saleRebateType, (String)"\u8fd4\u5229\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.saleRebatePolicyTemplateRegisters) ? 1 : 0) != 0, (String)"\u65e0\u53ef\u7528\u7684\u8fd4\u5229\u8981\u7d20\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        List collect = this.saleRebatePolicyTemplateRegisters.stream().filter(saleRebatePolicyTemplateRegister -> saleRebatePolicyTemplateRegister.getSaleRebatePolicytemplateCode().equals(saleRebateType)).collect(Collectors.toList());
        SaleRebatePolicyTemplateRegister saleRebatePolicyTemplateRegister2 = (SaleRebatePolicyTemplateRegister)collect.get(0);
        Collection saleRebateElementClasses = saleRebatePolicyTemplateRegister2.getSaleRebateElementClasses();
        return saleRebateElementClasses;
    }

    private Collection<Class<? extends SaleRebateCustomerScopeStrategy<? extends AbstractSaleRebatePolicyCustomerInfo>>> findScopeCollection(String saleRebateType) {
        Validate.notBlank((CharSequence)saleRebateType, (String)"\u8fd4\u5229\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.saleRebatePolicyTemplateRegisters) ? 1 : 0) != 0, (String)"\u65e0\u53ef\u7528\u7684\u8fd4\u5229\u8981\u7d20\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        List collect = this.saleRebatePolicyTemplateRegisters.stream().filter(saleRebatePolicyTemplateRegister -> saleRebatePolicyTemplateRegister.getSaleRebatePolicytemplateCode().equals(saleRebateType)).collect(Collectors.toList());
        SaleRebatePolicyTemplateRegister saleRebatePolicyTemplateRegister2 = (SaleRebatePolicyTemplateRegister)collect.get(0);
        Collection saleRebateElementClasses = saleRebatePolicyTemplateRegister2.getCustomerScopeStrategyClasses();
        return saleRebateElementClasses;
    }

    private void sortList(List<SaleRebatePolicyRegisterVo> list) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            Collections.sort(list, new Comparator<SaleRebatePolicyRegisterVo>(){

                @Override
                public int compare(SaleRebatePolicyRegisterVo o1, SaleRebatePolicyRegisterVo o2) {
                    return o1.getIndexCode().compareTo(o2.getIndexCode());
                }
            });
        }
    }
}

