/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.cycleregister;

import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyTaskService;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebateCycleUtil;
import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.biz.crm.dms.business.rebate.sdk.enums.CycleTypeEnum;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCycleRegister;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateExecutionDateRangeVo;
import com.biz.crm.mdm.business.fiscal.year.sdk.service.FiscalYearVoService;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class YearCycleRegisterImpl
implements SaleRebatePolicyCycleRegister {
    private static final Logger log = LoggerFactory.getLogger(YearCycleRegisterImpl.class);
    @Autowired(required=false)
    private FiscalYearVoService fiscalYearVoService;
    private static final String REBATE_POLICY_CYCLE_NAME = "\u5e74\u5ea6\u8fd4\u5229";
    private static final String REBATE_POLICY_CYCLE_CODE = "YEARCYCLE";
    private static final Integer REBATE_POLICY_CYCLE_SORT = 1;
    @Autowired(required=false)
    private SaleRebatePolicyTaskService saleRebatePolicyTaskService;

    public String getSaleRebatePolicyCycleCode() {
        return REBATE_POLICY_CYCLE_CODE;
    }

    public String getSaleRebatePolicyCycleName() {
        return REBATE_POLICY_CYCLE_NAME;
    }

    public Integer getCycleSort() {
        return REBATE_POLICY_CYCLE_SORT;
    }

    public void onRequestcreate(SaleRebatePolicyDto saleRebatePolicyDto) {
        this.saleRebatePolicyTaskService.createRebatetask(saleRebatePolicyDto);
    }

    public void onRequestUpdate(SaleRebatePolicyDto saleRebatePolicyDto) {
        this.saleRebatePolicyTaskService.updateRebatetask(saleRebatePolicyDto);
    }

    public SaleRebateExecutionDateRangeVo getExecutionDateRangeVo(SaleRebatePolicyDto saleRebatePolicyDto) {
        SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = null;
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        String format = formatDate.format(saleRebatePolicyDto.getCalculateTime());
        if (CycleTypeEnum.CIVIL_YEAR.getKey().equals(saleRebatePolicyDto.getCycleType())) {
            Map<String, SaleRebateExecutionDateRangeVo> saleRebateExecutionDateMap = SaleRebateCycleUtil.getSaleRebateExecutionYearMap(saleRebatePolicyDto);
            saleRebateExecutionDateRangeVo = saleRebateExecutionDateMap.get(format);
        } else {
            List fiscalYearVoListByDate = this.fiscalYearVoService.findByBeginTimeAndEndTime(saleRebatePolicyDto.getSaleRebateStartTime(), saleRebatePolicyDto.getSaleRebateEndTime());
            if (!CollectionUtils.isEmpty((Collection)fiscalYearVoListByDate)) {
                for (FiscalYearVo fiscalYearVo : fiscalYearVoListByDate) {
                    if (fiscalYearVo.getBeginTime().before(saleRebatePolicyDto.getSaleRebateStartTime())) {
                        fiscalYearVo.setBeginTime(saleRebatePolicyDto.getSaleRebateStartTime());
                    }
                    if (!fiscalYearVo.getEndTime().after(saleRebatePolicyDto.getSaleRebateEndTime())) continue;
                    fiscalYearVo.setEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
                }
                Map<String, List<FiscalYearVo>> listMap = fiscalYearVoListByDate.stream().collect(Collectors.groupingBy(FiscalYearVo::getYear));
                for (String s : listMap.keySet()) {
                    List<FiscalYearVo> fiscalYearVos = listMap.get(s);
                    Date endTime = fiscalYearVos.stream().max(Comparator.comparing(FiscalYearVo::getEndTime)).get().getEndTime();
                    Date begin = fiscalYearVos.stream().min(Comparator.comparing(FiscalYearVo::getBeginTime)).get().getBeginTime();
                    Calendar calendarexec = Calendar.getInstance();
                    calendarexec.setTime(endTime);
                    calendarexec.set(6, calendarexec.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
                    String execDate = formatDate.format(calendarexec.getTime());
                    if (!execDate.equals(format)) continue;
                    saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
                    saleRebateExecutionDateRangeVo.setSaleRebateStartTime(begin);
                    saleRebateExecutionDateRangeVo.setSaleRebateEndTime(endTime);
                }
            }
        }
        return saleRebateExecutionDateRangeVo;
    }
}

