/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.service.register.templateregister;

import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolPayTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolUseTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.OperationTypeStrategy;
import com.biz.crm.dms.business.rebate.local.service.register.elementregister.CheckProductSaleRebatePolicyElementRegisterImpl;
import com.biz.crm.dms.business.rebate.local.service.register.elementregister.FormulaSaleRebatePolicyElementRegisterImpl;
import com.biz.crm.dms.business.rebate.local.service.register.elementregister.ScopeSaleRebatePolicyElementRegisterImpl;
import com.biz.crm.dms.business.rebate.local.strategy.ChannelForSaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.local.strategy.DistributorForSaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.local.strategy.OrgForSaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.local.utils.SaleRebatePolicyCalculateUtil;
import com.biz.crm.dms.business.rebate.sdk.enums.AllocationTypeEnum;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyCriterionRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyElementRegister;
import com.biz.crm.dms.business.rebate.sdk.register.SaleRebatePolicyTemplateRegister;
import com.biz.crm.dms.business.rebate.sdk.strategy.SaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateComputeBuildParamVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateComputeParamVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyDetailVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyFormulaInfoVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyVo;
import com.biz.crm.dms.business.rebate.sdk.vo.scope.AbstractSaleRebatePolicyCustomerInfo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DiscountRebateTemplateRegister
implements SaleRebatePolicyTemplateRegister {
    private static final Logger log = LoggerFactory.getLogger(DiscountRebateTemplateRegister.class);
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<SaleRebatePolicyCriterionRegister> saleRebatePolicyCriterionRegisters;
    @Autowired(required=false)
    @Qualifier(value="accountOperationTypeStrategyImpl")
    private OperationTypeStrategy operationTypeStrategy;
    private static final String REBATE_POLICY_TEMPLATE_NAME = "\u6298 \u6263";
    private static final String REBATE_POLICY_TEMPLATE_CODE = "discountRebateTemplate";
    private static final Integer REBATE_POLICY_TEMPLATE_SORT = 2;

    public String getSaleRebatePolicytemplateCode() {
        return REBATE_POLICY_TEMPLATE_CODE;
    }

    public String getSaleRebatePolicytemplateName() {
        return REBATE_POLICY_TEMPLATE_NAME;
    }

    public Integer getTemplateSort() {
        return REBATE_POLICY_TEMPLATE_SORT;
    }

    public Collection<Class<? extends SaleRebateCustomerScopeStrategy<? extends AbstractSaleRebatePolicyCustomerInfo>>> getCustomerScopeStrategyClasses() {
        return Sets.newHashSet((Object[])new Class[]{DistributorForSaleRebateCustomerScopeStrategy.class, ChannelForSaleRebateCustomerScopeStrategy.class, OrgForSaleRebateCustomerScopeStrategy.class});
    }

    public Collection<Class<? extends SaleRebatePolicyElementRegister>> getSaleRebateElementClasses() {
        return Sets.newHashSet((Object[])new Class[]{CheckProductSaleRebatePolicyElementRegisterImpl.class, FormulaSaleRebatePolicyElementRegisterImpl.class, ScopeSaleRebatePolicyElementRegisterImpl.class});
    }

    public List<SaleRebateComputeParamVo> onbuildParam(List<SaleRebateComputeBuildParamVo> saleRebateComputeBuildParamVos) {
        if (CollectionUtils.isNotEmpty(saleRebateComputeBuildParamVos)) {
            return this.buildParam(saleRebateComputeBuildParamVos);
        }
        return null;
    }

    public void onAccount(List<SaleRebatePolicyDetailVo> saleRebatePolicyDetailVos) {
        if (CollectionUtils.isNotEmpty(saleRebatePolicyDetailVos)) {
            saleRebatePolicyDetailVos.forEach(saleRebatePolicyDetailVo -> {
                CostPoolDiscountDto costPoolDiscountDto = new CostPoolDiscountDto();
                costPoolDiscountDto.setUseType(PoolUseTypeEnum.DEFAULT.getDictCode());
                costPoolDiscountDto.setPoolType(PoolTypeEnum.DISCOUNT.getDictCode());
                costPoolDiscountDto.setPoolGroup(PoolGroupEnum.DEFAULT.getDictCode());
                costPoolDiscountDto.setCustomerCode(saleRebatePolicyDetailVo.getCustomerCode());
                costPoolDiscountDto.setCustomerName(saleRebatePolicyDetailVo.getCustomerName());
                costPoolDiscountDto.setAmount(saleRebatePolicyDetailVo.getActualRebateAmount());
                costPoolDiscountDto.setOperationType(PoolOperationTypeEnum.REBATE_ACCOUNT.getDictCode());
                costPoolDiscountDto.setPayType(PoolPayTypeEnum.DISCOUNT.getDictCode());
                costPoolDiscountDto.setFromCode(saleRebatePolicyDetailVo.getSaleRebateDetailCode());
                costPoolDiscountDto.setFromDesc(PoolOperationTypeEnum.REBATE_ACCOUNT.getValue());
                this.operationTypeStrategy.onSaveDiscountInfos(costPoolDiscountDto);
            });
        }
    }

    private List<SaleRebateComputeParamVo> buildParam(List<SaleRebateComputeBuildParamVo> saleRebateComputeParamVos) {
        ArrayList params = Lists.newArrayList();
        saleRebateComputeParamVos.forEach(saleRebateComputeBuildParamVo -> {
            Set cusCodes = saleRebateComputeBuildParamVo.getCustomerCodes();
            Set productCodes = saleRebateComputeBuildParamVo.getProductCodes();
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)cusCodes), (String)"\u8fd4\u5229\u653f\u7b56\u5ba2\u6237\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List customerVos = this.customerVoService.findForPriceByCustomerCodes(cusCodes);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)customerVos), (String)"\u5ba2\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            List formulaInfos = saleRebateComputeBuildParamVo.getSaleRebatePolicyFormulaInfoVos();
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)formulaInfos), (String)"\u8fd4\u5229\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)saleRebateComputeBuildParamVo.getSaleRebateStartTime(), (String)"\u8fd4\u5229\u672c\u6b21\u6267\u884c\u8303\u56f4\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)saleRebateComputeBuildParamVo.getSaleRebateEndTime(), (String)"\u8fd4\u5229\u672c\u6b21\u6267\u884c\u8303\u56f4\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            SaleRebatePolicyVo saleRebatePolicyVo = saleRebateComputeBuildParamVo.getSaleRebatePolicyVo();
            Map<String, BigDecimal> amountMap = this.getAmountMap(formulaInfos, productCodes, customerVos, (SaleRebateComputeBuildParamVo)saleRebateComputeBuildParamVo, saleRebatePolicyVo);
            Validate.notNull(amountMap, (String)"\u8fd4\u5229\u516c\u5f0f\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            customerVos.forEach(cus -> formulaInfos.forEach(express -> {
                SaleRebateComputeParamVo param = new SaleRebateComputeParamVo();
                SaleRebatePolicyFormulaInfoVo saleRebatePolicyFormulaInfoVo = (SaleRebatePolicyFormulaInfoVo)this.nebulaToolkitService.copyObjectByBlankList(express, SaleRebatePolicyFormulaInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
                param.setCusJson(JsonUtils.toJSONObject((Object)cus));
                param.setSaleRebatePolicyFormulaInfoVo(saleRebatePolicyFormulaInfoVo);
                param.setAmountMap(amountMap);
                param.setSaleRebateStartTime(saleRebateComputeBuildParamVo.getSaleRebateStartTime());
                param.setSaleRebateEndTime(saleRebateComputeBuildParamVo.getSaleRebateEndTime());
                param.setSaleRebateComputeStartTime(saleRebateComputeBuildParamVo.getSaleRebateStartTime());
                param.setSaleRebateComputeEndTime(saleRebateComputeBuildParamVo.getSaleRebateEndTime());
                param.setSaleRebatePolicyVo(saleRebateComputeBuildParamVo.getSaleRebatePolicyVo());
                param.setAllocationType(AllocationTypeEnum.FULL_AMOUNT.getKey());
                param.setSpeedNo(saleRebateComputeBuildParamVo.getSpeedNo());
                param.setCalculationTime(saleRebateComputeBuildParamVo.getCalculationTime());
                params.add(param);
            }));
        });
        return params;
    }

    private Map<String, BigDecimal> getAmountMap(List<SaleRebatePolicyFormulaInfoVo> formulaInfos, Set<String> productCodes, List<CustomerVo> customerVos, SaleRebateComputeBuildParamVo saleRebateComputeBuildParamVo, SaleRebatePolicyVo saleRebatePolicyVo) {
        Set<String> collect = SaleRebatePolicyCalculateUtil.getCriterionSet(formulaInfos);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        collect.forEach(s -> {
            List list = this.saleRebatePolicyCriterionRegisters.stream().filter(saleRebatePolicyCriterionRegister -> s.startsWith(saleRebatePolicyCriterionRegister.getSaleRebatePolicyCriterionCode())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u57fa\u51c6\u6ce8\u518c\u5668\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            SaleRebatePolicyCriterionRegister bean = (SaleRebatePolicyCriterionRegister)list.get(0);
            Set saleRebateCustomerSet = customerVos.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toSet());
            amountMap.putAll(bean.getAmountMap(s, saleRebatePolicyVo.getSaleRebatePolicyCode(), saleRebateCustomerSet, productCodes, saleRebateComputeBuildParamVo.getSaleRebateStartTime(), saleRebateComputeBuildParamVo.getSaleRebateEndTime(), saleRebatePolicyVo.getSaleRebateStartTime(), saleRebatePolicyVo.getSaleRebateEndTime()));
        });
        return amountMap;
    }
}

