/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.strategy;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyScopeInfo;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyScopeInfoService;
import com.biz.crm.dms.business.rebate.local.strategy.AbstractSaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.strategy.SaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.vo.scope.SaleRebatePolicyScopeChannelInfoVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ChannelForSaleRebateCustomerScopeStrategy
extends AbstractSaleRebateCustomerScopeStrategy
implements SaleRebateCustomerScopeStrategy<SaleRebatePolicyScopeChannelInfoVo> {
    @Autowired(required=false)
    private SaleRebatePolicyScopeInfoService SaleRebatePolicyScopeInfoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    private static final String SCOPE_TYPE = "channelForSalePolicy";
    private static final Integer SCOPE_SORT = 2;

    public String getScopeType() {
        return SCOPE_TYPE;
    }

    public String getScopeTypeDesc() {
        return "\u6e20 \u9053";
    }

    public Integer getSort() {
        return SCOPE_SORT;
    }

    public Set<String> onRequestCustomerCodes(String salePolicyCode, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode})) {
            return null;
        }
        List<SaleRebatePolicyScopeInfo> saleRebatePolicyScopeInfos = this.SaleRebatePolicyScopeInfoService.findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(tenantCode, salePolicyCode, SCOPE_TYPE);
        if (CollectionUtils.isEmpty(saleRebatePolicyScopeInfos)) {
            return null;
        }
        List includeList = saleRebatePolicyScopeInfos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCode())).map(SaleRebatePolicyScopeInfo::getCode).collect(Collectors.toList());
        List customerVos = this.customerVoService.findByChannels(includeList);
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            return null;
        }
        Set<String> customerCodes = customerVos.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toSet());
        return customerCodes;
    }
}

