/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.strategy;

import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyScopeInfo;
import com.biz.crm.dms.business.rebate.local.service.SaleRebatePolicyScopeInfoService;
import com.biz.crm.dms.business.rebate.local.strategy.AbstractSaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.strategy.SaleRebateCustomerScopeStrategy;
import com.biz.crm.dms.business.rebate.sdk.vo.scope.SaleRebatePolicyScopeDistributorInfoVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DistributorForSaleRebateCustomerScopeStrategy
extends AbstractSaleRebateCustomerScopeStrategy
implements SaleRebateCustomerScopeStrategy<SaleRebatePolicyScopeDistributorInfoVo> {
    @Autowired(required=false)
    private SaleRebatePolicyScopeInfoService salePolicyScopeInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    private static final String SCOPE_TYPE = "distributorForSalePolicy";
    private static final Integer SCOPE_SORT = 1;

    public String getScopeType() {
        return SCOPE_TYPE;
    }

    public String getScopeTypeDesc() {
        return "\u5ba2 \u6237";
    }

    public Integer getSort() {
        return SCOPE_SORT;
    }

    public Set<String> onRequestCustomerCodes(String salePolicyCode, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode})) {
            return null;
        }
        List<SaleRebatePolicyScopeInfo> saleRebatePolicyScopeInfos = this.salePolicyScopeInfoService.findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(tenantCode, salePolicyCode, SCOPE_TYPE);
        if (CollectionUtils.isEmpty(saleRebatePolicyScopeInfos)) {
            return null;
        }
        List includeList = saleRebatePolicyScopeInfos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCode())).map(SaleRebatePolicyScopeInfo::getCode).collect(Collectors.toList());
        List customerVos = this.customerVoService.findByCustomerCodes(includeList);
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            return null;
        }
        Set<String> customerCodes = customerVos.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toSet());
        return customerCodes;
    }
}

