/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.utils;

import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.FelEngineImpl;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MathUtil {
    private static final Pattern reg = Pattern.compile("-?\\d+(\\.\\d+)?");
    private static final Pattern pattern = Pattern.compile("[0-9]*[a-zA-Z]{1,}[0-9]*");
    private static final Pattern PREVENT_REPETITION = Pattern.compile("\\+{2,}|/{2,}|-{2,}|\\*{2,}");

    public static BigDecimal computeFormula(String expressionValue) {
        String expressionStr = expressionValue.replace(" ", "").replace("and", "&&");
        Validate.notEmpty((CharSequence)expressionStr, (String)"\u6839\u636e\u516c\u5f0f\u8ba1\u7b97\u65f6\uff0c\u516c\u5f0f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        expressionStr = MathUtil.formatFloat(expressionStr);
        try {
            MathUtil.validateSymbol(expressionStr);
            FelEngineImpl felEngine = new FelEngineImpl();
            return MathUtil.calcuConResultVal((FelEngine)felEngine, expressionStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u6570\u5b66\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u8868\u8fbe\u5f0f\u662f\u5426\u6b63\u786e\uff1a".concat(expressionValue), e);
        }
    }

    private static void validateSymbol(String expressionStr) {
        Matcher matcher = PREVENT_REPETITION.matcher(expressionStr);
        if (matcher.find()) {
            throw new IllegalArgumentException();
        }
    }

    public static Boolean computeCondition(String expressionValue) {
        String expressionStr = expressionValue.replace(" ", "").replace("and", "&&");
        Validate.notEmpty((CharSequence)expressionStr, (String)"\u6839\u636e\u516c\u5f0f\u8ba1\u7b97\u65f6\uff0c\u516c\u5f0f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        expressionStr = MathUtil.formatFloat(expressionStr);
        try {
            FelEngineImpl felEngine = new FelEngineImpl();
            return MathUtil.calconditionVal((FelEngine)felEngine, expressionStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u6570\u5b66\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u8868\u8fbe\u5f0f\u662f\u5426\u6b63\u786e\uff1a".concat(expressionValue), e);
        }
    }

    private static BigDecimal calcuConResultVal(FelEngine fel, String cacuStr) {
        BigDecimal rlt = BigDecimal.ZERO;
        cacuStr = cacuStr.replace("INT", "$('Math').floor");
        Object result = fel.eval(cacuStr = cacuStr.replace("-", "-1*"));
        if (result != null) {
            if (!Double.isNaN(Double.parseDouble(result.toString()))) {
                rlt = new BigDecimal(result.toString());
            }
            rlt = rlt.setScale(2, 4);
            return rlt;
        }
        return null;
    }

    private static Boolean calconditionVal(FelEngine fel, String cacuStr) {
        cacuStr = cacuStr.replace("INT", "$('Math').floor");
        Object result = fel.eval(cacuStr = cacuStr.replace("-", "-1*"));
        if (result instanceof Boolean) {
            return (boolean)((Boolean)result);
        }
        return null;
    }

    private static String formatFloat(String expressionStr) {
        StringBuilder builder = new StringBuilder(expressionStr);
        if (StringUtils.isBlank((CharSequence)expressionStr)) {
            return new String();
        }
        Matcher matcher = reg.matcher(expressionStr);
        int index = 0;
        while (matcher.find()) {
            String num = matcher.group();
            int start = matcher.start() + index;
            int end = matcher.end() + index;
            if (num.contains(".")) continue;
            builder.replace(start, end, num.concat(".0"));
            index += 2;
        }
        return builder.toString();
    }

    public static Set<String> getFormulaReplace(String formula) {
        Matcher matcher = pattern.matcher(formula);
        HashSet<String> variables = new HashSet<String>();
        while (matcher.find()) {
            String group = matcher.group();
            if (group.equals("INT") || group.equals("int") || group.equals("and")) continue;
            variables.add(group);
        }
        return variables;
    }

    public static String replaceDefaultVariable(String expressStr) {
        Validate.notEmpty((CharSequence)expressStr, (String)"\u66ff\u6362\u516c\u5f0f\u53d8\u91cf\u65f6\uff0c\u516c\u5f0f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Matcher matcher = pattern.matcher(expressStr);
        HashSet<String> variables = new HashSet<String>();
        while (matcher.find()) {
            variables.add(matcher.group());
        }
        String expressValue = expressStr;
        for (String entry : variables) {
            if ("and".equals(entry)) {
                expressValue = expressValue.replace(entry, "&&");
                continue;
            }
            if ("INT".equals(entry)) continue;
            expressValue = expressValue.replace(entry, String.valueOf(BigDecimal.ONE));
        }
        return expressValue;
    }
}

