/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.utils;

import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateExecutionDateRangeVo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SaleRebateCycleUtil {
    private static final SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy-MM");
    private static final SimpleDateFormat formatYear = new SimpleDateFormat("yyyy");

    public static Date getMonthLastday(Date saleRebateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebateTime);
        int maxDay = calendar.getActualMaximum(5);
        calendar.set(5, maxDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getLastday(Date saleRebateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebateTime);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getMonthFirstday(Date saleRebateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebateTime);
        int minDay = calendar.getActualMinimum(5);
        calendar.set(5, minDay);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getFirstday(Date saleRebateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebateTime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static int getQuarter(int month) {
        if (month == 1 || month == 2 || month == 3) {
            return 1;
        }
        if (month == 4 || month == 5 || month == 6) {
            return 2;
        }
        if (month == 7 || month == 8 || month == 9) {
            return 3;
        }
        return 4;
    }

    public static int getHalfYear(int month) {
        if (month <= 6) {
            return 1;
        }
        return 2;
    }

    public static String createCronExpression() {
        StringBuffer cronExp = new StringBuffer("");
        cronExp.append(0).append(" ");
        cronExp.append(0).append(" ");
        cronExp.append(0).append(" ");
        cronExp.append("* ");
        cronExp.append("* ");
        cronExp.append("?");
        return cronExp.toString();
    }

    public static Map<String, SaleRebateExecutionDateRangeVo> getSaleRebateExecutionYearMap(SaleRebatePolicyDto saleRebatePolicyDto) {
        String endYear = formatYear.format(saleRebatePolicyDto.getSaleRebateEndTime());
        String startYear = formatYear.format(saleRebatePolicyDto.getSaleRebateStartTime());
        Calendar calendarStart = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        calendarStart.setTime(saleRebatePolicyDto.getSaleRebateStartTime());
        calendarEnd.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
        calendarEnd.add(1, 1);
        HashMap<String, SaleRebateExecutionDateRangeVo> map = new HashMap<String, SaleRebateExecutionDateRangeVo>();
        while (formatYear.format(calendarStart.getTime()).compareTo(formatYear.format(calendarEnd.getTime())) < 0) {
            String year = formatYear.format(calendarStart.getTime());
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            Calendar calendar = Calendar.getInstance();
            if (startYear.equals(year)) {
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(saleRebatePolicyDto.getSaleRebateStartTime());
            } else {
                Calendar calstart = Calendar.getInstance();
                calstart.set(1, Integer.valueOf(year));
                calstart.set(6, calstart.getActualMinimum(6));
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(SaleRebateCycleUtil.getFirstday(calstart.getTime()));
            }
            if (year.equals(endYear)) {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
                calendar.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
            } else {
                Calendar calEnd = Calendar.getInstance();
                calEnd.set(1, Integer.valueOf(year));
                calEnd.set(6, calEnd.getActualMaximum(6));
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(SaleRebateCycleUtil.getLastday(calEnd.getTime()));
                calendar.setTime(calEnd.getTime());
            }
            calendar.set(6, calendar.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
            map.put(formatDate.format(calendar.getTime()), saleRebateExecutionDateRangeVo);
            calendarStart.add(1, 1);
        }
        return map;
    }

    public static Map<String, SaleRebateExecutionDateRangeVo> getSaleRebateExecutionWeekMap(SaleRebatePolicyDto saleRebatePolicyDto) {
        Calendar calendarexec = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebatePolicyDto.getSaleRebateStartTime());
        HashMap<String, SaleRebateExecutionDateRangeVo> map = new HashMap<String, SaleRebateExecutionDateRangeVo>();
        String endTime = formatDate.format(saleRebatePolicyDto.getSaleRebateEndTime());
        int i = 0;
        while (formatDate.format(calendar.getTime()).compareTo(endTime) <= 0) {
            String execDate;
            Calendar cal;
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo;
            if (calendar.get(7) - 1 != 1 && i == 0) {
                saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(saleRebatePolicyDto.getSaleRebateStartTime());
                cal = Calendar.getInstance();
                cal.setTime(calendar.getTime());
                cal.add(5, 7 - cal.get(7) + 1);
                if (formatDate.format(cal.getTime()).compareTo(endTime) > 0) {
                    saleRebateExecutionDateRangeVo.setSaleRebateEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
                } else {
                    saleRebateExecutionDateRangeVo.setSaleRebateEndTime(SaleRebateCycleUtil.getLastday(cal.getTime()));
                }
                calendarexec.setTime(saleRebateExecutionDateRangeVo.getSaleRebateEndTime());
                calendarexec.set(6, calendarexec.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
                execDate = formatDate.format(calendarexec.getTime());
                map.put(execDate, saleRebateExecutionDateRangeVo);
            } else if (calendar.get(7) - 1 == 1) {
                saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
                cal = Calendar.getInstance();
                cal.setTime(calendar.getTime());
                cal.set(6, calendar.get(6) + 6);
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(SaleRebateCycleUtil.getFirstday(calendar.getTime()));
                if (formatDate.format(cal.getTime()).compareTo(endTime) >= 0) {
                    saleRebateExecutionDateRangeVo.setSaleRebateEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
                    calendarexec.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
                } else {
                    saleRebateExecutionDateRangeVo.setSaleRebateEndTime(SaleRebateCycleUtil.getLastday(cal.getTime()));
                    calendarexec.setTime(cal.getTime());
                }
                calendarexec.set(6, calendarexec.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
                execDate = formatDate.format(calendarexec.getTime());
                map.put(execDate, saleRebateExecutionDateRangeVo);
            }
            calendar.add(5, 1);
            ++i;
        }
        return map;
    }

    public static Map<String, SaleRebateExecutionDateRangeVo> getSaleRebateExecutionQuarterMap(SaleRebatePolicyDto saleRebatePolicyDto) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebatePolicyDto.getSaleRebateStartTime());
        Calendar calendarend = Calendar.getInstance();
        calendarend.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
        calendarend.add(2, 1);
        HashMap<String, SaleRebateExecutionDateRangeVo> map = new HashMap<String, SaleRebateExecutionDateRangeVo>();
        ArrayList<SaleRebateExecutionDateRangeVo> saleRebateExecutionDateRangeVos = new ArrayList<SaleRebateExecutionDateRangeVo>();
        while (formatMonth.format(calendar.getTime()).compareTo(formatMonth.format(calendarend.getTime())) < 0) {
            String startDate = formatMonth.format(calendar.getTime());
            String saleRebateStartDate = formatMonth.format(saleRebatePolicyDto.getSaleRebateStartTime());
            String saleRebateEndDate = formatMonth.format(saleRebatePolicyDto.getSaleRebateEndTime());
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            if (startDate.equals(saleRebateStartDate)) {
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(saleRebatePolicyDto.getSaleRebateStartTime());
            } else {
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(SaleRebateCycleUtil.getMonthFirstday(calendar.getTime()));
            }
            if (startDate.equals(saleRebateEndDate)) {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
            } else {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(SaleRebateCycleUtil.getMonthLastday(calendar.getTime()));
            }
            String[] format1 = formatMonth.format(saleRebateExecutionDateRangeVo.getSaleRebateEndTime()).split("-", 0);
            int quarter = SaleRebateCycleUtil.getQuarter(Integer.parseInt(format1[1]));
            saleRebateExecutionDateRangeVo.setSaleRebateQuarter(format1[0] + quarter);
            saleRebateExecutionDateRangeVos.add(saleRebateExecutionDateRangeVo);
            calendar.add(2, 1);
        }
        Map<String, List<SaleRebateExecutionDateRangeVo>> collect = saleRebateExecutionDateRangeVos.stream().collect(Collectors.groupingBy(SaleRebateExecutionDateRangeVo::getSaleRebateQuarter));
        Calendar calendarexec = Calendar.getInstance();
        collect.forEach((k, v) -> {
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            Date startTime = v.stream().map(o -> o.getSaleRebateStartTime()).distinct().min(Date::compareTo).get();
            Date endTime = v.stream().map(o -> o.getSaleRebateEndTime()).distinct().max(Date::compareTo).get();
            saleRebateExecutionDateRangeVo.setSaleRebateEndTime(endTime);
            saleRebateExecutionDateRangeVo.setSaleRebateStartTime(startTime);
            calendarexec.setTime(endTime);
            calendarexec.set(6, calendarexec.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
            String execDate = formatDate.format(calendarexec.getTime());
            map.put(execDate, saleRebateExecutionDateRangeVo);
        });
        return map;
    }

    public static Map<String, SaleRebateExecutionDateRangeVo> getSaleRebateExecutionMonthMap(SaleRebatePolicyDto saleRebatePolicyDto) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebatePolicyDto.getSaleRebateStartTime());
        Calendar calendarend = Calendar.getInstance();
        calendarend.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
        calendarend.add(2, 1);
        Calendar calendarexec = Calendar.getInstance();
        HashMap<String, SaleRebateExecutionDateRangeVo> map = new HashMap<String, SaleRebateExecutionDateRangeVo>();
        while (format.format(calendar.getTime()).compareTo(format.format(calendarend.getTime())) < 0) {
            String startDate = format.format(calendar.getTime());
            String saleRebateStartDate = format.format(saleRebatePolicyDto.getSaleRebateStartTime());
            String saleRebateEndDate = format.format(saleRebatePolicyDto.getSaleRebateEndTime());
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            if (startDate.equals(saleRebateStartDate)) {
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(saleRebatePolicyDto.getSaleRebateStartTime());
            } else {
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(SaleRebateCycleUtil.getMonthFirstday(calendar.getTime()));
            }
            if (startDate.equals(saleRebateEndDate)) {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
                calendarexec.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
            } else {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(SaleRebateCycleUtil.getMonthLastday(calendar.getTime()));
                calendarexec.setTime(SaleRebateCycleUtil.getMonthLastday(calendar.getTime()));
            }
            calendarexec.set(6, calendarexec.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
            String execDate = formatDate.format(calendarexec.getTime());
            map.put(execDate, saleRebateExecutionDateRangeVo);
            calendar.add(2, 1);
        }
        return map;
    }

    public static Map<String, SaleRebateExecutionDateRangeVo> getSaleRebateExecutionDayMap(SaleRebatePolicyDto saleRebatePolicyDto) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebatePolicyDto.getSaleRebateStartTime());
        Calendar calendarend = Calendar.getInstance();
        calendarend.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
        Calendar calendarexec = Calendar.getInstance();
        HashMap<String, SaleRebateExecutionDateRangeVo> map = new HashMap<String, SaleRebateExecutionDateRangeVo>();
        while (calendar.getTime().before(calendarend.getTime())) {
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            saleRebateExecutionDateRangeVo.setSaleRebateStartTime(calendar.getTime());
            if (formatDate.format(calendar.getTime()).equals(formatDate.format(saleRebatePolicyDto.getSaleRebateEndTime()))) {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
            } else {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(SaleRebateCycleUtil.getLastday(calendar.getTime()));
            }
            calendarexec.setTime(calendar.getTime());
            calendarexec.set(6, calendarexec.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
            String execDate = formatDate.format(calendarexec.getTime());
            map.put(execDate, saleRebateExecutionDateRangeVo);
            calendar.add(5, 1);
            calendar.setTime(SaleRebateCycleUtil.getFirstday(calendar.getTime()));
        }
        return map;
    }

    public static List<SaleRebateExecutionDateRangeVo> getExecutionQuarterList(Date saleRebateStartTime, Date saleRebateEndTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebateStartTime);
        Calendar calendarend = Calendar.getInstance();
        calendarend.setTime(saleRebateEndTime);
        calendarend.add(2, 1);
        ArrayList<SaleRebateExecutionDateRangeVo> list = new ArrayList<SaleRebateExecutionDateRangeVo>();
        ArrayList<SaleRebateExecutionDateRangeVo> saleRebateExecutionDateRangeVos = new ArrayList<SaleRebateExecutionDateRangeVo>();
        while (formatMonth.format(calendar.getTime()).compareTo(formatMonth.format(calendarend.getTime())) < 0) {
            String startDate = formatMonth.format(calendar.getTime());
            String saleRebateStartDate = formatMonth.format(saleRebateStartTime);
            String saleRebateEndDate = formatMonth.format(saleRebateEndTime);
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            if (startDate.equals(saleRebateStartDate)) {
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(saleRebateStartTime);
            } else {
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(SaleRebateCycleUtil.getMonthFirstday(calendar.getTime()));
            }
            if (startDate.equals(saleRebateEndDate)) {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(saleRebateEndTime);
            } else {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(SaleRebateCycleUtil.getMonthLastday(calendar.getTime()));
            }
            String[] format1 = formatMonth.format(saleRebateExecutionDateRangeVo.getSaleRebateEndTime()).split("-", 0);
            int quarter = SaleRebateCycleUtil.getQuarter(Integer.parseInt(format1[1]));
            saleRebateExecutionDateRangeVo.setSaleRebateQuarter(format1[0] + "-" + quarter);
            saleRebateExecutionDateRangeVos.add(saleRebateExecutionDateRangeVo);
            calendar.add(2, 1);
        }
        Map<String, List<SaleRebateExecutionDateRangeVo>> collect = saleRebateExecutionDateRangeVos.stream().collect(Collectors.groupingBy(SaleRebateExecutionDateRangeVo::getSaleRebateQuarter));
        collect.forEach((k, v) -> {
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            Date startTime = v.stream().map(o -> o.getSaleRebateStartTime()).distinct().min(Date::compareTo).get();
            Date endTime = v.stream().map(o -> o.getSaleRebateEndTime()).distinct().max(Date::compareTo).get();
            saleRebateExecutionDateRangeVo.setSaleRebateEndTime(endTime);
            saleRebateExecutionDateRangeVo.setSaleRebateStartTime(startTime);
            saleRebateExecutionDateRangeVo.setSaleRebateQuarter(k);
            list.add(saleRebateExecutionDateRangeVo);
        });
        return list;
    }

    public static Map<String, SaleRebateExecutionDateRangeVo> getSaleRebateExecutionHalfYearMap(SaleRebatePolicyDto saleRebatePolicyDto) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(saleRebatePolicyDto.getSaleRebateStartTime());
        Calendar calendarend = Calendar.getInstance();
        calendarend.setTime(saleRebatePolicyDto.getSaleRebateEndTime());
        calendarend.add(2, 1);
        HashMap<String, SaleRebateExecutionDateRangeVo> map = new HashMap<String, SaleRebateExecutionDateRangeVo>();
        ArrayList<SaleRebateExecutionDateRangeVo> saleRebateExecutionDateRangeVos = new ArrayList<SaleRebateExecutionDateRangeVo>();
        while (formatMonth.format(calendar.getTime()).compareTo(formatMonth.format(calendarend.getTime())) < 0) {
            String startDate = formatMonth.format(calendar.getTime());
            String saleRebateStartDate = formatMonth.format(saleRebatePolicyDto.getSaleRebateStartTime());
            String saleRebateEndDate = formatMonth.format(saleRebatePolicyDto.getSaleRebateEndTime());
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            if (startDate.equals(saleRebateStartDate)) {
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(saleRebatePolicyDto.getSaleRebateStartTime());
            } else {
                saleRebateExecutionDateRangeVo.setSaleRebateStartTime(SaleRebateCycleUtil.getMonthFirstday(calendar.getTime()));
            }
            if (startDate.equals(saleRebateEndDate)) {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(saleRebatePolicyDto.getSaleRebateEndTime());
            } else {
                saleRebateExecutionDateRangeVo.setSaleRebateEndTime(SaleRebateCycleUtil.getMonthLastday(calendar.getTime()));
            }
            String[] format1 = formatMonth.format(saleRebateExecutionDateRangeVo.getSaleRebateEndTime()).split("-", 0);
            int halfYear = SaleRebateCycleUtil.getHalfYear(Integer.parseInt(format1[1]));
            saleRebateExecutionDateRangeVo.setSaleRebateHalfYear(format1[0] + halfYear);
            saleRebateExecutionDateRangeVos.add(saleRebateExecutionDateRangeVo);
            calendar.add(2, 1);
        }
        Map<String, List<SaleRebateExecutionDateRangeVo>> collect = saleRebateExecutionDateRangeVos.stream().collect(Collectors.groupingBy(SaleRebateExecutionDateRangeVo::getSaleRebateHalfYear));
        Calendar calendarexec = Calendar.getInstance();
        collect.forEach((k, v) -> {
            SaleRebateExecutionDateRangeVo saleRebateExecutionDateRangeVo = new SaleRebateExecutionDateRangeVo();
            Date startTime = v.stream().map(o -> o.getSaleRebateStartTime()).distinct().min(Date::compareTo).get();
            Date endTime = v.stream().map(o -> o.getSaleRebateEndTime()).distinct().max(Date::compareTo).get();
            saleRebateExecutionDateRangeVo.setSaleRebateEndTime(endTime);
            saleRebateExecutionDateRangeVo.setSaleRebateStartTime(startTime);
            calendarexec.setTime(endTime);
            calendarexec.set(6, calendarexec.get(6) + saleRebatePolicyDto.getCalculateDayNum() + 1);
            String execDate = formatDate.format(calendarexec.getTime());
            map.put(execDate, saleRebateExecutionDateRangeVo);
        });
        return map;
    }
}

