/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.rebate.local.utils;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebateCalculationLog;
import com.biz.crm.dms.business.rebate.local.entity.SaleRebatePolicyDetail;
import com.biz.crm.dms.business.rebate.local.utils.MathUtil;
import com.biz.crm.dms.business.rebate.sdk.enums.BillTypeEnum;
import com.biz.crm.dms.business.rebate.sdk.enums.SaleOnAccountStatusEnums;
import com.biz.crm.dms.business.rebate.sdk.enums.SaleRebatePolicyProductTypeEnum;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateComputeParamVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateConditionResultVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateFormulaResultVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyFormulaInfoVo;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebatePolicyVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.util.JsonUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class SaleRebatePolicyCalculateUtil {
    private static final SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy-MM");

    public static SaleRebateFormulaResultVo computeRebateExpression(String expressStr, String expressStrName, SaleRebateComputeParamVo param) {
        Validate.notEmpty((CharSequence)expressStr, (String)"\u89e3\u6790\u8fd4\u5229\u8868\u8fbe\u5f0f\u65f6\uff0c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SaleRebateFormulaResultVo result = new SaleRebateFormulaResultVo();
        SaleRebateConditionResultVo conditionComputeResult = SaleRebatePolicyCalculateUtil.replaceVariable(expressStr, expressStrName, param);
        String expressValue = conditionComputeResult.getExpressValue();
        BigDecimal computeResult = MathUtil.computeFormula(expressValue);
        Validate.notNull((Object)computeResult, (String)"\u8fd4\u5229\u516c\u5f0f\u3010%s\u3011\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u662f\u5426\u6b63\u786e", (Object[])new Object[]{expressStr});
        result.setExpressStr(expressStr);
        result.setExpressStrName(expressStrName);
        result.setExpressValue(expressValue);
        result.setValue(computeResult);
        result.setComputeProcess(conditionComputeResult.getComputeProcess());
        result.setComputeProcessResult(conditionComputeResult.getComputeProcessResult());
        return result;
    }

    public static SaleRebateConditionResultVo computeConditionExpression(String expressStr, String expressStrName, SaleRebateComputeParamVo param) {
        Validate.notEmpty((CharSequence)expressStr, (String)"\u89e3\u6790\u6761\u4ef6\u8868\u8fbe\u5f0f\u65f6\uff0c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SaleRebateConditionResultVo result = SaleRebatePolicyCalculateUtil.replaceVariable(expressStr, expressStrName, param);
        String expressValue = result.getExpressValue();
        Boolean computeResult = MathUtil.computeCondition(expressValue);
        Validate.notNull((Object)computeResult, (String)"\u8fd4\u5229\u6761\u4ef6\u516c\u5f0f\u3010%s\u3011\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u662f\u5426\u6b63\u786e", (Object[])new Object[]{expressStr});
        result.setValue(computeResult.booleanValue());
        result.setExpressStr(expressStr);
        result.setExpressStrName(expressStrName);
        return result;
    }

    public static SaleRebateConditionResultVo replaceVariable(String expressStr, String expressStrName, SaleRebateComputeParamVo param) {
        Validate.notEmpty((CharSequence)expressStr, (String)"\u66ff\u6362\u516c\u5f0f\u53d8\u91cf\u65f6\uff0c\u516c\u5f0f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SaleRebateConditionResultVo result = new SaleRebateConditionResultVo();
        result.setExpressStr(expressStr);
        result.setExpressStrName(expressStrName);
        Set<String> variables = MathUtil.getFormulaReplace(expressStr);
        Map variableMap = param.getAmountMap();
        CustomerVo customerVo = (CustomerVo)JsonUtils.json2Obj((String)param.getCusJson().toJSONString(), CustomerVo.class);
        String expressValue = expressStr;
        String expressProperties = new String();
        String expressProcess = new String();
        for (String entry : variables) {
            String k = entry + customerVo.getCustomerCode();
            String v = ((BigDecimal)variableMap.get(k)).toString();
            Validate.notEmpty((CharSequence)v, (String)"%s\u65f6\u68c0\u6d4b\u5230\u53d8\u91cf\u3010%s\u3011\u503c\u4e3a\u7a7a", (Object[])new Object[]{BooleanEnum.FALSE.getNumStr().equals(param.getIsTest()) ? "\u8ba1\u7b97" : "\u6d4b\u8bd5\u8ba1\u7b97", k});
            expressValue = expressValue.replace(entry, v);
            expressProperties = String.join((CharSequence)";", expressProperties, String.join((CharSequence)",", String.join((CharSequence)":", "\u53d8\u91cf", entry), String.join((CharSequence)":", "\u53d6\u503c", v)));
            expressProcess = String.join((CharSequence)";", expressProcess, String.join((CharSequence)":", k, v));
        }
        if (StringUtils.isNotEmpty((CharSequence)expressProperties)) {
            expressProperties = expressProperties.substring(1);
        }
        if (StringUtils.isNotEmpty((CharSequence)expressProcess)) {
            expressProcess = expressProcess.substring(1);
        }
        result.setExpressValue(expressValue);
        result.setComputeProcessResult(expressProperties);
        result.setComputeProcess(expressProcess);
        return result;
    }

    public static Set<String> getCriterionSet(List<SaleRebatePolicyFormulaInfoVo> formulaInfos) {
        HashSet<String> conditionAndFormula = new HashSet<String>();
        for (SaleRebatePolicyFormulaInfoVo policyFormula : formulaInfos) {
            Set<String> saleRebateCondition = MathUtil.getFormulaReplace(policyFormula.getSaleRebatePolicyCondition());
            Set<String> saleRebateformula = MathUtil.getFormulaReplace(policyFormula.getSaleRebatePolicyFormula());
            conditionAndFormula.addAll(saleRebateformula);
            conditionAndFormula.addAll(saleRebateCondition);
        }
        return conditionAndFormula;
    }

    public static SaleRebatePolicyDetail buildDetail(SaleRebateComputeParamVo param, SaleRebateFormulaResultVo executeComputeResult, CustomerVo customerVo) {
        Validate.notNull((Object)param, (String)"\u4fdd\u5b58\u660e\u7ec6\u6570\u636e\u65f6\uff0c\u8ba1\u7b97\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SaleRebatePolicyVo rebateVo = param.getSaleRebatePolicyVo();
        Validate.notNull((Object)rebateVo, (String)"\u4fdd\u5b58\u660e\u7ec6\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)executeComputeResult, (String)"\u4fdd\u5b58\u660e\u7ec6\u6570\u636e\u65f6\uff0c\u8ba1\u7b97\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SaleRebatePolicyDetail saleRebatePolicyDetail = new SaleRebatePolicyDetail();
        saleRebatePolicyDetail.setSaleRebatePolicyCode(rebateVo.getSaleRebatePolicyCode());
        saleRebatePolicyDetail.setSaleRebatePolicyName(rebateVo.getSaleRebatePolicyName());
        saleRebatePolicyDetail.setCustomerCode(customerVo.getCustomerCode());
        saleRebatePolicyDetail.setCustomerName(customerVo.getCustomerName());
        List orgList = customerVo.getOrgList();
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            CustomerRelateOrgVo customerRelateOrgVo = (CustomerRelateOrgVo)orgList.get(0);
            saleRebatePolicyDetail.setOrgCode(customerRelateOrgVo.getOrgCode());
            saleRebatePolicyDetail.setOrgName(customerRelateOrgVo.getOrgName());
        }
        saleRebatePolicyDetail.setSaleRebateType(rebateVo.getSaleRebateType());
        saleRebatePolicyDetail.setSaleRebateTypeName(rebateVo.getSaleRebateTypeName());
        saleRebatePolicyDetail.setSaleRebatePolicyCycle(rebateVo.getSaleRebatePolicyCycle());
        saleRebatePolicyDetail.setSaleRebatePolicyCycleName(rebateVo.getSaleRebatePolicyCycleName());
        saleRebatePolicyDetail.setSaleRebateStartTime(param.getSaleRebateComputeStartTime());
        saleRebatePolicyDetail.setSaleRebateEndTime(param.getSaleRebateComputeEndTime());
        saleRebatePolicyDetail.setSaleRebateCalculationYears(formatMonth.format(new Date()));
        saleRebatePolicyDetail.setCalculationTime(param.getCalculationTime());
        saleRebatePolicyDetail.setSpeedNo(param.getSpeedNo());
        saleRebatePolicyDetail.setBillType(rebateVo.getBillType());
        if (BillTypeEnum.AUTO_KEEP_BOOKS.getKey().equals(rebateVo.getBillType())) {
            saleRebatePolicyDetail.setBillStatus(SaleOnAccountStatusEnums.ON_ACCOUNT.getKey());
        } else {
            saleRebatePolicyDetail.setBillStatus(SaleOnAccountStatusEnums.WAIT_ACCOUNT.getKey());
        }
        saleRebatePolicyDetail.setIsTest(param.getIsTest());
        saleRebatePolicyDetail.setProductType(param.getProductType());
        if (param.getProductType() != null) {
            if (SaleRebatePolicyProductTypeEnum.PRODUCT.getKey().equals(param.getProductType())) {
                saleRebatePolicyDetail.setProductCode(param.getCode());
                saleRebatePolicyDetail.setProductName(param.getName());
            } else {
                saleRebatePolicyDetail.setProductLevelCode(param.getCode());
                saleRebatePolicyDetail.setProductLevelName(param.getName());
            }
        }
        saleRebatePolicyDetail.setAllocationType(param.getAllocationType());
        saleRebatePolicyDetail.setRebateRatio(param.getRebateRatio());
        saleRebatePolicyDetail.setSaleRebatePolicyFormulaId(param.getSaleRebatePolicyFormulaInfoVo().getId());
        return saleRebatePolicyDetail;
    }

    public static SaleRebateCalculationLog buildComputeLog(SaleRebateComputeParamVo param, SaleRebateConditionResultVo conditionResult, SaleRebateFormulaResultVo executeComputeResult, String detailId) {
        CustomerVo customerVo = (CustomerVo)JsonUtils.json2Obj((String)param.getCusJson().toJSONString(), CustomerVo.class);
        Validate.notNull((Object)param, (String)"\u4fdd\u5b58\u660e\u7ec6\u6570\u636e\u65f6\uff0c\u8ba1\u7b97\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SaleRebatePolicyVo saleRebatePolicyVo = param.getSaleRebatePolicyVo();
        Validate.notNull((Object)conditionResult, (String)"\u4fdd\u5b58\u660e\u7ec6\u6570\u636e\u65f6\uff0c\u8ba1\u7b97\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SaleRebateCalculationLog saleRebateCalculationLog = new SaleRebateCalculationLog();
        saleRebateCalculationLog.setSaleRebatePolicyCode(saleRebatePolicyVo.getSaleRebatePolicyCode());
        saleRebateCalculationLog.setSaleRebatePolicyName(saleRebatePolicyVo.getSaleRebatePolicyName());
        saleRebateCalculationLog.setCustomerCode(customerVo.getCustomerCode());
        saleRebateCalculationLog.setCustomerName(customerVo.getCustomerName());
        saleRebateCalculationLog.setSaleRebateCalculationYears(formatMonth.format(param.getCalculationTime()));
        saleRebateCalculationLog.setSaleRebatePolicyCondition(conditionResult.getExpressStrName());
        saleRebateCalculationLog.setSaleRebatePolicyConditionProcess(conditionResult.getComputeProcessResult());
        saleRebateCalculationLog.setSaleRebateResults(conditionResult.isValue());
        if (Objects.nonNull(executeComputeResult)) {
            saleRebateCalculationLog.setSaleRebatePolicyFormula(executeComputeResult.getExpressStrName());
            saleRebateCalculationLog.setSaleRebatePolicyFormulaProcess(executeComputeResult.getComputeProcessResult());
            saleRebateCalculationLog.setSaleRebateCalculationResults(executeComputeResult.getValue());
        }
        saleRebateCalculationLog.setIsTest(param.getIsTest());
        saleRebateCalculationLog.setAllocationType(param.getAllocationType());
        saleRebateCalculationLog.setRebateRatio(param.getRebateRatio());
        saleRebateCalculationLog.setSaleRebatePolicyDetailId(detailId);
        saleRebateCalculationLog.setSpeedNo(param.getSpeedNo());
        return saleRebateCalculationLog;
    }

    public static void validateCal(SaleRebateComputeParamVo param) {
        Validate.notNull((Object)param, (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)param.getCusJson(), (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)param.getSaleRebatePolicyVo(), (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)param.getSpeedNo(), (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u8ba1\u7b97\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)param.getSaleRebatePolicyFormulaInfoVo(), (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)param.getIsTest(), (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u662f\u5426\u6d4b\u8bd5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

