package com.biz.crm.dms.business.rebate.sdk.register;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;

/**
 * @description: 返利政策基准注册(也叫返利变量 ）
 * @author: rentao
 * @date: 2022/2/16 16:42
 */
public interface SaleRebatePolicyCriterionRegister {

  /**
   * 得到一个返利政策基准策略编码 必须要保证全局唯一性
   *
   * @return {@link String}
   * @author rentao
   * @date
   */
  String getSaleRebatePolicyCriterionCode();

  /**
   * 得到一个返利政策基准策略名称
   *
   * @return {@link String}
   * @author rentao
   * @date
   */
  String getSaleRebatePolicyCriterionName();

  /**
   * 排序
   *
   * @return {@link Integer}
   * @author rentao
   * @date
   */
  Integer getCriterionSort();

  /**
   * 查询金钱
   * key: 返利变量标识 + 客户编码
   * value： 结果值（数量，金额，目标值等）
   *
   * @param saleRebatePolicyCriterionCode 返利政策变量编码
   * @param saleRebatePolicyCode 返利政策编码
   * @param cusCodes            客户集合
   * @param productCode         产品集合
   * @param startTime           本次执行 开始时间
   * @param endTime             本次执行 结束时间
   * @param saleRebateStartTime 政策开始时间
   * @param saleRebateEndTime   政策结束时间
   * @return {@link Map}<{@link String}, {@link BigDecimal}>
   * @author rentao
   * @date
   */
  Map<String, BigDecimal> getAmountMap(String saleRebatePolicyCriterionCode,String saleRebatePolicyCode, Set<String> cusCodes, Set<String> productCode, Date startTime, Date endTime, Date saleRebateStartTime, Date saleRebateEndTime);

  /**
   * 公式默认金额 （只提供给验证公式用）
   *
   * @return {@link BigDecimal}
   * @author rentao
   * @date
   */
  default BigDecimal getDefaultAmount() {
    return BigDecimal.ZERO;
  }

  /**
   * 是可配置的
   *
   * @return {@link Boolean}
   */
  default Boolean isConfigurable(){
    return Boolean.FALSE;
  }
}
