package com.biz.crm.dms.business.rebate.sdk.register;

import com.biz.crm.dms.business.rebate.sdk.dto.SaleRebatePolicyDto;
import com.biz.crm.dms.business.rebate.sdk.vo.SaleRebateExecutionDateRangeVo;
import java.util.Date;

/**
 * @description: 返利周期注册
 * @author: rentao
 * @date: 2022/2/16 16:18
 */
public interface SaleRebatePolicyCycleRegister {

  /**
   *
   * 得到一个返利周期编码
   * @author rentao
   * @date
   */
  String getSaleRebatePolicyCycleCode();

  /**
   *
   * 得到一个返利周期名称
   * @author rentao
   * @date
   */
  String getSaleRebatePolicyCycleName();

  /**
   * 拿到要素排序列表排序
   */
  Integer getCycleSort();

  /**
   *
   * （创建定时任务）
   * @author rentao
   * @date
   */
  void onRequestcreate(SaleRebatePolicyDto saleRebatePolicyDto);



  /**
   *
   * （编辑定时任务）
   * @author rentao
   * @date
   */
  void onRequestUpdate(SaleRebatePolicyDto saleRebatePolicyDto);

  /**
   *
   * 本次定时任务执行时间范围
   * 如果是企业财年（财年影响到 月 季度 年度）
   * 本次执行范围应该为财年范围 开始时间和结束时间 是通过和政策执行开始结束时间比较后结果。
   * @param saleRebatePolicyDto
   * @author rentao
   * @date
   */
  SaleRebateExecutionDateRangeVo getExecutionDateRangeVo(SaleRebatePolicyDto saleRebatePolicyDto);

}

