package com.biz.crm.dms.business.rebate.sdk.vo;

import com.bizunited.nebula.common.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 返利公式vo
 * @author: rentao
 * @date: 2022/3/8 17:02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SaleRebatePolicyFormulaInfoVo", description = "返利公式vo")
public class SaleRebatePolicyFormulaInfoVo extends TenantVo {
  private static final long serialVersionUID = -6838481083853694077L;
  /**
   * 返利政策业务编号
   */
  @ApiModelProperty("返利政策业务编号")
  private String saleRebatePolicyCode;

  /**
   * 返利条件
   */
  @ApiModelProperty("返利条件")
  private String saleRebatePolicyCondition;

  /**
   * 返利条件（展示用）
   */
  @ApiModelProperty("返利条件（展示用）")
  private String saleRebatePolicyConditionName;

  /**
   * 返利公式
   */
  @ApiModelProperty("返利公式")
  private String saleRebatePolicyFormula;

  /**
   * 返利公式（展示用）
   */
  @ApiModelProperty("返利公式（展示用）")
  private String saleRebatePolicyFormulaName;
}
