package com.biz.crm.dms.business.reconciliation.local.context.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-21 19:59.
 */

import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationtemplate.ReconciliationTemplateRangeRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.ReconciliationTemplateRangeInfo.ReconciliationTemplateRangeInfoVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @program: crm-dms
 * @description: 对账规则生效范围注册器上下文
 * @author: Bao Hongbin
 * @create: 2021-12-21 19:59
 **/
@Component
public class ReconciliationTemplateRangeContext {
  /**
   * 储存生效范围类型和生效范围基本信息的映射关系
   */
  private static final Map<String, ReconciliationTemplateRangeInfoVo> RANGE_INFO_CACHE = new ConcurrentHashMap<>();

  /**
   * 储存生效范围类型和生效范围注册器的映射关系
   */
  private static final Map<String, ReconciliationTemplateRangeRegister> RANGE_REGISTERS_CACHE = new ConcurrentHashMap<>();

  @Autowired(required = false)
  public ReconciliationTemplateRangeContext(List<ReconciliationTemplateRangeRegister> rangeRegisters) {
    if (CollectionUtils.isNotEmpty(rangeRegisters)) {
      for (ReconciliationTemplateRangeRegister rangeRegister : rangeRegisters) {
        ReconciliationTemplateRangeInfoVo reconciliationRangeInfo = rangeRegister.getReconciliationRangeInfo();
        Validate.notNull(reconciliationRangeInfo, "无法获取到对账规则生效范围的基本信息");
        RANGE_INFO_CACHE.put(reconciliationRangeInfo.getRangeType(), reconciliationRangeInfo);
        RANGE_REGISTERS_CACHE.put(reconciliationRangeInfo.getRangeType(), rangeRegister);
      }
    }
  }

  /**
   * 获取所有生效范围基本信息
   *
   * @return 生效范围基本信息集合
   */
  public List<ReconciliationTemplateRangeInfoVo> getAllRangeInfo() {
    if (CollectionUtils.isEmpty(RANGE_INFO_CACHE.values())) {
      return (List<ReconciliationTemplateRangeInfoVo>) RANGE_INFO_CACHE.values();
    }
    //排序
    List<ReconciliationTemplateRangeInfoVo> reconciliationTemplateRangeInfoVos = new ArrayList<>(RANGE_INFO_CACHE.values());
    reconciliationTemplateRangeInfoVos.sort(Comparator.comparing(ReconciliationTemplateRangeInfoVo::getRangeSort));
    return reconciliationTemplateRangeInfoVos;
  }

  /**
   * 根据生效范围类型获取生效范围注册器
   *
   * @param rangeType 生效范围类型
   * @return 生效范围注册器
   */
  public ReconciliationTemplateRangeRegister getRangeRegisterByCode(String rangeType) {
    if (StringUtils.isBlank(rangeType)) {
      return null;
    }
    if (CollectionUtils.isEmpty(RANGE_REGISTERS_CACHE.values())) {
      return null;
    }
    return RANGE_REGISTERS_CACHE.get(rangeType);
  }
}
