package com.biz.crm.dms.business.reconciliation.local.controller.reconciliationletter;
/**
 * Created by Bao Hongbin on 2021-12-23 19:59.
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.ReconciliationLetterVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterContactRecordDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterManualCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterPaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter.ReconciliationLetterVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账函控制器
 * @author: Bao Hongbin
 * @create: 2021-12-23 19:59
 **/
@Api(tags = "对账函：ReconciliationLetterVo：与对账函相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/reconciliation/letter")
public class ReconciliationLetterVoController {
  @Autowired(required = false)
  private ReconciliationLetterVoService reconciliationLetterVoService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<ReconciliationLetterVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "reconciliationLetterPaginationDto", value = "分页Dto") ReconciliationLetterPaginationDto reconciliationLetterPaginationDto) {
    try {
      Page<ReconciliationLetterVo> result = this.reconciliationLetterVoService.findByConditions(pageable, reconciliationLetterPaginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 按照ProductLevel实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id 主键
   */
  @ApiOperation(value = "按照ProductLevel实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @GetMapping("/findDetailsById")
  public Result<ReconciliationLetterVo> findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      ReconciliationLetterVo result = this.reconciliationLetterVoService.findDetailsById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过对账规则手动触发创建对账函
   */
  @ApiOperation(value = "通过对账规则手动触发创建对账函")
  @PostMapping(value = "/handleManualGenerate")
  public Result<?> handleManualGenerate(
      @RequestBody @ApiParam(name = "productLevelCreateDto",
          value = "通过对账规则手动触发创建对账函dto") ReconciliationLetterManualCreateDto reconciliationLetterManualCreateDto) {
    try {
      this.reconciliationLetterVoService.handleManualGenerate(reconciliationLetterManualCreateDto);
      return Result.ok("通过对账规则手动触发创建对账函成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量自动更新指定对账函内容
   */
  @ApiOperation(value = "批量自动更新指定对账函内容")
  @PatchMapping(value = "/updateByIds")
  public Result<?> updateByIds(@RequestBody List<String> ids) {
    try {
      this.reconciliationLetterVoService.updateByIds(ids);
      return Result.ok("批量自动更新指定对账函内容成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量推送对账函给客户
   */
  @ApiOperation(value = "批量推送对账函给客户")
  @PatchMapping(value = "/handlePushCustomer")
  public Result<?> handlePushCustomer(@RequestBody List<String> ids) {
    try {
      this.reconciliationLetterVoService.handlePushCustomer(ids);
      return Result.ok("批量推送对账函给客户成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户确认
   */
  @ApiOperation(value = "客户确认")
  @PostMapping("/handleCustomerConfirm")
  public Result<?> handleCustomerConfirm(@RequestBody List<String> ids) {
    try {
      this.reconciliationLetterVoService.handleCustomerConfirm(ids);
      return Result.ok("客户确认成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestParam("ids") List<String> ids) {
    try {
      this.reconciliationLetterVoService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户提出疑问
   */
  @ApiOperation(value = "客户提出疑问")
  @PostMapping(value = "/handleCustomerQuestion")
  public Result<?> handleCustomerQuestion(
      @RequestBody @ApiParam(name = "reconciliationLetterContactRecordDto",
          value = "客户提出疑问dto") ReconciliationLetterContactRecordDto reconciliationLetterContactRecordDto) {
    try {
      this.reconciliationLetterVoService.handleCustomerQuestion(reconciliationLetterContactRecordDto);
      return Result.ok("客户提出疑问成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 厂商答复
   */
  @ApiOperation(value = "厂商答复")
  @PostMapping(value = "/handleManufacturerAnswer")
  public Result<?> handleManufacturerAnswer(
      @RequestBody @ApiParam(name = "reconciliationLetterContactRecordDto",
          value = "厂商答复dto") ReconciliationLetterContactRecordDto reconciliationLetterContactRecordDto) {
    try {
      this.reconciliationLetterVoService.handleManufacturerAnswer(reconciliationLetterContactRecordDto);
      return Result.ok("厂商答复成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户-对账函分页查询
   *
   * @return
   */
  @ApiOperation(value = "客户-对账函分页查询", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByReconciliationLetterPaginationDto")
  public Result<Page<ReconciliationLetterVo>> findByReconciliationLetterPaginationDto(@PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "reconciliationLetterPaginationDto", value = "分页Dto") ReconciliationLetterPaginationDto reconciliationLetterPaginationDto) {
    try {
      Page<ReconciliationLetterVo> result = this.reconciliationLetterVoService.findByReconciliationLetterPaginationDto(pageable, reconciliationLetterPaginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户-待客户确认对账函数量
   *
   * @return
   */
  @ApiOperation(value = "客户-待客户确认对账函数量")
  @GetMapping("findWaitConfirmationCountByCurrentCustomer")
  public Result<Integer> findCountByCurrentCustomer(@ApiParam(name = "reconciliationLetterPaginationDto", value = "分页Dto") ReconciliationLetterPaginationDto reconciliationLetterPaginationDto) {
    try {
      Integer count = this.reconciliationLetterVoService.findWaitConfirmationCountByCurrentCustomer(reconciliationLetterPaginationDto);
      return Result.ok(count);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
