package com.biz.crm.dms.business.reconciliation.local.controller.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-23 20:01.
 */

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.reconciliation.local.context.reconciliationtemplate.ReconciliationTemplateRangeContext;
import com.biz.crm.dms.business.reconciliation.sdk.vo.ReconciliationTemplateRangeInfo.ReconciliationTemplateRangeInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账规则生效范围信息控制器
 * @author: Bao Hongbin
 * @create: 2021-12-23 20:01
 **/
@Api(tags = "对账规则生效范围信息：ReconciliationElementInfo：获取可用的对账规则生效范围信息")
@Slf4j
@RestController
@RequestMapping("/v1/reconciliation/template/rangeinfo")
public class ReconciliationTemplateRangeInfoController {
  @Autowired(required = false)
  private ReconciliationTemplateRangeContext rangeContext;

  /**
   * 获取所有的对账规则生效范围信息
   */
  @ApiOperation(value = "获取所有的对账规则生效范围信息")
  @GetMapping("/findAll")
  public Result<List<ReconciliationTemplateRangeInfoVo>> findAll() {
    try {
      List<ReconciliationTemplateRangeInfoVo> result = this.rangeContext.getAllRangeInfo();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
